varying vec4 diffuse;
varying vec4 ambient;
varying vec3 halfVector;
varying vec3 lightdirection;
varying vec3 normal;

varying float distanceToLight;
varying float cameraDistance;
varying float polygonalpha;

varying vec2 texturecoord;

uniform float fogstart;
uniform float fogend;

void main(void)
{
	vec3 interpolatedNormal;
	float angledot;
	float angledot2;

	//take ambient as base color
	vec4 color = ambient;
	vec4 specular = vec4(0.0, 0.0, 0.0, 1.0);

	interpolatedNormal = normalize(normal);
	angledot = max(dot(interpolatedNormal, lightdirection), 0.0);
/*
	if (angledot > 0.0)
	{
		float att = 1.0 / (gl_LightSource[0].constantAttenuation +
				gl_LightSource[0].linearAttenuation * distanceToLight +
				gl_LightSource[0].quadraticAttenuation * distanceToLight * distanceToLight);
		//add diffuse component
		color += att * angledot * diffuse;

		vec3 halfn = normalize(halfVector);
		angledot2 = max(dot(interpolatedNormal, halfn), 0.0);
		
		//calculate specular component
		specular = att * gl_FrontMaterial.specular * gl_LightSource[0].specular * pow(angledot2, gl_FrontMaterial.shininess);
	}
*/	
	float foglerp = 0.0;
	
	vec4 finalcolor = diffuse;//+ specular;
	if (cameraDistance < fogstart)
	{
	}
	else if (cameraDistance > fogstart && cameraDistance < fogend)
	{
		foglerp = (cameraDistance - fogstart) / (fogend - fogstart);
	}
	else
	{
		foglerp = 1.0;
	}
	
	finalcolor.a = polygonalpha;
/*	
	if (texturecoord.x > 0.05 && texturecoord.x < 0.95 && texturecoord.y > 0.05 && texturecoord.y < 0.95)
	{
		gl_FragColor = finalcolor;// + vec4(1.0, 1.0, 1.0, 0.0) * foglerp;
	}
	else
	{
		gl_FragColor = vec4(0.0, 0.0, 0.0, finalcolor.a) * foglerp;
	}
*/
	gl_FragColor = finalcolor + vec4(1.0, 1.0, 1.0, 0.0) * foglerp;
}