/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.bounding.BoundingBox;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.control.UpdateControl;
import com.jme3.terrain.Terrain;
import com.jme3.terrain.geomipmap.LRUCache;
import com.jme3.terrain.geomipmap.TerrainGridListener;
import com.jme3.terrain.geomipmap.TerrainGridTileLoader;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.heightmap.HeightMap;
import com.jme3.terrain.heightmap.HeightMapGrid;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerrainGrid
extends TerrainQuad {
    protected static final Logger log = Logger.getLogger(TerrainGrid.class.getCanonicalName());
    protected Vector3f currentCamCell = Vector3f.ZERO;
    protected int quarterSize;
    protected int quadSize;
    protected HeightMapGrid heightMapGrid;
    private TerrainGridTileLoader gridTileLoader;
    protected Vector3f[] quadIndex;
    protected Set<TerrainGridListener> listeners = new HashSet<TerrainGridListener>();
    protected Material material;
    protected LRUCache<Vector3f, TerrainQuad> cache = new LRUCache(16);
    protected int cellsLoaded = 0;
    protected int[] gridOffset;
    protected boolean runOnce = false;
    protected ExecutorService cacheExecutor;

    protected boolean isCenter(int quadIndex) {
        return quadIndex == 9 || quadIndex == 5 || quadIndex == 10 || quadIndex == 6;
    }

    protected int getQuadrant(int quadIndex) {
        if (quadIndex == 5) {
            return 1;
        }
        if (quadIndex == 9) {
            return 2;
        }
        if (quadIndex == 6) {
            return 3;
        }
        if (quadIndex == 10) {
            return 4;
        }
        return 0;
    }

    public TerrainGrid(String name, int patchSize, int maxVisibleSize, Vector3f scale, TerrainGridTileLoader terrainQuadGrid, Vector2f offset, float offsetAmount) {
        this.name = name;
        this.patchSize = patchSize;
        this.size = maxVisibleSize;
        this.stepScale = scale;
        this.offset = offset;
        this.offsetAmount = offsetAmount;
        this.initData();
        this.gridTileLoader = terrainQuadGrid;
        terrainQuadGrid.setPatchSize(this.patchSize);
        terrainQuadGrid.setQuadSize(this.quadSize);
        this.addControl((Control)new UpdateControl());
    }

    public TerrainGrid(String name, int patchSize, int maxVisibleSize, Vector3f scale, TerrainGridTileLoader terrainQuadGrid) {
        this(name, patchSize, maxVisibleSize, scale, terrainQuadGrid, new Vector2f(), 0.0f);
    }

    public TerrainGrid(String name, int patchSize, int maxVisibleSize, TerrainGridTileLoader terrainQuadGrid) {
        this(name, patchSize, maxVisibleSize, Vector3f.UNIT_XYZ, terrainQuadGrid);
    }

    @Deprecated
    public TerrainGrid(String name, int patchSize, int maxVisibleSize, Vector3f scale, HeightMapGrid heightMapGrid, Vector2f offset, float offsetAmount) {
        this.name = name;
        this.patchSize = patchSize;
        this.size = maxVisibleSize;
        this.stepScale = scale;
        this.offset = offset;
        this.offsetAmount = offsetAmount;
        this.initData();
        this.heightMapGrid = heightMapGrid;
        heightMapGrid.setSize(this.quadSize);
        this.addControl((Control)new UpdateControl());
    }

    @Deprecated
    public TerrainGrid(String name, int patchSize, int maxVisibleSize, Vector3f scale, HeightMapGrid heightMapGrid) {
        this(name, patchSize, maxVisibleSize, scale, heightMapGrid, new Vector2f(), 0.0f);
    }

    @Deprecated
    public TerrainGrid(String name, int patchSize, int maxVisibleSize, HeightMapGrid heightMapGrid) {
        this(name, patchSize, maxVisibleSize, Vector3f.UNIT_XYZ, heightMapGrid);
    }

    public TerrainGrid() {
    }

    private void initData() {
        int maxVisibleSize = this.size;
        this.quarterSize = maxVisibleSize >> 2;
        this.quadSize = maxVisibleSize + 1 >> 1;
        this.totalSize = maxVisibleSize;
        this.gridOffset = new int[]{0, 0};
        this.quadIndex = new Vector3f[]{new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, -1.0f), new Vector3f(2.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(2.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(2.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 2.0f), new Vector3f(0.0f, 0.0f, 2.0f), new Vector3f(1.0f, 0.0f, 2.0f), new Vector3f(2.0f, 0.0f, 2.0f)};
    }

    public Vector3f getCamCell(Vector3f location) {
        Vector3f tile = this.getTileCell(location);
        Vector3f offsetHalf = new Vector3f(-0.5f, 0.0f, -0.5f);
        Vector3f shifted = tile.subtract(offsetHalf);
        return new Vector3f(FastMath.floor((float)shifted.x), 0.0f, FastMath.floor((float)shifted.z));
    }

    public Vector3f getTileCell(Vector3f location) {
        Vector3f tileLoc = location.divide(this.getWorldScale().mult((float)this.quadSize));
        return tileLoc;
    }

    public TerrainGridTileLoader getGridTileLoader() {
        return this.gridTileLoader;
    }

    protected void removeQuad(int idx) {
        if (this.getQuad(idx) != null) {
            for (TerrainGridListener l : this.listeners) {
                l.tileDetached(this.getTileCell(this.getQuad(idx).getWorldTranslation()), this.getQuad(idx));
            }
            this.detachChild((Spatial)this.getQuad(idx));
            ++this.cellsLoaded;
        }
    }

    protected void attachQuadAt(TerrainQuad q, int quadrant, Vector3f quadCell) {
        this.removeQuad(quadrant);
        q.setQuadrant((short)quadrant);
        this.attachChild((Spatial)q);
        Vector3f loc = quadCell.mult((float)(this.quadSize - 1)).subtract((float)this.quarterSize, 0.0f, (float)this.quarterSize);
        q.setLocalTranslation(loc);
        for (TerrainGridListener l : this.listeners) {
            l.tileAttached(quadCell, q);
        }
        this.updateModelBound();
        for (Spatial s : this.getChildren()) {
            if (!(s instanceof TerrainQuad)) continue;
            TerrainQuad tq = (TerrainQuad)s;
            tq.resetCachedNeighbours();
            tq.fixNormalEdges(new BoundingBox(tq.getWorldTranslation(), (float)(this.totalSize * 2), Float.MAX_VALUE, (float)(this.totalSize * 2)));
        }
    }

    protected void updateChildren(Vector3f camCell) {
        int dx = 0;
        int dy = 0;
        if (this.currentCamCell != null) {
            dx = (int)(camCell.x - this.currentCamCell.x);
            dy = (int)(camCell.z - this.currentCamCell.z);
        }
        int xMin = 0;
        int xMax = 4;
        int yMin = 0;
        int yMax = 4;
        if (dx == -1) {
            xMax = 3;
        } else if (dx == 1) {
            xMin = 1;
        }
        if (dy == -1) {
            yMax = 3;
        } else if (dy == 1) {
            yMin = 1;
        }
        for (int i = yMin; i < yMax; ++i) {
            for (int j = xMin; j < xMax; ++j) {
                this.cache.get(camCell.add(this.quadIndex[i * 4 + j]));
            }
        }
        if (this.cacheExecutor == null) {
            this.cacheExecutor = this.createExecutorService();
        }
        this.cacheExecutor.submit(new UpdateQuadCache(camCell));
        this.currentCamCell = camCell;
    }

    public void addListener(TerrainGridListener listener) {
        this.listeners.add(listener);
    }

    public Vector3f getCurrentCell() {
        return this.currentCamCell;
    }

    public void removeListener(TerrainGridListener listener) {
        this.listeners.remove(listener);
    }

    public void setMaterial(Material mat) {
        this.material = mat;
        super.setMaterial(mat);
    }

    public void setQuadSize(int quadSize) {
        this.quadSize = quadSize;
    }

    @Override
    public void adjustHeight(List<Vector2f> xz, List<Float> height) {
        Vector3f currentGridLocation = this.getCurrentCell().mult(this.getLocalScale()).multLocal((float)(this.quadSize - 1));
        for (Vector2f vect : xz) {
            vect.x -= currentGridLocation.x;
            vect.y -= currentGridLocation.z;
        }
        super.adjustHeight(xz, height);
    }

    @Override
    protected float getHeightmapHeight(int x, int z) {
        return super.getHeightmapHeight(x - this.gridOffset[0], z - this.gridOffset[1]);
    }

    @Override
    public int getNumMajorSubdivisions() {
        return 2;
    }

    @Override
    public Material getMaterial(Vector3f worldLocation) {
        if (worldLocation == null) {
            return null;
        }
        Vector3f tileCell = this.getTileCell(worldLocation);
        Terrain terrain = this.cache.get(tileCell);
        if (terrain == null) {
            return null;
        }
        return terrain.getMaterial(worldLocation);
    }

    protected ExecutorService createExecutorService() {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread th = new Thread(r);
                th.setName("jME Terrain Thread");
                th.setDaemon(true);
                return th;
            }
        });
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule c = im.getCapsule((Savable)this);
        this.name = c.readString("name", null);
        this.size = c.readInt("size", 0);
        this.patchSize = c.readInt("patchSize", 0);
        this.stepScale = (Vector3f)c.readSavable("stepScale", null);
        this.offset = (Vector2f)c.readSavable("offset", null);
        this.offsetAmount = c.readFloat("offsetAmount", 0.0f);
        this.gridTileLoader = (TerrainGridTileLoader)c.readSavable("terrainQuadGrid", null);
        this.material = (Material)c.readSavable("material", null);
        this.initData();
        if (this.gridTileLoader != null) {
            this.gridTileLoader.setPatchSize(this.patchSize);
            this.gridTileLoader.setQuadSize(this.quadSize);
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule c = ex.getCapsule((Savable)this);
        c.write((Savable)this.gridTileLoader, "terrainQuadGrid", null);
        c.write(this.size, "size", 0);
        c.write(this.patchSize, "patchSize", 0);
        c.write((Savable)this.stepScale, "stepScale", null);
        c.write((Savable)this.offset, "offset", null);
        c.write(this.offsetAmount, "offsetAmount", 0.0f);
        c.write((Savable)this.material, "material", null);
    }

    protected class UpdateQuadCache
    implements Runnable {
        protected final Vector3f location;

        public UpdateQuadCache(Vector3f location) {
            this.location = location;
        }

        public void run() {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    int quadIdx = i * 4 + j;
                    final Vector3f quadCell = this.location.add(TerrainGrid.this.quadIndex[quadIdx]);
                    TerrainQuad q = TerrainGrid.this.cache.get(quadCell);
                    if (q == null) {
                        if (TerrainGrid.this.heightMapGrid != null) {
                            HeightMap heightMapAt = TerrainGrid.this.heightMapGrid.getHeightMapAt(quadCell);
                            q = new TerrainQuad(TerrainGrid.this.getName() + "Quad" + quadCell, TerrainGrid.this.patchSize, TerrainGrid.this.quadSize, heightMapAt == null ? null : heightMapAt.getHeightMap());
                            q.setMaterial(TerrainGrid.this.material.clone());
                            log.log(Level.FINE, "Loaded TerrainQuad {0} from HeightMapGrid", q.getName());
                        } else if (TerrainGrid.this.gridTileLoader != null) {
                            q = TerrainGrid.this.gridTileLoader.getTerrainQuadAt(quadCell);
                            if (q.getMaterial() == null) {
                                q.setMaterial(TerrainGrid.this.material.clone());
                            }
                            log.log(Level.FINE, "Loaded TerrainQuad {0} from TerrainQuadGrid", q.getName());
                        }
                    }
                    TerrainGrid.this.cache.put(quadCell, q);
                    if (!TerrainGrid.this.isCenter(quadIdx)) continue;
                    final int quadrant = TerrainGrid.this.getQuadrant(quadIdx);
                    final TerrainQuad newQuad = q;
                    ((UpdateControl)TerrainGrid.this.getControl(UpdateControl.class)).enqueue(new Callable(){

                        public Object call() throws Exception {
                            TerrainGrid.this.attachQuadAt(newQuad, quadrant, quadCell);
                            return null;
                        }
                    });
                }
            }
        }
    }
}

