/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio.plugins;

import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.LogicalOggStreamImpl;
import de.jarnbjo.ogg.OggFormatException;
import de.jarnbjo.ogg.OggPage;
import de.jarnbjo.ogg.PhysicalOggStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UncachedOggStream
implements PhysicalOggStream {
    private boolean closed = false;
    private boolean eos = false;
    private boolean bos = false;
    private InputStream sourceStream;
    private LinkedList<OggPage> pageCache = new LinkedList();
    private HashMap<Integer, LogicalOggStream> logicalStreams = new HashMap();
    private OggPage lastPage = null;

    public UncachedOggStream(InputStream in) throws OggFormatException, IOException {
        this.sourceStream = in;
        while (!this.bos) {
            this.readNextOggPage();
        }
    }

    public OggPage getLastOggPage() {
        return this.lastPage;
    }

    private void readNextOggPage() throws IOException {
        LogicalOggStreamImpl los;
        OggPage op = OggPage.create((InputStream)this.sourceStream);
        if (!op.isBos()) {
            this.bos = true;
        }
        if (op.isEos()) {
            this.eos = true;
            this.lastPage = op;
        }
        if ((los = (LogicalOggStreamImpl)this.getLogicalStream(op.getStreamSerialNumber())) == null) {
            los = new LogicalOggStreamImpl((PhysicalOggStream)this, op.getStreamSerialNumber());
            this.logicalStreams.put(op.getStreamSerialNumber(), (LogicalOggStream)los);
            los.checkFormat(op);
        }
        this.pageCache.add(op);
    }

    public OggPage getOggPage(int index) throws IOException {
        if (this.eos) {
            return null;
        }
        if (this.pageCache.size() == 0) {
            this.readNextOggPage();
        }
        return this.pageCache.removeFirst();
    }

    private LogicalOggStream getLogicalStream(int serialNumber) {
        return this.logicalStreams.get(serialNumber);
    }

    public Collection<LogicalOggStream> getLogicalStreams() {
        return this.logicalStreams.values();
    }

    public void setTime(long granulePosition) throws IOException {
    }

    public boolean isSeekable() {
        return false;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
        this.sourceStream.close();
    }
}

