/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.base;

import com.jme3.network.Filter;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.base.DefaultServer;
import com.jme3.network.base.MessageProtocol;
import com.jme3.network.kernel.Endpoint;
import com.jme3.network.kernel.EndpointEvent;
import com.jme3.network.kernel.Envelope;
import com.jme3.network.kernel.Kernel;
import com.jme3.network.message.ClientRegistrationMessage;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KernelAdapter
extends Thread {
    static Logger log = Logger.getLogger(KernelAdapter.class.getName());
    private DefaultServer server;
    private Kernel kernel;
    private MessageListener<HostedConnection> messageDispatcher;
    private AtomicBoolean go = new AtomicBoolean(true);
    private Map<Endpoint, MessageProtocol> messageBuffers = new ConcurrentHashMap<Endpoint, MessageProtocol>();
    private boolean reliable;

    public KernelAdapter(DefaultServer server, Kernel kernel, MessageListener<HostedConnection> messageDispatcher, boolean reliable) {
        super(String.valueOf(kernel));
        this.server = server;
        this.kernel = kernel;
        this.messageDispatcher = messageDispatcher;
        this.reliable = reliable;
        this.setDaemon(true);
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void initialize() {
        this.kernel.initialize();
    }

    public void broadcast(Filter<? super Endpoint> filter, ByteBuffer data, boolean reliable, boolean copy) {
        this.kernel.broadcast(filter, data, reliable, copy);
    }

    public void close() throws InterruptedException {
        this.go.set(false);
        this.kernel.terminate();
    }

    protected void reportError(Endpoint p, Object context, Exception e) {
        log.log(Level.SEVERE, "Unhandled error, endpoint:" + p + ", context:" + context, e);
        p.close();
    }

    protected HostedConnection getConnection(Endpoint p) {
        return this.server.getConnection(p);
    }

    protected void connectionClosed(Endpoint p) {
        this.messageBuffers.remove(p);
        log.log(Level.FINE, "Buffers size:{0}", this.messageBuffers.size());
        this.server.connectionClosed(p);
    }

    protected void dispatch(Endpoint p, Message m) {
        if (m instanceof ClientRegistrationMessage) {
            this.server.registerClient(this, p, (ClientRegistrationMessage)m);
            return;
        }
        try {
            HostedConnection source = this.getConnection(p);
            if (source == null) {
                if (this.reliable) {
                    log.log(Level.WARNING, "Recieved message from unconnected endpoint:" + p + "  message:" + m);
                }
                return;
            }
            this.messageDispatcher.messageReceived(source, m);
        }
        catch (Exception e) {
            this.reportError(p, m, e);
        }
    }

    protected MessageProtocol getMessageBuffer(Endpoint p) {
        if (!this.reliable) {
            return new MessageProtocol();
        }
        MessageProtocol result = this.messageBuffers.get(p);
        if (result == null) {
            result = new MessageProtocol();
            this.messageBuffers.put(p, result);
        }
        return result;
    }

    protected void createAndDispatch(Envelope env) {
        byte[] data;
        ByteBuffer buffer;
        MessageProtocol protocol = this.getMessageBuffer(env.getSource());
        int count = protocol.addBuffer(buffer = ByteBuffer.wrap(data = env.getData()));
        if (count == 0 && !this.reliable) {
            int len = Math.min(10, data.length);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                sb.append("[" + Integer.toHexString(data[i]) + "]");
            }
            log.log(Level.INFO, "First 10 bytes of incomplete nessage:" + sb);
            throw new RuntimeException("Envelope contained incomplete data:" + env);
        }
        Message m = null;
        while ((m = protocol.getMessage()) != null) {
            m.setReliable(this.reliable);
            this.dispatch(env.getSource(), m);
        }
    }

    protected void createAndDispatch(EndpointEvent event) {
        if (event.getType() == EndpointEvent.Type.REMOVE) {
            this.connectionClosed(event.getEndpoint());
        }
    }

    protected void flushEvents() {
        EndpointEvent event;
        while ((event = this.kernel.nextEvent()) != null) {
            try {
                this.createAndDispatch(event);
            }
            catch (Exception e) {
                this.reportError(event.getEndpoint(), event, e);
            }
        }
    }

    @Override
    public void run() {
        while (this.go.get()) {
            try {
                this.flushEvents();
                Envelope e = this.kernel.read();
                if (e == Kernel.EVENTS_PENDING) continue;
                this.flushEvents();
                try {
                    this.createAndDispatch(e);
                }
                catch (Exception ex) {
                    this.reportError(e.getSource(), e, ex);
                }
            }
            catch (InterruptedException ex) {
                if (!this.go.get()) {
                    return;
                }
                throw new RuntimeException("Unexpected interruption", ex);
            }
        }
    }
}

