/*
 * Decompiled with CFR 0.152.
 */
package mygame;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.Random;

public class GameObj
extends Node {
    public static int TYPE_SHIP = 1;
    public static int TYPE_ENEMY = 2;
    public static int TYPE_BOSS = 3;
    public static int TYPE_SHOT = 4;
    static Random rnd = new Random();
    float life = 1.0f;
    float speed;
    float radius = 0.0f;
    float damage = 0.25f;
    float score = 2.0f;
    float singFill = 0.07f;
    float dieTime = 2.0f;
    Vector3f dieVector = new Vector3f(Vector3f.ZERO);
    float rx;
    float ry;
    float rz;
    int type = TYPE_ENEMY;

    public boolean isDead() {
        return this.dieTime <= 0.0f && this.life <= 0.0f;
    }

    public boolean isDying() {
        return this.dieTime > 0.0f && this.life <= 0.0f;
    }

    public GameObj() {
        super("Pivot");
    }

    public void updatePos(Vector3f pos, float tpf) {
        if (this.isDying() || this.isDead()) {
            this.dieVector.addLocal(0.0f, -3.0f * tpf, 0.0f);
            this.setLocalTranslation(pos.add(this.dieVector));
        } else {
            this.setLocalTranslation(pos);
        }
    }

    private float rndRot() {
        return (rnd.nextFloat() * 7.0f + 1.5f) * Math.signum(rnd.nextFloat() - 0.5f);
    }

    public void updateRot(Vector3f xyz, float tpf) {
        if (this.isDying() || this.isDead()) {
            this.rotate(this.rx * tpf, this.ry * tpf, this.rz * tpf);
        } else {
            Quaternion q = new Quaternion();
            q.fromAngles(xyz.x, xyz.y, xyz.z);
            this.setLocalRotation(q);
        }
    }

    public void addSpatial(Spatial s) {
        BoundingVolume v = s.getWorldBound();
        if (v.getClass() == BoundingBox.class) {
            BoundingBox b = (BoundingBox)v;
            float max = Math.max(b.getXExtent(), b.getYExtent());
            this.radius = Math.max(max, b.getZExtent());
        }
        this.attachChild(s);
    }

    public void die() {
        this.life = 0.0f;
        this.rx = this.rndRot();
        this.ry = this.rndRot();
        this.rz = this.rndRot();
    }

    public void updateDie(float tpf) {
        this.dieTime -= tpf;
    }

    public boolean isBoss() {
        return this.type == TYPE_BOSS;
    }

    public boolean isShip() {
        return this.type == TYPE_SHIP;
    }

    public boolean isEnemy() {
        return this.type == TYPE_ENEMY;
    }

    public boolean isShot() {
        return this.type == TYPE_SHOT;
    }
}

