/*
 * Decompiled with CFR 0.152.
 */
package mygame;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapText;
import com.jme3.math.ColorRGBA;
import com.jme3.system.AppSettings;
import com.jme3.ui.Picture;
import mygame.Main;

public class Hud
extends AbstractAppState {
    Picture health;
    Picture healthBorder;
    Picture timeWarp;
    Picture timeWarpBorder;
    Picture black;
    Picture overlay;
    BitmapText score;
    BitmapText scoreBg;
    float overlayCurrentTime = 0.0f;
    float overlayLength = 1.0f;
    float overlayFadeTime = 0.5f;
    ColorRGBA blendColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    ColorRGBA blendColorInverse = new ColorRGBA(1.0f, 1.0f, 1.0f, 0.0f);
    ColorRGBA blendColorOverlay = new ColorRGBA(1.0f, 1.0f, 1.0f, 0.0f);
    Boolean overlayAttached = false;
    Boolean fadeAttached = false;
    Main app;
    AssetManager assetManager;
    private boolean showHud = false;
    float total = 220.0f;
    float fadeVal = 0.0f;
    float fadeTarget = 0.0f;
    float fadeTime = 1.0f;

    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.app = (Main)app;
        this.assetManager = app.getAssetManager();
        AppSettings settings = app.getContext().getSettings();
        this.timeWarpBorder = new Picture("warpBorder");
        this.timeWarpBorder.setImage(this.assetManager, "Interface/singularityBorder.png", true);
        this.timeWarpBorder.setPosition(10.0f, 10.0f);
        this.timeWarpBorder.setWidth(231.0f);
        this.timeWarpBorder.setHeight(54.0f);
        this.timeWarpBorder.getMaterial().setColor("Color", this.blendColorInverse);
        this.healthBorder = new Picture("healthBorder");
        this.healthBorder.setImage(this.assetManager, "Interface/healthBorder.png", true);
        this.healthBorder.setPosition(settings.getWidth() - 10 - 231, 10.0f);
        this.healthBorder.setWidth(231.0f);
        this.healthBorder.setHeight(54.0f);
        this.healthBorder.getMaterial().setColor("Color", this.blendColorInverse);
        this.timeWarp = new Picture("warpBar");
        this.timeWarp.setImage(this.assetManager, "Interface/singularityBar.png", true);
        this.timeWarp.setPosition(15.0f, 15.0f);
        this.timeWarp.setWidth(220.0f);
        this.timeWarp.setHeight(22.0f);
        this.timeWarp.getMaterial().setColor("Color", this.blendColorInverse);
        this.health = new Picture("healthBar");
        this.health.setImage(this.assetManager, "Interface/healthBar.png", true);
        this.health.setPosition(settings.getWidth() - 15 - 220, 15.0f);
        this.health.setWidth(220.0f);
        this.health.setHeight(22.0f);
        this.health.getMaterial().setColor("Color", this.blendColorInverse);
        this.black = new Picture("white");
        this.black.setImage(this.assetManager, "Textures/white.png", true);
        this.black.setPosition(0.0f, 0.0f);
        this.black.setWidth(settings.getWidth());
        this.black.setHeight(settings.getHeight());
        this.black.getMaterial().setColor("Color", this.blendColor);
        this.overlay = new Picture("overlay");
        this.score = new BitmapText(this.app.getFont(), false);
        this.score.setSize(this.app.getFont().getCharSet().getRenderedSize());
        this.score.setText("Hello World");
        this.scoreBg = new BitmapText(this.app.getFont(), false);
        this.scoreBg.setSize(this.app.getFont().getCharSet().getRenderedSize());
        this.scoreBg.setText("Hello World");
        this.scoreBg.setLocalScale(1.13f, 1.05f, 1.0f);
        this.scoreBg.setColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        this.setScore(0);
    }

    public void cleanup() {
        super.cleanup();
        this.app.getGuiNode().detachAllChildren();
        this.overlayAttached = false;
        this.fadeAttached = false;
    }

    public void showHud(boolean showHud) {
        this.showHud = showHud;
        if (showHud) {
            this.app.getGuiNode().attachChild(this.score);
            this.app.getGuiNode().attachChild(this.timeWarp);
            this.app.getGuiNode().attachChild(this.health);
            this.app.getGuiNode().attachChild(this.timeWarpBorder);
            this.app.getGuiNode().attachChild(this.healthBorder);
        } else {
            this.app.getGuiNode().detachChild(this.score);
            this.app.getGuiNode().detachChild(this.timeWarp);
            this.app.getGuiNode().detachChild(this.health);
            this.app.getGuiNode().detachChild(this.timeWarpBorder);
            this.app.getGuiNode().detachChild(this.healthBorder);
        }
    }

    public void setFade(float fadeVal, float fadeTarget) {
        this.fadeVal = fadeVal;
        this.fadeTarget = fadeTarget;
        if (!this.fadeAttached.booleanValue()) {
            this.app.getGuiNode().attachChild(this.black);
            this.fadeAttached = true;
        }
    }

    public float getFadeVal() {
        return this.fadeVal;
    }

    public void setScore(int sc) {
        AppSettings settings = this.app.getContext().getSettings();
        this.score.setText("" + sc);
        this.score.setLocalTranslation(((float)settings.getWidth() - this.score.getLineWidth()) / 2.0f, this.score.getLineHeight(), 0.0f);
        this.scoreBg.setText("" + sc);
        this.scoreBg.setLocalTranslation(((float)settings.getWidth() - this.score.getLineWidth()) / 2.0f - 1.0f, this.score.getLineHeight() + 1.0f, 0.0f);
    }

    public void flashOverlay(String PictureFile, int centerX, int centerY, int w, int h, float length) {
        this.overlayLength = length;
        this.flashOverlay(PictureFile, centerX, centerY, w, h);
    }

    private void flashOverlay(String PictureFile, int centerX, int centerY, int w, int h) {
        this.overlay.setImage(this.assetManager, "Textures/" + PictureFile, true);
        this.overlay.setWidth(w);
        this.overlay.setHeight(h);
        this.overlay.setPosition(centerX - w / 2, centerY - h / 2);
        this.overlay.getMaterial().setColor("Color", this.blendColorOverlay);
        this.overlayCurrentTime = 0.0f;
        if (!this.overlayAttached.booleanValue()) {
            this.app.getGuiNode().attachChild(this.overlay);
            this.overlayAttached = true;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.showHud(this.showHud);
            this.setFade(this.fadeVal, this.fadeTarget);
        } else {
            this.app.getGuiNode().detachAllChildren();
            this.overlayAttached = false;
            this.fadeAttached = false;
        }
    }

    public void update(float tpf) {
        if (this.isEnabled()) {
            this.blendColor.a = this.fadeVal = this.fadeVal < this.fadeTarget ? Math.min(this.fadeVal + tpf * 1.5f, this.fadeTarget) : Math.max(this.fadeVal - tpf * 1.5f, this.fadeTarget);
            this.blendColorInverse.a = 1.0f - this.fadeVal;
            this.overlayCurrentTime += tpf;
            this.blendColorOverlay.a = this.overlayCurrentTime > this.overlayLength ? Math.max(0.0f, 1.0f - (this.overlayCurrentTime - this.overlayLength) / this.overlayFadeTime) : 1.0f;
        }
    }

    public void update(float h, float warp) {
        float scalH = h * this.total;
        float scalW = warp * this.total;
        this.health.setWidth(Math.round(scalH));
        this.timeWarp.setWidth(Math.round(scalW));
    }
}

