/*
 * Decompiled with CFR 0.152.
 */
package mygame;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mygame.CamPath;
import mygame.GameObj;
import mygame.LevelTiming;
import mygame.LinearPath;
import mygame.Powerup;
import mygame.Shots;
import mygame.SinusPath;
import mygame.TrianglePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelGenerator {
    public AssetManager assetManager;
    public Node rootNode;
    Map<String, Material> materials = new HashMap<String, Material>();
    Map<String, String> meshes = new HashMap<String, String>();

    public void initAssets() {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        mat.setFloat("Shininess", 8.0f);
        mat.setColor("Diffuse", new ColorRGBA(0.8f, 0.8f, 0.7f, 1.0f));
        mat.setColor("Specular", new ColorRGBA(0.9f, 0.9f, 0.8f, 1.0f));
        mat.setColor("Ambient", ColorRGBA.Black);
        mat.setBoolean("UseMaterialColors", true);
        this.materials.put("mat1", mat);
        Material mat2 = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        mat2.setFloat("Shininess", 2.7f);
        mat2.setColor("Diffuse", new ColorRGBA(0.7f, 0.7f, 0.6f, 1.0f));
        mat2.setColor("Specular", new ColorRGBA(0.2f, 0.2f, 0.15f, 1.0f));
        mat2.setColor("Ambient", new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        mat2.setBoolean("UseMaterialColors", true);
        this.materials.put("citymat", mat2);
        Material mat3 = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        mat3.setFloat("Shininess", 8.0f);
        mat3.setColor("Diffuse", new ColorRGBA(0.9f, 0.9f, 0.8f, 1.0f));
        mat3.setColor("Specular", new ColorRGBA(1.0f, 1.0f, 0.9f, 1.0f));
        mat3.setColor("Ambient", new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        mat3.setBoolean("UseMaterialColors", true);
        this.materials.put("shipmat", mat3);
        Material pw1 = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        pw1.setFloat("Shininess", 8.0f);
        pw1.setColor("Diffuse", new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        pw1.setColor("Specular", new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        pw1.setColor("Ambient", new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        pw1.setBoolean("UseMaterialColors", true);
        this.materials.put("pw1", pw1);
        Material pw2 = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        pw2.setFloat("Shininess", 8.0f);
        pw2.setColor("Diffuse", new ColorRGBA(0.0f, 0.8f, 0.0f, 1.0f));
        pw2.setColor("Specular", new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f));
        pw2.setColor("Ambient", new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        pw2.setBoolean("UseMaterialColors", true);
        this.materials.put("pw2", pw2);
        Material pw3 = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        pw3.setFloat("Shininess", 8.0f);
        pw3.setColor("Diffuse", new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f));
        pw3.setColor("Specular", new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f));
        pw3.setColor("Ambient", new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        pw3.setBoolean("UseMaterialColors", true);
        this.materials.put("pw3", pw3);
        Material pw4 = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        pw4.setFloat("Shininess", 8.0f);
        pw4.setColor("Diffuse", new ColorRGBA(0.5f, 0.0f, 1.0f, 1.0f));
        pw4.setColor("Specular", new ColorRGBA(0.5f, 0.0f, 1.0f, 1.0f));
        pw4.setColor("Ambient", new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        pw4.setBoolean("UseMaterialColors", true);
        this.materials.put("pw4", pw4);
        this.meshes.put("ufo1", "Models/Ufo1.mesh.xml");
        this.meshes.put("ufo2", "Models/Ufo2.mesh.xml");
        this.meshes.put("ufo3", "Models/Ufo3.mesh.xml");
        this.meshes.put("ufo4", "Models/Ufo4.mesh.xml");
        this.meshes.put("ufo5", "Models/Ufo5.mesh.xml");
        this.meshes.put("boss1", "Models/Mother1.mesh.xml");
        this.meshes.put("boss2", "Models/Mother2.mesh.xml");
        this.meshes.put("ship", "Models/Ship.mesh.xml");
        this.meshes.put("bg1", "Models/City1.mesh.xml");
        this.meshes.put("rocket", "Models/WeaponRocket.mesh.xml");
        this.meshes.put("star", "Models/WeaponStar.mesh.xml");
        this.meshes.put("powerup", "Models/Powerup.mesh.xml");
    }

    public LevelGenerator(AssetManager assetManager, Node rootNode) {
        this.assetManager = assetManager;
        this.rootNode = rootNode;
    }

    public Geometry createCube(String mat, float scal) {
        Sphere rock = new Sphere(16, 16, scal);
        Geometry g = new Geometry("box", rock);
        g.setMaterial(this.materials.get(mat));
        return g;
    }

    public Spatial createGeom(String mat, String mesh, float scal) {
        Spatial g = this.assetManager.loadModel(this.meshes.get(mesh));
        g.scale(scal);
        g.setMaterial(this.materials.get(mat));
        return g;
    }

    public GameObj createObject(String mesh, String mat, float scal) {
        return this.createObject(mesh, mat, scal, false, false);
    }

    public GameObj createPowerup(String mesh, String mat, float scal, int type) {
        Powerup node = new Powerup();
        Spatial obj = this.assetManager.loadModel(this.meshes.get(mesh));
        obj.scale(scal);
        obj.setMaterial(this.materials.get(mat));
        node.ptype = type;
        node.addSpatial(obj);
        this.rootNode.attachChild(node);
        return node;
    }

    public GameObj createObject(String mesh, String mat, float scal, boolean castShadow, boolean receiveShadow) {
        GameObj node = new GameObj();
        Spatial obj = this.assetManager.loadModel(this.meshes.get(mesh));
        obj.scale(scal);
        obj.setMaterial(this.materials.get(mat));
        if (castShadow && receiveShadow) {
            obj.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        } else if (castShadow) {
            obj.setShadowMode(RenderQueue.ShadowMode.Cast);
        } else if (receiveShadow) {
            obj.setShadowMode(RenderQueue.ShadowMode.Receive);
        }
        node.addSpatial(obj);
        this.rootNode.attachChild(node);
        return node;
    }

    public ArrayList<GameObj> createBg(int count) {
        ArrayList<GameObj> tiles = new ArrayList<GameObj>();
        float z = 0.0f;
        float zoff = 300.0f;
        for (int k = 0; k < count; ++k) {
            GameObj t = this.createObject("bg1", "citymat", 1.0f, true, true);
            t.updatePos(new Vector3f(0.0f, -120.0f, z), 0.0f);
            t.updateRot(new Vector3f(0.0f, (float)((double)(count % 4) * Math.PI / 2.0), 0.0f), 0.0f);
            tiles.add(t);
            z += zoff;
        }
        return tiles;
    }

    public LevelTiming createPlayerTiming(int count) {
        LevelTiming t = new LevelTiming();
        CamPath p = new CamPath(new Vector3f(0.0f, 0.0f, 1.0f), count * 300);
        GameObj o = this.createObject("ship", "shipmat", 0.05f);
        o.speed = 20.0f;
        o.type = GameObj.TYPE_SHIP;
        o.dieTime = Float.MAX_VALUE;
        t.addObject(o, 0.0f, p, new Vector3f(0.0f, 0.0f, -100.0f));
        return t;
    }

    public LevelTiming createEnemies() {
        LevelTiming t = new LevelTiming();
        float time = 0.0f;
        LinearPath p = new LinearPath(new Vector3f(0.0f, 0.0f, -1.0f), 50.0f);
        for (int k = 0; k < 10; ++k) {
            GameObj o = this.createObject("ufo1", "mat1", 0.05f, true, false);
            o.speed = 2.0f;
            t.addObject(o, time, p, new Vector3f(0.0f, 0.0f, 10.0f));
            time += 0.5f;
        }
        time = 10.0f;
        SinusPath s = new SinusPath(1.0f, 2.5f, 50.0f);
        for (int k = 0; k < 10; ++k) {
            GameObj o = this.createObject("ufo1", "mat1", 0.05f, true, false);
            o.speed = 1.0f;
            t.addObject(o, time, s, new Vector3f(0.0f, 0.0f, 10.0f));
            time += 0.5f;
        }
        return t;
    }

    public void crEnemies(LevelTiming t, char id, float timeOff, float xOff) {
        float time = 0.0f;
        switch (id) {
            case ' ': {
                break;
            }
            case '|': {
                break;
            }
            case 'a': {
                time = timeOff;
                LinearPath p = new LinearPath(new Vector3f(0.0f, 0.0f, -1.0f), 75.0f);
                for (int k = 0; k < 8; ++k) {
                    GameObj o = this.createObject("ufo1", "mat1", 0.05f, true, false);
                    o.speed = 2.0f;
                    t.addObject(o, time, p, new Vector3f(xOff, 0.0f, 10.0f));
                    time += 0.5f;
                }
                break;
            }
            case 'b': {
                time = timeOff;
                SinusPath s = new SinusPath(2.5f, 0.5f, 50.0f);
                for (int k = 0; k < 5; ++k) {
                    GameObj o = this.createObject("ufo1", "mat1", 0.05f, true, false);
                    o.speed = 1.0f;
                    t.addObject(o, time, s, new Vector3f(xOff, 0.0f, 10.0f));
                    time += 0.75f;
                }
                break;
            }
            case 'c': {
                time = timeOff;
                SinusPath s = new SinusPath(0.5f, 2.0f, 50.0f);
                for (int k = 0; k < 10; ++k) {
                    GameObj o = this.createObject("ufo1", "mat1", 0.05f, true, false);
                    o.speed = 1.5f;
                    t.addObject(o, time, s, new Vector3f(xOff, 0.0f, 10.0f));
                    time += 1.0f;
                }
                break;
            }
            case 'd': {
                time = timeOff;
                LinearPath s = new LinearPath(new Vector3f(-1.0f, 0.0f, -1.0f), 100.0f);
                for (int k = 0; k < 10; ++k) {
                    GameObj o = this.createObject("ufo3", "mat1", 0.05f, true, false);
                    o.speed = 1.5f;
                    t.addObject(o, time, s, new Vector3f(xOff * 2.5f, 0.0f, 8.0f));
                    time += 0.8f;
                }
                break;
            }
            case 'e': {
                time = timeOff;
                LinearPath s = new LinearPath(new Vector3f(1.0f, 0.0f, -1.0f), 100.0f);
                for (int k = 0; k < 10; ++k) {
                    GameObj o = this.createObject("ufo3", "mat1", 0.05f, true, false);
                    o.speed = 1.5f;
                    t.addObject(o, time, s, new Vector3f(xOff * 2.5f, 0.0f, 8.0f));
                    time += 0.8f;
                }
                break;
            }
            case 'f': {
                time = timeOff;
                LinearPath s = new LinearPath(new Vector3f(0.0f, 0.0f, 1.0f), 50.0f);
                for (int k = 0; k < 1; ++k) {
                    GameObj o = this.createObject("ufo2", "mat1", 0.05f, true, false);
                    o.speed = 0.8f;
                    t.addObject(o, time, s, new Vector3f(xOff, 0.0f, -8.0f));
                    time += 0.8f;
                }
                break;
            }
            case 'g': {
                time = timeOff;
                TrianglePath s = new TrianglePath(0.25f, 0.75f, 50.0f);
                for (int k = 0; k < 5; ++k) {
                    GameObj o = this.createObject("ufo2", "mat1", 0.05f, true, false);
                    o.speed = 1.5f;
                    t.addObject(o, time, s, new Vector3f(xOff, 0.0f, 10.0f));
                    time += 1.2f;
                }
                break;
            }
            case 'h': {
                time = timeOff;
                SinusPath s = new SinusPath(10.0f, 0.1f, 50.0f);
                for (int k = 0; k < 3; ++k) {
                    GameObj o = this.createObject("ufo4", "mat1", 0.08f, true, false);
                    o.speed = 1.5f;
                    o.life = 3.0f;
                    o.score = 10.0f;
                    t.addObject(o, time, s, new Vector3f(xOff, 0.0f, 10.0f));
                    time += 1.7f;
                }
                break;
            }
            case 'i': {
                time = timeOff;
                SinusPath s = new SinusPath(0.7f, 2.0f, 50.0f);
                for (int k = 0; k < 8; ++k) {
                    GameObj o = this.createObject("ufo2", "mat1", 0.05f, true, false);
                    o.speed = -1.3f;
                    t.addObject(o, time, s, new Vector3f(xOff, 0.0f, -8.0f));
                    time += 0.8f;
                }
                break;
            }
            case 'j': {
                time = timeOff;
                SinusPath s = new SinusPath(0.7f, -2.0f, 50.0f);
                for (int k = 0; k < 8; ++k) {
                    GameObj o = this.createObject("ufo2", "mat1", 0.05f, true, false);
                    o.speed = -1.3f;
                    t.addObject(o, time, s, new Vector3f(xOff, 0.0f, -8.0f));
                    time += 0.8f;
                }
                break;
            }
            case 'x': {
                time = timeOff;
                SinusPath s = new SinusPath(10.0f, 0.1f, 1000.0f);
                for (int k = 0; k < 1; ++k) {
                    GameObj o = this.createObject("boss2", "mat1", 0.3f, true, false);
                    o.speed = 0.35f;
                    o.life = 30.0f;
                    o.type = GameObj.TYPE_BOSS;
                    o.score = 100.0f;
                    t.addObject(o, time, s, new Vector3f(xOff, 0.0f, 15.0f));
                    time += 1.7f;
                }
                break;
            }
        }
    }

    public void crUpgrades(LevelTiming t, char id, float timeOff, float xOff) {
        float time = 0.0f;
        switch (id) {
            case ' ': {
                break;
            }
            case '|': {
                break;
            }
            case '1': {
                time = timeOff;
                LinearPath p = new LinearPath(new Vector3f(0.0f, 0.0f, -1.0f), 75.0f);
                GameObj o = this.createPowerup("powerup", "pw1", 0.1f, 1);
                o.speed = 2.0f;
                o.score = 20.0f;
                t.addObject(o, time, p, new Vector3f(xOff, 0.0f, 10.0f));
                time += 0.5f;
                break;
            }
            case '2': {
                time = timeOff;
                LinearPath p = new LinearPath(new Vector3f(0.0f, 0.0f, -1.0f), 75.0f);
                GameObj o = this.createPowerup("powerup", "pw2", 0.1f, 2);
                o.speed = 2.0f;
                o.score = 30.0f;
                t.addObject(o, time, p, new Vector3f(xOff, 0.0f, 10.0f));
                time += 0.5f;
                break;
            }
            case '3': {
                time = timeOff;
                LinearPath p = new LinearPath(new Vector3f(0.0f, 0.0f, -1.0f), 75.0f);
                GameObj o = this.createPowerup("powerup", "pw3", 0.1f, 3);
                o.speed = 2.0f;
                o.score = 50.0f;
                t.addObject(o, time, p, new Vector3f(xOff, 0.0f, 10.0f));
                time += 0.5f;
                break;
            }
            case '4': {
                time = timeOff;
                LinearPath p = new LinearPath(new Vector3f(0.0f, 0.0f, -1.0f), 75.0f);
                GameObj o = this.createPowerup("powerup", "pw4", 0.1f, 4);
                o.speed = 2.0f;
                o.score = 20.0f;
                t.addObject(o, time, p, new Vector3f(xOff, 0.0f, 10.0f));
                time += 0.5f;
                break;
            }
        }
    }

    public void createShots(Shots shots) {
        shots.addConf("front", 0.0f, 0.2f, 0.0f, 1.0f);
        for (int k = 0; k < 100; ++k) {
            Geometry g = this.createCube("mat1", 0.05f);
            Shots.Shot s = shots.addShot("bullet", 3.0f, 1.5f);
            s.addSpatial(g);
        }
        shots.addConf("left", 0.2f, -0.2f, 1.0f, 0.0f);
        shots.addConf("right", -0.2f, -0.2f, -1.0f, 0.0f);
        Quaternion r2 = new Quaternion(new float[]{0.0f, 0.2f, 0.0f});
        for (int k = 0; k < 100; ++k) {
            Spatial g = this.createGeom("mat1", "star", 0.02f);
            Shots.Shot s = shots.addShot("star", 3.0f, 1.5f, r2);
            s.addSpatial(g);
        }
        shots.addConf("diagl", 0.2f, -0.1f, 0.5f, 0.5f);
        shots.addConf("diagr", -0.2f, -0.1f, -0.5f, 0.5f);
        Quaternion r3 = new Quaternion();
        float rot = (float)Math.sin(0.7853981633974483);
        for (int k = 0; k < 100; ++k) {
            Spatial g = this.createGeom("mat1", "rocket", 0.07f);
            g.rotate(0.0f, rot, 0.0f);
            Shots.Shot s = shots.addShot("rocketl", 3.0f, 1.5f, r3);
            s.addSpatial(g);
        }
        Quaternion r4 = new Quaternion();
        rot = -((float)Math.sin(0.7853981633974483));
        for (int k = 0; k < 100; ++k) {
            Spatial g = this.createGeom("mat1", "rocket", 0.07f);
            g.rotate(0.0f, rot, 0.0f);
            Shots.Shot s = shots.addShot("rocketr", 3.0f, 1.5f, r4);
            s.addSpatial(g);
        }
    }
}

