/*
 * Decompiled with CFR 0.152.
 */
package mygame;

import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import java.util.ArrayList;
import mygame.GameObj;
import mygame.GameObjPath;
import mygame.Timing;

public class LevelTiming {
    ArrayList<Timing> timings = new ArrayList(1000);
    ArrayList<Timing> active = new ArrayList(1000);

    public void update(float time, float tpf, Node rootNode) {
        this.active.clear();
        for (Timing t : this.timings) {
            if (time > t.start && time < t.end && !t.obj.isDead()) {
                this.active.add(t);
                rootNode.attachChild(t.obj);
                if (!t.obj.isDying()) continue;
                t.obj.updateDie(tpf);
                continue;
            }
            if (t.obj.isShip()) continue;
            rootNode.detachChild(t.obj);
        }
    }

    public void addObject(GameObj enemy, float start, GameObjPath path, Vector3f offset) {
        Timing t = new Timing();
        t.start = start;
        t.end = start + path.getDuration(enemy.speed);
        t.obj = enemy;
        t.path = path;
        t.offset = offset;
        this.timings.add(t);
    }
}

