/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty;

import de.lessvoid.nifty.Clipboard;
import de.lessvoid.nifty.ClipboardAWT;
import de.lessvoid.nifty.ClipboardNull;
import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.NiftyDefaults;
import de.lessvoid.nifty.NiftyDelayedMethodInvoke;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.NiftyEventAnnotationProcessor;
import de.lessvoid.nifty.NiftyIdCreator;
import de.lessvoid.nifty.NiftyInputConsumer;
import de.lessvoid.nifty.NiftyMouse;
import de.lessvoid.nifty.controls.StandardControl;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import de.lessvoid.nifty.input.mouse.MouseInputEventProcessor;
import de.lessvoid.nifty.layout.Box;
import de.lessvoid.nifty.layout.BoxConstraints;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.loaderv2.NiftyLoader;
import de.lessvoid.nifty.loaderv2.RootLayerFactory;
import de.lessvoid.nifty.loaderv2.types.ControlDefinitionType;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.loaderv2.types.LayerType;
import de.lessvoid.nifty.loaderv2.types.NiftyType;
import de.lessvoid.nifty.loaderv2.types.PopupType;
import de.lessvoid.nifty.loaderv2.types.RegisterEffectType;
import de.lessvoid.nifty.loaderv2.types.RegisterMusicType;
import de.lessvoid.nifty.loaderv2.types.RegisterSoundType;
import de.lessvoid.nifty.loaderv2.types.ResourceBundleType;
import de.lessvoid.nifty.loaderv2.types.StyleType;
import de.lessvoid.nifty.loaderv2.types.resolver.style.StyleResolver;
import de.lessvoid.nifty.loaderv2.types.resolver.style.StyleResolverDefault;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyMouseImpl;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.NiftyRenderEngineImpl;
import de.lessvoid.nifty.screen.NullScreen;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import de.lessvoid.nifty.sound.SoundSystem;
import de.lessvoid.nifty.spi.input.InputSystem;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.spi.sound.SoundDevice;
import de.lessvoid.nifty.tools.ObjectPool;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.nifty.tools.TimeProvider;
import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import de.lessvoid.xml.tools.SpecialValuesReplace;
import de.lessvoid.xml.xpp3.Attributes;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventServiceExistsException;
import org.bushe.swing.event.EventServiceLocator;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.ProxySubscriber;
import org.bushe.swing.event.ThreadSafeEventService;
import org.bushe.swing.event.annotation.ReferenceStrength;

public class Nifty {
    private Logger log = Logger.getLogger(Nifty.class.getName());
    private Logger inputEventLog = Logger.getLogger("NiftyInputEventHandlingLog");
    private NiftyRenderEngine renderEngine;
    private SoundSystem soundSystem;
    private Map<String, Screen> screens = new Hashtable<String, Screen>();
    private Map<String, PopupType> popupTypes = new Hashtable<String, PopupType>();
    private Map<String, Element> popups = new Hashtable<String, Element>();
    private Map<String, StyleType> styles = new Hashtable<String, StyleType>();
    private Map<String, ControlDefinitionType> controlDefintions = new Hashtable<String, ControlDefinitionType>();
    private Map<String, RegisterEffectType> registeredEffects = new Hashtable<String, RegisterEffectType>();
    private Screen currentScreen = new NullScreen();
    private String currentLoaded;
    private boolean exit;
    private boolean resolutionChanged;
    private TimeProvider timeProvider;
    private List<ClosePopUp> closePopupList = new ArrayList<ClosePopUp>();
    private NiftyLoader loader;
    private List<ControlToAdd> controlsToAdd = new ArrayList<ControlToAdd>();
    private List<EndOfFrameElementAction> endOfFrameElementActions = new ArrayList<EndOfFrameElementAction>();
    private MouseInputEventProcessor mouseInputEventProcessor;
    private Collection<ScreenController> registeredScreenControllers = new ArrayList<ScreenController>();
    private String alternateKeyForNextLoadXml;
    private long lastTime;
    private InputSystem inputSystem;
    private boolean gotoScreenInProgess;
    private String alternateKey;
    private Collection<DelayedMethodInvoke> delayedMethodInvokes = new ArrayList<DelayedMethodInvoke>();
    private Map<String, String> resourceBundleSource = new Hashtable<String, String>();
    private Map<String, ResourceBundle> resourceBundles = new Hashtable<String, ResourceBundle>();
    private Locale locale = Locale.getDefault();
    private Properties globalProperties;
    private RootLayerFactory rootLayerFactory = new RootLayerFactory();
    private NiftyMouseImpl niftyMouse;
    private NiftyInputConsumerImpl niftyInputConsumer = new NiftyInputConsumerImpl();
    private SubscriberRegistry subscriberRegister = new SubscriberRegistry();
    private boolean debugOptionPanelColors;
    private Clipboard clipboard = null;
    private NiftyResourceLoader resourceLoader = new NiftyResourceLoader();

    public Nifty(RenderDevice newRenderDevice, SoundDevice newSoundDevice, InputSystem newInputSystem, TimeProvider newTimeProvider) {
        newRenderDevice.setResourceLoader(this.resourceLoader);
        newSoundDevice.setResourceLoader(this.resourceLoader);
        newInputSystem.setResourceLoader(this.resourceLoader);
        this.initialize(new NiftyRenderEngineImpl(newRenderDevice), new SoundSystem(newSoundDevice), newInputSystem, newTimeProvider);
        this.initializeClipboard();
    }

    private void initialize(NiftyRenderEngine newRenderDevice, SoundSystem newSoundSystem, InputSystem newInputSystem, TimeProvider newTimeProvider) {
        this.renderEngine = newRenderDevice;
        this.soundSystem = newSoundSystem;
        this.inputSystem = newInputSystem;
        this.timeProvider = newTimeProvider;
        this.exit = false;
        this.resolutionChanged = false;
        this.currentLoaded = null;
        this.mouseInputEventProcessor = new MouseInputEventProcessor();
        this.lastTime = this.timeProvider.getMsTime();
        this.niftyMouse = new NiftyMouseImpl(newRenderDevice.getRenderDevice(), this.inputSystem, this.timeProvider);
        try {
            this.loader = new NiftyLoader(this, this.timeProvider);
            this.loader.registerSchema("nifty.nxs", this.getResourceAsStream("nifty.nxs"));
            this.loader.registerSchema("nifty-styles.nxs", this.getResourceAsStream("nifty-styles.nxs"));
            this.loader.registerSchema("nifty-controls.nxs", this.getResourceAsStream("nifty-controls.nxs"));
            NiftyDefaults.initDefaultEffects(this);
            this.initalizeEventBus();
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
        }
    }

    private void initializeClipboard() {
        try {
            Class.forName("java.awt.datatransfer.Clipboard");
            this.clipboard = new ClipboardAWT();
        }
        catch (ClassNotFoundException e) {
            this.log.info("unable to access class 'java.awt.datatransfer.Clipboard'. clipboard will be disabled.");
            this.clipboard = new ClipboardNull();
        }
        catch (Throwable e) {
            this.log.info("unable to access class 'java.awt.datatransfer.Clipboard'. clipboard will be disabled.");
            this.clipboard = new ClipboardNull();
        }
    }

    private void initalizeEventBus() throws EventServiceExistsException {
        EventServiceLocator.setEventService((String)"NiftyEventBus", (EventService)new ThreadSafeEventService());
    }

    public EventService getEventService() {
        return EventServiceLocator.getEventService((String)"NiftyEventBus");
    }

    public void publishEvent(String id, NiftyEvent event) {
        if (id != null) {
            this.getEventService().publish(id, (Object)event);
        }
    }

    public void subscribeAnnotations(Object object) {
        NiftyEventAnnotationProcessor.process(object);
    }

    public void unsubscribeAnnotations(Object object) {
        NiftyEventAnnotationProcessor.unprocess(object);
    }

    public <T, S extends EventTopicSubscriber<? extends T>> void subscribe(Screen screen, String elementId, Class<T> eventClass, S subscriber) {
        if (elementId == null) {
            this.log.warning("trying to subscribe events for an element with elementId = null. this won't work. offending class \"" + eventClass + "\" and offending subscriber \"" + subscriber + "\". try to find the offending element/control and give it an id!");
            return;
        }
        ClassSaveEventTopicSubscriber theSubscriber = new ClassSaveEventTopicSubscriber(elementId, subscriber, eventClass);
        this.getEventService().subscribeStrongly(elementId, (EventTopicSubscriber)theSubscriber);
        NiftyDefaults.eventBusLog.info("-> subscribe [" + elementId + "] screen [" + screen + "] -> [" + theSubscriber + "(" + subscriber + "),(" + eventClass + ")]");
        this.subscriberRegister.register(screen, elementId, theSubscriber);
    }

    public void unsubscribe(String elementId, Object object) {
        if (object instanceof EventTopicSubscriber) {
            if (elementId == null) {
                this.log.warning("trying to unsubscribe events for an element with elementId = null. this won't work. offending object \"" + object + "\". try to find the offending element and give it an id!");
                return;
            }
            this.getEventService().unsubscribe(elementId, (EventTopicSubscriber)object);
            NiftyDefaults.eventBusLog.info("<- unsubscribe [" + elementId + "] -> [" + object + "]");
        }
    }

    public void unsubscribeScreen(Screen screen) {
        this.subscriberRegister.unsubscribeScreen(screen);
    }

    public void unsubscribeElement(Screen screen, String elementId) {
        this.subscriberRegister.unsubscribeElement(screen, elementId);
    }

    public void setAlternateKeyForNextLoadXml(String alternateKeyForNextLoadXmlParam) {
        this.alternateKeyForNextLoadXml = alternateKeyForNextLoadXmlParam;
    }

    public boolean update() {
        if (!this.currentScreen.isNull()) {
            this.mouseInputEventProcessor.begin();
            this.inputSystem.forwardEvents(this.niftyInputConsumer);
            if (this.mouseInputEventProcessor.hasLastMouseDownEvent()) {
                this.forwardMouseEventToScreen(this.mouseInputEventProcessor.getLastMouseDownEvent());
            }
        }
        this.handleDynamicElements();
        this.updateSoundSystem();
        if (this.log.isLoggable(Level.FINER)) {
            this.log.fine(this.currentScreen.debugOutput());
        }
        return this.exit;
    }

    private boolean forwardMouseEventToScreen(NiftyMouseInputEvent mouseEvent) {
        this.niftyMouse.updateMousePosition(mouseEvent.getMouseX(), mouseEvent.getMouseY());
        return this.currentScreen.mouseEvent(mouseEvent);
    }

    public void render(boolean clearScreen) {
        this.renderEngine.beginFrame();
        if (clearScreen) {
            this.renderEngine.clear();
        }
        if (!this.currentScreen.isNull()) {
            this.currentScreen.renderLayers(this.renderEngine);
        }
        if (this.exit) {
            this.renderEngine.clear();
        }
        this.renderEngine.endFrame();
        if (this.resolutionChanged) {
            this.resolutionChanged = false;
            this.displayResolutionChanged();
        }
    }

    private void updateSoundSystem() {
        long current = this.timeProvider.getMsTime();
        int delta = (int)(current - this.lastTime);
        this.soundSystem.update(delta);
        this.lastTime = current;
    }

    public void resetMouseInputEvents() {
        this.niftyInputConsumer.resetMouseDown();
        this.mouseInputEventProcessor.reset();
        if (!this.currentScreen.isNull()) {
            this.currentScreen.resetMouseDown();
        }
    }

    private void handleDynamicElements() {
        while (this.hasDynamics()) {
            this.invokeMethods();
            this.closePopUps();
            this.removeLayerElements();
            this.addControls();
            this.executeEndOfFrameElementActions();
        }
    }

    private boolean hasDynamics() {
        return this.hasInvokeMethods() || this.hasClosePopups() || this.hasRemoveLayerElements() || this.hasControlsToAdd() || this.hasEndOfFrameElementActions();
    }

    private boolean hasRemoveLayerElements() {
        if (this.currentScreen.isNull()) {
            return false;
        }
        return this.currentScreen.hasDynamicElements();
    }

    private void removeLayerElements() {
        if (!this.currentScreen.isNull()) {
            this.currentScreen.processAddAndRemoveLayerElements();
        }
    }

    private boolean hasClosePopups() {
        return !this.closePopupList.isEmpty();
    }

    private void closePopUps() {
        if (this.hasClosePopups()) {
            if (this.currentScreen.isNull()) {
                this.closePopupList.clear();
                return;
            }
            ArrayList<ClosePopUp> copy = new ArrayList<ClosePopUp>(this.closePopupList);
            this.closePopupList.clear();
            for (int i = 0; i < copy.size(); ++i) {
                ClosePopUp closePopup = copy.get(i);
                closePopup.close();
            }
        }
    }

    public void addControls() {
        if (this.hasControlsToAdd()) {
            ArrayList<ControlToAdd> copy = new ArrayList<ControlToAdd>(this.controlsToAdd);
            this.controlsToAdd.clear();
            for (int i = 0; i < copy.size(); ++i) {
                ControlToAdd controlToAdd = (ControlToAdd)copy.get(i);
                try {
                    controlToAdd.startControl(controlToAdd.createControl());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean hasControlsToAdd() {
        return !this.controlsToAdd.isEmpty();
    }

    public void addControlsWithoutStartScreen() {
        if (this.hasControlsToAdd()) {
            for (int i = 0; i < this.controlsToAdd.size(); ++i) {
                ControlToAdd controlToAdd = this.controlsToAdd.get(i);
                try {
                    controlToAdd.startControl(controlToAdd.createControl());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.controlsToAdd.clear();
        }
    }

    public void executeEndOfFrameElementActions() {
        if (this.hasEndOfFrameElementActions()) {
            ArrayList<EndOfFrameElementAction> listCopy = new ArrayList<EndOfFrameElementAction>(this.endOfFrameElementActions);
            this.endOfFrameElementActions.clear();
            for (int i = 0; i < listCopy.size(); ++i) {
                EndOfFrameElementAction elementAction = listCopy.get(i);
                elementAction.perform();
            }
        }
    }

    private boolean hasEndOfFrameElementActions() {
        return !this.endOfFrameElementActions.isEmpty();
    }

    public void fromXml(String filename, String startScreen) {
        this.prepareScreens(filename);
        this.loadFromFile(filename);
        this.gotoScreen(startScreen);
    }

    public void fromXmlWithoutStartScreen(String filename) {
        this.prepareScreens(filename);
        this.loadFromFile(filename);
    }

    public void fromXml(String filename, String startScreen, ScreenController ... controllers) {
        this.registerScreenController(controllers);
        this.prepareScreens(filename);
        this.loadFromFile(filename);
        this.gotoScreen(startScreen);
    }

    public void fromXml(String fileId, InputStream input, String startScreen) {
        this.prepareScreens(fileId);
        this.loadFromStream(input);
        this.gotoScreen(startScreen);
    }

    public void fromXmlWithoutStartScreen(String fileId, InputStream input) {
        this.prepareScreens(fileId);
        this.loadFromStream(input);
    }

    public void fromXml(String fileId, InputStream input, String startScreen, ScreenController ... controllers) {
        this.registerScreenController(controllers);
        this.prepareScreens(fileId);
        this.loadFromStream(input);
        this.gotoScreen(startScreen);
    }

    public void addXml(String filename) {
        this.loadFromFile(filename);
    }

    public void addXml(InputStream stream) {
        this.loadFromStream(stream);
    }

    public void validateXml(String filename) throws Exception {
        this.loader.validateNiftyXml(this.getResourceAsStream(filename));
    }

    public void validateXml(InputStream stream) throws Exception {
        this.loader.validateNiftyXml(stream);
    }

    void loadFromFile(String filename) {
        this.log.info("loadFromFile [" + filename + "]");
        try {
            long start = this.timeProvider.getMsTime();
            NiftyType niftyType = this.loader.loadNiftyXml("nifty.nxs", this.getResourceAsStream(filename), this);
            niftyType.create(this, this.timeProvider);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(niftyType.output());
            }
            long end = this.timeProvider.getMsTime();
            this.log.info("loadFromFile took [" + (end - start) + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void loadFromStream(InputStream stream) {
        this.log.info("loadFromStream []");
        try {
            long start = this.timeProvider.getMsTime();
            NiftyType niftyType = this.loader.loadNiftyXml("nifty.nxs", stream, this);
            niftyType.create(this, this.timeProvider);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(niftyType.output());
            }
            long end = this.timeProvider.getMsTime();
            this.log.info("loadFromStream took [" + (end - start) + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void prepareScreens(String xmlId) {
        this.screens.clear();
        this.currentLoaded = xmlId;
        this.exit = false;
    }

    public void gotoScreen(final String id) {
        if (this.gotoScreenInProgess) {
            this.log.info("gotoScreen [" + id + "] aborted because still in gotoScreenInProgress phase");
            return;
        }
        this.log.info("gotoScreen [" + id + "]");
        this.gotoScreenInProgess = true;
        if (this.currentScreen.isNull()) {
            this.gotoScreenInternal(id);
        } else {
            this.currentScreen.endScreen(new EndNotify(){

                @Override
                public void perform() {
                    Nifty.this.gotoScreenInternal(id);
                }
            });
        }
    }

    private void gotoScreenInternal(String id) {
        this.log.info("gotoScreenInternal [" + id + "]");
        this.currentScreen = this.screens.get(id);
        if (this.currentScreen == null) {
            this.currentScreen = new NullScreen();
            this.log.warning("screen [" + id + "] not found");
            this.gotoScreenInProgess = false;
            return;
        }
        if (this.alternateKeyForNextLoadXml != null) {
            this.currentScreen.setAlternateKey(this.alternateKeyForNextLoadXml);
            this.alternateKeyForNextLoadXml = null;
        }
        this.currentScreen.startScreen(new EndNotify(){

            @Override
            public void perform() {
                Nifty.this.gotoScreenInProgess = false;
            }
        });
    }

    public void setAlternateKey(String alternateKey) {
        this.alternateKey = alternateKey;
        for (Screen screen : this.screens.values()) {
            screen.setAlternateKey(alternateKey);
        }
    }

    public Collection<String> getAllScreensName() {
        LinkedList<String> sn = new LinkedList<String>();
        for (Screen screen : this.screens.values()) {
            sn.add(screen.getScreenId());
        }
        return sn;
    }

    public void removeScreen(final String id) {
        if (!this.currentScreen.isNull()) {
            if (this.currentScreen.getScreenId().equals(id)) {
                this.currentScreen.endScreen(new EndNotify(){

                    @Override
                    public void perform() {
                        Nifty.this.currentScreen = new NullScreen();
                        Nifty.this.removeScreenInternal(id);
                    }
                });
                return;
            }
            this.removeScreenInternal(id);
        }
    }

    private void removeScreenInternal(String id) {
        Screen screen = this.screens.remove(id);
        if (screen == null || screen.getLayerElements() == null || screen.getLayerElements().size() == 0) {
            return;
        }
        for (int i = 0; i < screen.getLayerElements().size(); ++i) {
            this.removeElement(screen, screen.getLayerElements().get(i));
        }
    }

    public Collection<String> getAllStylesName() {
        return this.styles.keySet();
    }

    public void exit() {
        this.currentScreen.endScreen(new EndNotify(){

            @Override
            public final void perform() {
                Nifty.this.exit = true;
                Nifty.this.currentScreen = new NullScreen();
            }
        });
    }

    public void resolutionChanged() {
        this.resolutionChanged = true;
    }

    private void displayResolutionChanged() {
        this.getRenderEngine().displayResolutionChanged();
        int newWidth = this.getRenderEngine().getWidth();
        int newHeight = this.getRenderEngine().getHeight();
        this.updateLayoutPart(this.currentScreen.getRootElement().getLayoutPart(), newWidth, newHeight);
        for (Element e : this.currentScreen.getLayerElements()) {
            this.updateLayoutPart(e.getLayoutPart(), newWidth, newHeight);
        }
        for (Element e : this.popups.values()) {
            this.updateLayoutPart(e.getLayoutPart(), newWidth, newHeight);
        }
        this.resetMouseInputEvents();
        this.currentScreen.resetLayout();
        this.currentScreen.layoutLayers();
    }

    private void updateLayoutPart(LayoutPart layoutPart, int width, int height) {
        Box box = layoutPart.getBox();
        box.setWidth(width);
        box.setHeight(height);
        BoxConstraints boxConstraints = layoutPart.getBoxConstraints();
        boxConstraints.setWidth(new SizeValue(width + "px"));
        boxConstraints.setHeight(new SizeValue(height + "px"));
    }

    public Screen getScreen(String id) {
        Screen screen = this.screens.get(id);
        if (screen == null) {
            this.log.warning("screen [" + id + "] not found");
            return null;
        }
        return screen;
    }

    public SoundSystem getSoundSystem() {
        return this.soundSystem;
    }

    public NiftyRenderEngine getRenderEngine() {
        return this.renderEngine;
    }

    public Screen getCurrentScreen() {
        return this.currentScreen;
    }

    public boolean isActive(String filename, String screenId) {
        return this.currentLoaded != null && this.currentLoaded.equals(filename) && !this.currentScreen.isNull() && this.currentScreen.getScreenId().equals(screenId);
    }

    public void registerPopup(PopupType popup) {
        this.popupTypes.put(popup.getAttributes().get("id"), popup);
    }

    public void showPopup(Screen screen, String id, Element defaultFocusElement) {
        Element popup = this.popups.get(id);
        if (popup == null) {
            this.log.warning("missing popup [" + id + "] o_O");
        } else {
            screen.addPopup(popup, defaultFocusElement);
        }
    }

    private Element createPopupFromType(PopupType popupTypeParam, String id) {
        Screen screen = this.getCurrentScreen();
        LayoutPart layerLayout = this.rootLayerFactory.createRootLayerLayoutPart(this);
        PopupType popupType = new PopupType(popupTypeParam);
        popupType.prepare(this, screen, screen.getRootElement().getElementType());
        Element element = popupType.create(screen.getRootElement(), this, screen, layerLayout);
        element.setId(id);
        this.fixupSubIds(element, id);
        if (screen.isBound()) {
            element.layoutElements();
            element.bindControls(screen);
        }
        return element;
    }

    private void fixupSubIds(Element element, String parentId) {
        String currentId = element.getId();
        if (currentId != null && currentId.startsWith("#")) {
            currentId = parentId + element.getId();
            element.setId(currentId);
        }
        if (currentId == null) {
            currentId = parentId;
        }
        for (int i = 0; i < element.getElements().size(); ++i) {
            Element e = element.getElements().get(i);
            this.fixupSubIds(e, currentId);
        }
    }

    public Element createPopup(String popupId) {
        return this.createAndAddPopup(NiftyIdCreator.generate(), this.popupTypes.get(popupId));
    }

    public Element createPopupWithId(String popupId, String id) {
        return this.createAndAddPopup(id, this.popupTypes.get(popupId));
    }

    public Element createPopupWithStyle(String popupId, String id, String style) {
        PopupType popupType = this.popupTypes.get(popupId);
        popupType.getAttributes().set("style", style);
        return this.createAndAddPopup(id, popupType);
    }

    public Element createPopupWithStyle(String popupId, String style) {
        return this.createPopupWithStyle(popupId, style, new Attributes());
    }

    public Element createPopupWithStyle(String popupId, String style, Attributes parameters) {
        PopupType popupType = new PopupType(this.popupTypes.get(popupId));
        popupType.getAttributes().set("style", style);
        popupType.getAttributes().merge(parameters);
        return this.createAndAddPopup(NiftyIdCreator.generate(), popupType);
    }

    private Element createAndAddPopup(String id, PopupType popupType) {
        Element popupElement = this.createPopupFromType(popupType, id);
        this.popups.put(id, popupElement);
        return popupElement;
    }

    public Element findPopupByName(String id) {
        return this.popups.get(id);
    }

    public Element getTopMostPopup() {
        if (this.currentScreen != null) {
            return this.currentScreen.getTopMostPopup();
        }
        return null;
    }

    public void closePopup(String id) {
        this.closePopupInternal(id, null);
    }

    public void closePopup(String id, EndNotify closeNotify) {
        this.closePopupInternal(id, closeNotify);
    }

    private void closePopupInternal(final String id, final EndNotify closeNotify) {
        Element popup = this.popups.get(id);
        if (popup == null) {
            this.log.warning("missing popup [" + id + "] o_O");
            return;
        }
        popup.resetAllEffects();
        popup.startEffect(EffectEventId.onEndScreen, new EndNotify(){

            @Override
            public void perform() {
                Nifty.this.closePopupList.add(new ClosePopUp(id, closeNotify));
            }
        });
    }

    public void addControl(Screen screen, Element element, StandardControl standardControl) {
        this.controlsToAdd.add(new ControlToAdd(screen, element, standardControl));
    }

    public void removeElement(Screen screen, Element element) {
        this.removeElement(screen, element, null);
    }

    public void removeElement(final Screen screen, final Element element, final EndNotify endNotify) {
        element.removeFromFocusHandler();
        element.startEffect(EffectEventId.onEndScreen, new EndNotify(){

            @Override
            public void perform() {
                Nifty.this.endOfFrameElementActions.add(new EndOfFrameElementAction(screen, element, new ElementRemoveAction(), endNotify));
            }
        });
    }

    public void moveElement(Screen screen, Element elementToMove, Element destination, EndNotify endNotify) {
        elementToMove.removeFromFocusHandler();
        this.endOfFrameElementActions.add(new EndOfFrameElementAction(screen, elementToMove, new ElementMoveAction(destination), endNotify));
    }

    public MouseInputEventProcessor getMouseInputEventQueue() {
        return this.mouseInputEventProcessor;
    }

    public void registerScreenController(ScreenController ... controllers) {
        for (ScreenController c : controllers) {
            this.registeredScreenControllers.add(c);
        }
    }

    public ScreenController findScreenController(String controllerClass) {
        for (ScreenController controller : this.registeredScreenControllers) {
            if (!controller.getClass().getName().equals(controllerClass)) continue;
            return controller;
        }
        return null;
    }

    public NiftyLoader getLoader() {
        return this.loader;
    }

    public TimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    public void addScreen(String id, Screen screen) {
        this.screens.put(id, screen);
    }

    public void registerStyle(StyleType style) {
        this.log.fine("registerStyle " + style.getStyleId());
        this.styles.put(style.getStyleId(), style);
    }

    public void registerControlDefintion(ControlDefinitionType controlDefintion) {
        this.controlDefintions.put(controlDefintion.getName(), controlDefintion);
    }

    public void registerEffect(RegisterEffectType registerEffectType) {
        this.registeredEffects.put(registerEffectType.getName(), registerEffectType);
    }

    public ControlDefinitionType resolveControlDefinition(String name) {
        if (name == null) {
            return null;
        }
        return this.controlDefintions.get(name);
    }

    public RegisterEffectType resolveRegisteredEffect(String name) {
        if (name == null) {
            return null;
        }
        return this.registeredEffects.get(name);
    }

    public StyleResolver getDefaultStyleResolver() {
        return new StyleResolverDefault(this.styles);
    }

    public String getAlternateKey() {
        return this.alternateKey;
    }

    public void delayedMethodInvoke(NiftyDelayedMethodInvoke method, Object[] params) {
        this.delayedMethodInvokes.add(new DelayedMethodInvoke(method, params));
    }

    public void invokeMethods() {
        if (this.hasInvokeMethods()) {
            ArrayList<DelayedMethodInvoke> workingCopy = new ArrayList<DelayedMethodInvoke>(this.delayedMethodInvokes);
            this.delayedMethodInvokes.clear();
            for (DelayedMethodInvoke method : workingCopy) {
                method.perform();
            }
        }
    }

    private boolean hasInvokeMethods() {
        return !this.delayedMethodInvokes.isEmpty();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Map<String, ResourceBundle> getResourceBundles() {
        return this.resourceBundles;
    }

    public void addResourceBundle(String id, String filename) {
        this.resourceBundleSource.put(id, filename);
        this.resourceBundles.put(id, ResourceBundle.getBundle(filename, this.locale));
    }

    public Properties getGlobalProperties() {
        return this.globalProperties;
    }

    public void setGlobalProperties(Properties globalProperties) {
        this.globalProperties = globalProperties;
    }

    public RootLayerFactory getRootLayerFactory() {
        return this.rootLayerFactory;
    }

    public void loadStyleFile(String styleFile) {
        try {
            NiftyType niftyType = new NiftyType();
            this.loader.loadStyleFile("nifty-styles.nxs", styleFile, niftyType, this);
            niftyType.create(this, this.getTimeProvider());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("loadStyleFile");
                this.log.info(niftyType.output());
            }
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
        }
    }

    public void loadControlFile(String controlFile) {
        try {
            NiftyType niftyType = new NiftyType();
            this.loader.loadControlFile("nifty-controls.nxs", controlFile, niftyType);
            niftyType.create(this, this.getTimeProvider());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("loadControlFile");
                this.log.info(niftyType.output());
            }
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
        }
    }

    public void registerResourceBundle(String id, String filename) {
        try {
            NiftyType niftyType = new NiftyType();
            ResourceBundleType resourceBundle = new ResourceBundleType();
            resourceBundle.getAttributes().set("id", id);
            resourceBundle.getAttributes().set("filename", filename);
            niftyType.addResourceBundle(resourceBundle);
            niftyType.create(this, this.getTimeProvider());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("registerResourceBundle");
                this.log.info(niftyType.output());
            }
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
        }
    }

    public void registerEffect(String name, String classParam) {
        try {
            NiftyType niftyType = new NiftyType();
            RegisterEffectType registerEffect = new RegisterEffectType(name, classParam);
            niftyType.addRegisterEffect(registerEffect);
            niftyType.create(this, this.getTimeProvider());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("registerEffect");
                this.log.info(niftyType.output());
            }
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
        }
    }

    public void registerSound(String id, String filename) {
        try {
            NiftyType niftyType = new NiftyType();
            RegisterSoundType registerSound = new RegisterSoundType();
            registerSound.getAttributes().set("id", id);
            registerSound.getAttributes().set("filename", filename);
            niftyType.addRegisterSound(registerSound);
            niftyType.create(this, this.getTimeProvider());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("registerSound");
                this.log.info(niftyType.output());
            }
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
        }
    }

    public void registerMusic(String id, String filename) {
        try {
            NiftyType niftyType = new NiftyType();
            RegisterMusicType registerMusic = new RegisterMusicType();
            registerMusic.getAttributes().set("id", id);
            registerMusic.getAttributes().set("filename", filename);
            niftyType.addRegisterMusic(registerMusic);
            niftyType.create(this, this.getTimeProvider());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("registerMusic");
                this.log.info(niftyType.output());
            }
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
        }
    }

    public void registerMouseCursor(String id, String filename, int hotspotX, int hotspotY) {
        try {
            this.getNiftyMouse().registerMouseCursor(id, filename, hotspotX, hotspotY);
        }
        catch (IOException e) {
            this.log.warning(e.getMessage());
        }
    }

    public NiftyMouse getNiftyMouse() {
        return this.niftyMouse;
    }

    public Element createElementFromType(Screen screen, Element parent, ElementType type) {
        if (type instanceof LayerType) {
            return this.createElementFromTypeInternal(screen, parent, type, this.getRootLayerFactory().createRootLayerLayoutPart(this));
        }
        return this.createElementFromTypeInternal(screen, parent, type, new LayoutPart());
    }

    private Element createElementFromTypeInternal(Screen screen, Element parent, ElementType type, LayoutPart layoutPart) {
        ElementType elementType = type.copy();
        elementType.prepare(this, screen, screen.getRootElement().getElementType());
        elementType.connectParentControls(parent);
        Element element = elementType.create(parent, this, screen, layoutPart);
        if (screen.isBound()) {
            screen.layoutLayers();
            element.bindControls(screen);
            element.initControls();
            element.startEffect(EffectEventId.onStartScreen);
            element.startEffect(EffectEventId.onActive);
            element.onStartScreen();
        }
        return element;
    }

    public NiftyImage createImage(String name, boolean filterLinear) {
        return this.renderEngine.createImage(name, filterLinear);
    }

    public void setDebugOptionPanelColors(boolean option) {
        this.debugOptionPanelColors = option;
    }

    public boolean isDebugOptionPanelColors() {
        return this.debugOptionPanelColors;
    }

    public String specialValuesReplace(String value) {
        return SpecialValuesReplace.replace(value, this.getResourceBundles(), this.currentScreen == null ? null : this.currentScreen.getScreenController(), this.globalProperties);
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    public RenderFont createFont(String name) {
        return this.getRenderEngine().createFont(name);
    }

    public String getFontname(RenderFont font) {
        return this.getRenderEngine().getFontname(font);
    }

    public void enableAutoScaling(int baseResolutionX, int baseResolutionY) {
        this.renderEngine.enableAutoScaling(baseResolutionX, baseResolutionY);
    }

    public void enableAutoScaling(int baseResolutionX, int baseResolutionY, float scaleX, float scaleY) {
        this.renderEngine.enableAutoScaling(baseResolutionX, baseResolutionY, scaleX, scaleY);
    }

    public void disableAutoScaling() {
        this.renderEngine.disableAutoScaling();
    }

    public InputStream getResourceAsStream(String ref) {
        return this.resourceLoader.getResourceAsStream(ref);
    }

    public NiftyResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    private static interface Action {
        public void perform(Screen var1, Element var2);
    }

    private static class ClassSaveEventTopicSubscriber
    implements EventTopicSubscriber,
    ProxySubscriber {
        private String elementId;
        private EventTopicSubscriber target;
        private Class eventClass;

        private ClassSaveEventTopicSubscriber(String elementId, EventTopicSubscriber target, Class eventClass) {
            this.elementId = elementId;
            this.target = target;
            this.eventClass = eventClass;
        }

        public String toString() {
            return super.toString() + "{" + this.elementId + "}{" + this.target + "}{" + this.eventClass + "}";
        }

        public void onEvent(String topic, Object data) {
            if (this.eventClass.isInstance(data)) {
                this.target.onEvent(topic, data);
            }
        }

        public String getElementId() {
            return this.elementId;
        }

        public Object getProxiedSubscriber() {
            return this.target;
        }

        public void proxyUnsubscribed() {
            this.target = null;
        }

        public ReferenceStrength getReferenceStrength() {
            return ReferenceStrength.STRONG;
        }
    }

    public class ClosePopUp {
        private String removePopupId;
        private EndNotify closeNotify;

        public ClosePopUp(String popupId, EndNotify closeNotifyParam) {
            this.removePopupId = popupId;
            this.closeNotify = closeNotifyParam;
        }

        public void close() {
            Nifty.this.currentScreen.closePopup((Element)Nifty.this.popups.get(this.removePopupId), this.closeNotify);
        }
    }

    private class ControlToAdd {
        private Screen screen;
        private Element parent;
        private StandardControl control;

        public ControlToAdd(Screen screenParam, Element parentParam, StandardControl standardControl) {
            this.screen = screenParam;
            this.parent = parentParam;
            this.control = standardControl;
        }

        public Element createControl() throws Exception {
            return this.control.createControl(Nifty.this, this.screen, this.parent);
        }

        public void startControl(Element newControl) {
            if (this.screen.isBound()) {
                newControl.bindControls(this.screen);
                newControl.initControls();
            }
            if (this.screen.isRunning()) {
                newControl.startEffect(EffectEventId.onStartScreen);
                newControl.startEffect(EffectEventId.onActive);
                newControl.onStartScreen();
            }
        }
    }

    private class DelayedMethodInvoke {
        private NiftyDelayedMethodInvoke method;
        private Object[] params;

        public DelayedMethodInvoke(NiftyDelayedMethodInvoke method, Object[] params) {
            this.method = method;
            this.params = params;
        }

        public void perform() {
            this.method.performInvoke(this.params);
        }
    }

    public class ElementMoveAction
    implements Action {
        private Element destinationElement;

        public ElementMoveAction(Element destinationElement) {
            this.destinationElement = destinationElement;
        }

        @Override
        public void perform(Screen screen, Element element) {
            Element parent = element.getParent();
            if (parent != null) {
                parent.getElements().remove(element);
            }
            element.setParent(this.destinationElement);
            this.destinationElement.add(element);
            screen.layoutLayers();
        }
    }

    public class ElementRemoveAction
    implements Action {
        @Override
        public void perform(Screen screen, Element element) {
            element.resetAllEffects();
            element.onEndScreen(screen);
            this.removeSingleElement(screen, element);
            Element parent = element.getParent();
            if (parent != null) {
                parent.getElements().remove(element);
                if (parent == screen.getRootElement()) {
                    screen.removeLayerElement(element);
                }
            }
            screen.layoutLayers();
        }

        private void removeSingleElement(Screen screen, Element element) {
            Iterator<Element> elementIt = element.getElements().iterator();
            while (elementIt.hasNext()) {
                Element el = elementIt.next();
                this.removeSingleElement(screen, el);
                elementIt.remove();
            }
        }
    }

    private class EndOfFrameElementAction {
        private Screen screen;
        private Element element;
        private Action action;
        private EndNotify endNotify;

        public EndOfFrameElementAction(Screen newScreen, Element newElement, Action action, EndNotify endNotify) {
            this.screen = newScreen;
            this.element = newElement;
            this.action = action;
            this.endNotify = endNotify;
        }

        public void perform() {
            this.action.perform(this.screen, this.element);
            if (this.endNotify != null) {
                this.endNotify.perform();
            }
        }
    }

    private class NiftyInputConsumerImpl
    implements NiftyInputConsumer {
        private ObjectPool<NiftyMouseInputEvent> pool = new ObjectPool<NiftyMouseInputEvent>(32, new ObjectPool.Factory<NiftyMouseInputEvent>(){

            @Override
            public NiftyMouseInputEvent createNew() {
                return new NiftyMouseInputEvent();
            }
        });
        private boolean button0Down = false;
        private boolean button1Down = false;
        private boolean button2Down = false;

        private NiftyInputConsumerImpl() {
        }

        @Override
        public boolean processMouseEvent(int mouseX, int mouseY, int mouseWheel, int button, boolean buttonDown) {
            boolean processed = this.processEvent(this.createEvent(mouseX, mouseY, mouseWheel, button, buttonDown));
            if (Nifty.this.inputEventLog.isLoggable(Level.INFO)) {
                Nifty.this.inputEventLog.info("[processMouseEvent] [" + mouseX + ", " + mouseY + ", " + mouseWheel + ", " + button + ", " + buttonDown + "] processed [" + processed + "]");
            }
            return processed;
        }

        @Override
        public boolean processKeyboardEvent(KeyboardInputEvent keyEvent) {
            if (Nifty.this.currentScreen.isNull()) {
                return false;
            }
            boolean result = Nifty.this.currentScreen.keyEvent(keyEvent);
            if (Nifty.this.inputEventLog.isLoggable(Level.INFO)) {
                Nifty.this.inputEventLog.info("[processKeyboardEvent] " + keyEvent + " processed [" + result + "]");
            }
            return result;
        }

        void resetMouseDown() {
            this.button0Down = false;
            this.button1Down = false;
            this.button2Down = false;
        }

        private NiftyMouseInputEvent createEvent(int mouseX, int mouseY, int mouseWheel, int button, boolean buttonDown) {
            switch (button) {
                case 0: {
                    this.button0Down = buttonDown;
                    break;
                }
                case 1: {
                    this.button1Down = buttonDown;
                    break;
                }
                case 2: {
                    this.button2Down = buttonDown;
                }
            }
            NiftyMouseInputEvent result = this.pool.allocate();
            result.initialize(Nifty.this.renderEngine.convertFromNativeX(mouseX), Nifty.this.renderEngine.convertFromNativeY(mouseY), mouseWheel, this.button0Down, this.button1Down, this.button2Down);
            return result;
        }

        private boolean processEvent(NiftyMouseInputEvent mouseInputEvent) {
            boolean handled = false;
            if (Nifty.this.mouseInputEventProcessor.canProcess(mouseInputEvent)) {
                Nifty.this.mouseInputEventProcessor.process(mouseInputEvent);
                handled = Nifty.this.forwardMouseEventToScreen(mouseInputEvent);
                Nifty.this.handleDynamicElements();
            }
            this.pool.free(mouseInputEvent);
            return handled;
        }
    }

    private class SubscriberRegistry {
        private Map<Screen, Map<String, List<ClassSaveEventTopicSubscriber>>> screenBasedSubscribers = new Hashtable<Screen, Map<String, List<ClassSaveEventTopicSubscriber>>>();

        private SubscriberRegistry() {
        }

        public void register(Screen screen, String elementId, ClassSaveEventTopicSubscriber subscriber) {
            List<ClassSaveEventTopicSubscriber> list;
            Map<String, List<ClassSaveEventTopicSubscriber>> elements = this.screenBasedSubscribers.get(screen);
            if (elements == null) {
                elements = new Hashtable<String, List<ClassSaveEventTopicSubscriber>>();
                this.screenBasedSubscribers.put(screen, elements);
            }
            if ((list = elements.get(elementId)) == null) {
                list = new ArrayList<ClassSaveEventTopicSubscriber>();
                elements.put(elementId, list);
            }
            list.add(subscriber);
        }

        public void unsubscribeScreen(Screen screen) {
            if (screen == null) {
                return;
            }
            Map<String, List<ClassSaveEventTopicSubscriber>> elements = this.screenBasedSubscribers.get(screen);
            if (elements != null && !elements.isEmpty()) {
                for (Map.Entry<String, List<ClassSaveEventTopicSubscriber>> entry : elements.entrySet()) {
                    List<ClassSaveEventTopicSubscriber> list = entry.getValue();
                    for (int i = 0; i < list.size(); ++i) {
                        ClassSaveEventTopicSubscriber subscriber = list.get(i);
                        Nifty.this.getEventService().unsubscribe(subscriber.getElementId(), (EventTopicSubscriber)subscriber);
                        NiftyDefaults.eventBusLog.info("<- unsubscribe screen for [" + screen + "] [" + subscriber.getElementId() + "] -> [" + subscriber + "]");
                    }
                    list.clear();
                }
                elements.clear();
            }
            this.screenBasedSubscribers.remove(screen);
        }

        public void unsubscribeElement(Screen screen, String elementId) {
            List<ClassSaveEventTopicSubscriber> list;
            if (screen == null || elementId == null) {
                return;
            }
            Map<String, List<ClassSaveEventTopicSubscriber>> elements = this.screenBasedSubscribers.get(screen);
            if (elements != null && !elements.isEmpty() && (list = elements.get(elementId)) != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    ClassSaveEventTopicSubscriber subscriber = list.get(i);
                    Nifty.this.getEventService().unsubscribe(subscriber.getElementId(), (EventTopicSubscriber)subscriber);
                    NiftyDefaults.eventBusLog.info("<- unsubscribe element [" + elementId + "] [" + subscriber.getElementId() + "] -> [" + subscriber + "]");
                }
                list.clear();
            }
        }
    }
}

