/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.builder;

import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectAttributes;
import de.lessvoid.nifty.loaderv2.types.EffectValueType;
import java.util.logging.Logger;

public class EffectBuilder {
    private static Logger logger = Logger.getLogger(EffectBuilder.class.getName());
    protected ControlEffectAttributes attributes = new ControlEffectAttributes();

    public EffectBuilder(String effectName) {
        this.attributes.setName(effectName);
    }

    public EffectBuilder inherit(boolean inherit) {
        this.attributes.setInherit(String.valueOf(inherit));
        return this;
    }

    public EffectBuilder inherit() {
        this.attributes.setInherit("true");
        return this;
    }

    public EffectBuilder post(boolean post) {
        this.attributes.setPost(String.valueOf(post));
        return this;
    }

    public EffectBuilder overlay(boolean overlay) {
        this.attributes.setOverlay(String.valueOf(overlay));
        return this;
    }

    public EffectBuilder alternateEnable(String alternateEnable) {
        this.attributes.setAlternateEnable(alternateEnable);
        return this;
    }

    public EffectBuilder alternateDisable(String alternateDisable) {
        this.attributes.setAlternateDisable(alternateDisable);
        return this;
    }

    public EffectBuilder customKey(String customKey) {
        this.attributes.setCustomKey(customKey);
        return this;
    }

    public EffectBuilder neverStopRendering(boolean neverStopRendering) {
        this.attributes.setNeverStopRendering(String.valueOf(neverStopRendering));
        return this;
    }

    public EffectBuilder effectParameter(String key, String value) {
        this.attributes.setAttribute(key, value);
        return this;
    }

    public EffectBuilder startDelay(int ms) {
        this.attributes.setStartDelay(String.valueOf(ms));
        return this;
    }

    public EffectBuilder length(int ms) {
        this.attributes.setLength(String.valueOf(ms));
        return this;
    }

    public EffectBuilder oneShot(boolean oneShot) {
        this.attributes.setOneShot(String.valueOf(oneShot));
        return this;
    }

    public EffectBuilder timeType(String timeType) {
        this.attributes.setTimeType(timeType);
        return this;
    }

    public EffectBuilder onStartEffectCallback(String callback) {
        this.attributes.setOnStartEffectCallback(callback);
        return this;
    }

    public EffectBuilder onEndEffectCallback(String callback) {
        this.attributes.setOnEndEffectCallback(callback);
        return this;
    }

    public ControlEffectAttributes getAttributes() {
        return this.attributes;
    }

    public EffectBuilder effectValue(String ... values) {
        if (values == null || values.length % 2 != 0) {
            logger.warning("effect values must be given in pairs, example: effectValue(\"color\", \"#f00f\")");
            return this;
        }
        EffectValueType effectValue = new EffectValueType();
        for (int i = 0; i < values.length / 2; ++i) {
            String key = values[i * 2 + 0];
            String value = values[i * 2 + 1];
            effectValue.getAttributes().set(key, value);
        }
        this.attributes.addEffectValues(effectValue);
        return this;
    }
}

