/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.layout.manager;

import de.lessvoid.nifty.layout.Box;
import de.lessvoid.nifty.layout.BoxConstraints;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.layout.manager.LayoutManager;
import de.lessvoid.nifty.tools.SizeValue;
import java.util.List;

public class AbsolutePositionLayout
implements LayoutManager {
    private PostProcess post;

    public AbsolutePositionLayout() {
        this.post = new DefaultPostProcess();
    }

    public AbsolutePositionLayout(PostProcess post) {
        this.post = post;
    }

    @Override
    public void layoutElements(LayoutPart rootElement, List<LayoutPart> elements) {
        if (rootElement == null || elements == null || elements.size() == 0) {
            return;
        }
        int rootBoxX = this.getRootBoxX(rootElement);
        int rootBoxY = this.getRootBoxY(rootElement);
        int rootBoxWidth = this.getRootBoxWidth(rootElement);
        int rootBoxHeight = this.getRootBoxHeight(rootElement);
        for (int i = 0; i < elements.size(); ++i) {
            LayoutPart p = elements.get(i);
            Box box = p.getBox();
            BoxConstraints cons = p.getBoxConstraints();
            if (cons == null) continue;
            if (cons.getX() != null) {
                box.setX(rootBoxX + cons.getX().getValueAsInt(rootBoxWidth));
            }
            if (cons.getY() != null) {
                box.setY(rootBoxY + cons.getY().getValueAsInt(rootBoxHeight));
            }
            if (cons.getWidth() != null && cons.getWidth().hasHeightSuffix()) {
                if (cons.getHeight() != null) {
                    box.setHeight(cons.getHeight().getValueAsInt(rootBoxHeight));
                }
                box.setWidth(cons.getWidth().getValueAsInt(box.getHeight()));
            } else if (cons.getHeight() != null && cons.getHeight().hasWidthSuffix()) {
                if (cons.getWidth() != null) {
                    box.setWidth(cons.getWidth().getValueAsInt(rootBoxWidth));
                }
                box.setHeight(cons.getHeight().getValueAsInt(box.getWidth()));
            } else {
                if (cons.getWidth() != null) {
                    box.setWidth(cons.getWidth().getValueAsInt(rootBoxWidth));
                }
                if (cons.getHeight() != null) {
                    box.setHeight(cons.getHeight().getValueAsInt(rootBoxHeight));
                }
            }
            this.post.process(rootBoxX, rootBoxY, rootBoxWidth, rootBoxHeight, box);
        }
    }

    @Override
    public final SizeValue calculateConstraintWidth(LayoutPart root, List<LayoutPart> children) {
        return null;
    }

    @Override
    public final SizeValue calculateConstraintHeight(LayoutPart root, List<LayoutPart> children) {
        return null;
    }

    private int getRootBoxX(LayoutPart root) {
        return root.getBox().getX() + root.getBoxConstraints().getPaddingLeft().getValueAsInt(root.getBox().getWidth());
    }

    private int getRootBoxY(LayoutPart root) {
        return root.getBox().getY() + root.getBoxConstraints().getPaddingTop().getValueAsInt(root.getBox().getHeight());
    }

    private int getRootBoxWidth(LayoutPart root) {
        return root.getBox().getWidth() - root.getBoxConstraints().getPaddingLeft().getValueAsInt(root.getBox().getWidth()) - root.getBoxConstraints().getPaddingRight().getValueAsInt(root.getBox().getWidth());
    }

    private int getRootBoxHeight(LayoutPart root) {
        return root.getBox().getHeight() - root.getBoxConstraints().getPaddingTop().getValueAsInt(root.getBox().getHeight()) - root.getBoxConstraints().getPaddingBottom().getValueAsInt(root.getBox().getHeight());
    }

    public static class DefaultPostProcess
    implements PostProcess {
        @Override
        public void process(int rootBoxX, int rootBoxY, int rootBoxWidth, int rootBoxHeight, Box box) {
        }
    }

    public static class KeepInsidePostProcess
    implements PostProcess {
        @Override
        public void process(int rootBoxX, int rootBoxY, int rootBoxWidth, int rootBoxHeight, Box box) {
            int width = rootBoxWidth - box.getWidth();
            int height = rootBoxHeight - box.getHeight();
            if (box.getX() < rootBoxX) {
                box.setX(rootBoxX);
            }
            if (box.getX() > width) {
                box.setX(width);
            }
            if (box.getY() < rootBoxY) {
                box.setY(rootBoxY);
            }
            if (box.getY() > height) {
                box.setY(height);
            }
        }
    }

    public static interface PostProcess {
        public void process(int var1, int var2, int var3, int var4, Box var5);
    }
}

