/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic;

import com.jme3.cinematic.KeyFrame;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLine
extends HashMap<Integer, KeyFrame>
implements Savable {
    protected int keyFramesPerSeconds = 30;
    protected int lastKeyFrameIndex = 0;

    public KeyFrame getKeyFrameAtTime(float time) {
        return (KeyFrame)this.get(this.getKeyFrameIndexFromTime(time));
    }

    public KeyFrame getKeyFrameAtIndex(int keyFrameIndex) {
        return (KeyFrame)this.get(keyFrameIndex);
    }

    public void addKeyFrameAtTime(float time, KeyFrame keyFrame) {
        this.addKeyFrameAtIndex(this.getKeyFrameIndexFromTime(time), keyFrame);
    }

    public void addKeyFrameAtIndex(int keyFrameIndex, KeyFrame keyFrame) {
        this.put(keyFrameIndex, keyFrame);
        keyFrame.setIndex(keyFrameIndex);
        if (this.lastKeyFrameIndex < keyFrameIndex) {
            this.lastKeyFrameIndex = keyFrameIndex;
        }
    }

    public void removeKeyFrame(int keyFrameIndex) {
        this.remove(keyFrameIndex);
        if (this.lastKeyFrameIndex == keyFrameIndex) {
            KeyFrame kf = null;
            int i = keyFrameIndex;
            while (kf == null && i >= 0) {
                kf = this.getKeyFrameAtIndex(i);
                this.lastKeyFrameIndex = i--;
            }
        }
    }

    public void removeKeyFrame(float time) {
        this.removeKeyFrame(this.getKeyFrameIndexFromTime(time));
    }

    public int getKeyFrameIndexFromTime(float time) {
        return Math.round(time * (float)this.keyFramesPerSeconds);
    }

    public float getKeyFrameTime(KeyFrame keyFrame) {
        return (float)keyFrame.getIndex() / (float)this.keyFramesPerSeconds;
    }

    public Collection<KeyFrame> getAllKeyFrames() {
        return this.values();
    }

    public int getLastKeyFrameIndex() {
        return this.lastKeyFrameIndex;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        ArrayList list = new ArrayList();
        list.addAll(this.values());
        oc.writeSavableArrayList(list, "keyFrames", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        ArrayList list = ic.readSavableArrayList("keyFrames", null);
        for (KeyFrame keyFrame : list) {
            this.addKeyFrameAtIndex(keyFrame.getIndex(), keyFrame);
        }
    }
}

