/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.util.NativeObject;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NativeObjectManager {
    private static final Logger logger = Logger.getLogger(NativeObjectManager.class.getName());
    private static final int MAX_REMOVES_PER_FRAME = 100;
    private ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private ArrayList<NativeObjectRef> refList = new ArrayList();

    public void registerForCleanup(NativeObject obj) {
        NativeObjectRef ref = new NativeObjectRef(obj);
        this.refList.add(ref);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Registered: {0}", new String[]{obj.toString()});
        }
    }

    public void deleteUnused(Object rendererObject) {
        NativeObjectRef ref;
        int removed;
        for (removed = 0; removed < 100 && (ref = (NativeObjectRef)this.refQueue.poll()) != null; ++removed) {
            this.refList.remove(ref);
            ref.objClone.deleteObject(rendererObject);
        }
        if (removed >= 1) {
            logger.log(Level.FINE, "NativeObjectManager: {0} native objects were removed from GL", removed);
        }
    }

    public void deleteAllObjects(Object rendererObject) {
        this.deleteUnused(rendererObject);
        for (NativeObjectRef ref : this.refList) {
            ref.objClone.deleteObject(rendererObject);
            NativeObject realObj = (NativeObject)ref.realObj.get();
            if (realObj == null) continue;
            realObj.resetObject();
        }
        this.refList.clear();
    }

    public void resetObjects() {
        for (NativeObjectRef ref : this.refList) {
            NativeObject realObj = (NativeObject)ref.realObj.get();
            if (realObj == null) continue;
            realObj.resetObject();
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.log(Level.FINEST, "Reset: {0}", realObj);
        }
        this.refList.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NativeObjectRef
    extends PhantomReference<Object> {
        private NativeObject objClone;
        private WeakReference<NativeObject> realObj;

        public NativeObjectRef(NativeObject obj) {
            super(obj.handleRef, NativeObjectManager.this.refQueue);
            assert (obj.handleRef != null);
            this.realObj = new WeakReference<NativeObject>(obj);
            this.objClone = obj.createDestructableClone();
        }
    }
}

