/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.bulletphysics.collision.shapes.ConeShape;
import com.bulletphysics.collision.shapes.ConeShapeX;
import com.bulletphysics.collision.shapes.ConeShapeZ;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;

public class ConeCollisionShape
extends CollisionShape {
    protected float radius;
    protected float height;
    protected int axis;

    public ConeCollisionShape() {
    }

    public ConeCollisionShape(float radius, float height, int axis) {
        this.radius = radius;
        this.height = radius;
        this.axis = axis;
        this.createShape();
    }

    public ConeCollisionShape(float radius, float height) {
        this.radius = radius;
        this.height = radius;
        this.axis = 1;
        this.createShape();
    }

    public float getRadius() {
        return this.radius;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write(this.radius, "radius", 0.5f);
        capsule.write(this.height, "height", 0.5f);
        capsule.write((float)this.axis, "axis", 0.5f);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.radius = capsule.readFloat("radius", 0.5f);
        this.radius = capsule.readFloat("height", 0.5f);
        this.radius = capsule.readFloat("axis", 0.5f);
        this.createShape();
    }

    protected void createShape() {
        if (this.axis == 0) {
            this.cShape = new ConeShapeX(this.radius, this.height);
        } else if (this.axis == 1) {
            this.cShape = new ConeShape(this.radius, this.height);
        } else if (this.axis == 2) {
            this.cShape = new ConeShapeZ(this.radius, this.height);
        }
        this.cShape.setLocalScaling(Converter.convert(this.getScale()));
        this.cShape.setMargin(this.margin);
    }
}

