varying vec2 vertex_texCoord;

uniform vec2 resolution;

uniform sampler2D texScreen;

uniform float fade;

vec4 radialFade(vec4 colour, vec2 pixelPosition, float fade)
{
	return colour * clamp((1-distance(pixelPosition,vec2(0.5,0.5))) * fade ,0.0,1.0);
}

void main()
{
	vec4 colour = texture2D(texScreen,vertex_texCoord);
	gl_FragColor = radialFade(colour,gl_FragCoord.xy/resolution,fade);
}
