/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryonet.EndPoint;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.KryoNetException;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.Serialization;
import com.esotericsoftware.kryonet.TcpConnection;
import com.esotericsoftware.kryonet.UdpConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;

public class Connection {
    int id = -1;
    private String name;
    EndPoint endPoint;
    TcpConnection tcp;
    UdpConnection udp;
    InetSocketAddress udpRemoteAddress;
    private Listener[] listeners = new Listener[0];
    private Object listenerLock = new Object();
    private int lastPingID;
    private long lastPingSendTime;
    private int returnTripTime;
    volatile boolean isConnected;

    protected Connection() {
    }

    void initialize(Serialization serialization, int n, int n2) {
        this.tcp = new TcpConnection(serialization, n, n2);
    }

    public int getID() {
        return this.id;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public int sendTCP(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        try {
            int n = this.tcp.send(this, object);
            if (n == 0) {
                // empty if block
            }
            return n;
        }
        catch (IOException iOException) {
            this.close();
            return 0;
        }
        catch (KryoNetException kryoNetException) {
            this.close();
            return 0;
        }
    }

    public int sendUDP(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        InetSocketAddress inetSocketAddress = this.udpRemoteAddress;
        if (inetSocketAddress == null && this.udp != null) {
            inetSocketAddress = this.udp.connectedAddress;
        }
        if (inetSocketAddress == null && this.isConnected) {
            throw new IllegalStateException("Connection is not connected via UDP.");
        }
        try {
            if (inetSocketAddress == null) {
                throw new SocketException("Connection is closed.");
            }
            int n = this.udp.send(this, object, inetSocketAddress);
            if (n == 0) {
                // empty if block
            }
            return n;
        }
        catch (IOException iOException) {
            this.close();
            return 0;
        }
        catch (KryoNetException kryoNetException) {
            this.close();
            return 0;
        }
    }

    public void close() {
        boolean bl = this.isConnected;
        this.isConnected = false;
        this.tcp.close();
        if (this.udp != null && this.udp.connectedAddress != null) {
            this.udp.close();
        }
        if (bl) {
            this.notifyDisconnected();
        }
        this.setConnected(false);
    }

    public void updateReturnTripTime() {
        FrameworkMessage.Ping ping = new FrameworkMessage.Ping();
        ping.id = this.lastPingID++;
        this.lastPingSendTime = System.currentTimeMillis();
        this.sendTCP(ping);
    }

    public int getReturnTripTime() {
        return this.returnTripTime;
    }

    public void setKeepAliveTCP(int n) {
        this.tcp.keepAliveMillis = n;
    }

    public void setTimeout(int n) {
        this.tcp.timeoutMillis = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            Listener[] listenerArray = this.listeners;
            int n = listenerArray.length;
            for (int i = 0; i < n; ++i) {
                if (listener != listenerArray[i]) continue;
                return;
            }
            Listener[] listenerArray2 = new Listener[n + 1];
            listenerArray2[0] = listener;
            System.arraycopy(listenerArray, 0, listenerArray2, 1, n);
            this.listeners = listenerArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            Listener[] listenerArray = this.listeners;
            int n = listenerArray.length;
            if (n == 0) {
                return;
            }
            Listener[] listenerArray2 = new Listener[n - 1];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Listener listener2 = listenerArray[i];
                if (listener == listener2) continue;
                if (n2 == n - 1) {
                    return;
                }
                listenerArray2[n2++] = listener2;
            }
            this.listeners = listenerArray2;
        }
    }

    void notifyConnected() {
        Listener[] listenerArray = this.listeners;
        int n = listenerArray.length;
        for (int i = 0; i < n; ++i) {
            listenerArray[i].connected(this);
        }
    }

    void notifyDisconnected() {
        Listener[] listenerArray = this.listeners;
        int n = listenerArray.length;
        for (int i = 0; i < n; ++i) {
            listenerArray[i].disconnected(this);
        }
    }

    void notifyIdle() {
        Listener[] listenerArray = this.listeners;
        int n = listenerArray.length;
        for (int i = 0; i < n; ++i) {
            listenerArray[i].idle(this);
            if (!this.isIdle()) break;
        }
    }

    void notifyReceived(Object object) {
        Listener[] listenerArray;
        if (object instanceof FrameworkMessage.Ping) {
            listenerArray = (Listener[])object;
            if (listenerArray.isReply) {
                if (listenerArray.id == this.lastPingID - 1) {
                    this.returnTripTime = (int)(System.currentTimeMillis() - this.lastPingSendTime);
                }
            } else {
                listenerArray.isReply = true;
                this.sendTCP(listenerArray);
            }
        }
        listenerArray = this.listeners;
        int n = listenerArray.length;
        for (int i = 0; i < n; ++i) {
            listenerArray[i].received(this, object);
        }
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    public InetSocketAddress getRemoteAddressTCP() {
        Socket socket;
        SocketChannel socketChannel = this.tcp.socketChannel;
        if (socketChannel != null && (socket = this.tcp.socketChannel.socket()) != null) {
            return (InetSocketAddress)socket.getRemoteSocketAddress();
        }
        return null;
    }

    public InetSocketAddress getRemoteAddressUDP() {
        InetSocketAddress inetSocketAddress = this.udp.connectedAddress;
        if (inetSocketAddress != null) {
            return inetSocketAddress;
        }
        return this.udpRemoteAddress;
    }

    public void setBufferPositionFix(boolean bl) {
        this.tcp.bufferPositionFix = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getTcpWriteBufferSize() {
        return this.tcp.writeBuffer.position();
    }

    public boolean isIdle() {
        return (float)this.tcp.writeBuffer.position() / (float)this.tcp.writeBuffer.capacity() < this.tcp.idleThreshold;
    }

    public void setIdleThreshold(float f) {
        this.tcp.idleThreshold = f;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return "Connection " + this.id;
    }

    void setConnected(boolean bl) {
        this.isConnected = bl;
        if (bl && this.name == null) {
            this.name = "Connection " + this.id;
        }
    }
}

