/*
 * Decompiled with CFR 0.152.
 */
package ClashOfCars;

import ClashOfCars.camera;
import ClashOfCars.car;
import ClashOfCars.network;
import ClashOfCars.world;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.gl2.GLUT;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class openGL
extends GLCanvas
implements GLEventListener {
    private static car clCar;
    private static car serCar;
    private static int cameraS;
    public static float angle_adjust;
    private static network net;
    private static boolean a;
    private static float oldspeed;
    private static float pitch;
    private static camera cam;
    private static world World;
    private Vector<Texture> textures;
    private static float shotState;
    private static long shootTime;
    private static long shootEnemy;
    private static final Set<Character> pressed;
    GLU glu;
    private GLUT glut = new GLUT();

    static {
        cameraS = 0;
        angle_adjust = 0.0f;
        shotState = 0.0f;
        pressed = new HashSet<Character>();
    }

    public openGL() {
        this.textures = new Vector();
        this.addGLEventListener(this);
        clCar = new car(3.5f, 0.0f, 1.9f, 0);
        serCar = new car(-3.5f, 0.0f, 1.9f, 0);
        cam = new camera();
        World = new world();
        pitch = 1.0f;
        shootTime = System.currentTimeMillis();
        oldspeed = openGL.clCar.speed;
        a = openGL.clCar.fake_drift;
        try {
            net = new network(serCar, clCar);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Thread one = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(45L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    net.sendCar(shotState);
                }
            }
        };
        one.start();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                openGL canvas = new openGL();
                canvas.setPreferredSize(new Dimension(640, 480));
                canvas.setFocusable(true);
                canvas.requestFocus();
                canvas.addKeyListener(new KeyListener(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyChar() == ' ') {
                            if (!clCar.fake_drift) {
                                if ((double)clCar.speed > 0.25 && (clCar.steered_left || clCar.steered_right)) {
                                    clCar.fake_drift = true;
                                    if (clCar.steered_left) {
                                        clCar.fake_drift_right = true;
                                        clCar.fake_drift_left = false;
                                    } else if (clCar.steered_right) {
                                        clCar.fake_drift_left = true;
                                        clCar.fake_drift_right = false;
                                    }
                                    clCar.drift_r = clCar.speed * 20.0f;
                                    clCar.drift_increase = clCar.speed * 5.0f;
                                    if (clCar.fake_drift_left) {
                                        clCar.drift_t = clCar.angle - 90.0f;
                                        clCar.drift_x = (float)((double)clCar.xPos() + (double)clCar.drift_r * Math.cos(Math.toRadians(90.0f + clCar.angle)));
                                        clCar.drift_y = (float)((double)clCar.yPos() + (double)clCar.drift_r * Math.sin(Math.toRadians(90.0f + clCar.angle)));
                                    } else if (clCar.fake_drift_right) {
                                        clCar.drift_t = clCar.angle + 90.0f;
                                        clCar.drift_x = (float)((double)clCar.xPos() + (double)clCar.drift_r * Math.cos(Math.toRadians(clCar.angle - 90.0f)));
                                        clCar.drift_y = (float)((double)clCar.yPos() + (double)clCar.drift_r * Math.sin(Math.toRadians(clCar.angle - 90.0f)));
                                    }
                                } else {
                                    clCar.slower();
                                    if (clCar.speed <= -0.0f) {
                                        clCar.speed = -0.0f;
                                    }
                                }
                            }
                        } else if (e.getKeyChar() == 'c') {
                            cameraS = cameraS + 1;
                            cameraS = cameraS % 3;
                        } else if (e.getKeyChar() == '7' && System.currentTimeMillis() - shootTime >= 200L) {
                            clCar.shoot();
                            shootTime = System.currentTimeMillis();
                            shotState = 1.0f;
                        } else if (e.getKeyChar() == 'r') {
                            clCar = new car(-3.5f, 0.0f, 1.9f, 0);
                        } else {
                            pressed.add(Character.valueOf(e.getKeyChar()));
                        }
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                        pressed.remove(Character.valueOf(e.getKeyChar()));
                        if (e.getKeyChar() != 'w' && e.getKeyChar() != 's') {
                            if (e.getKeyChar() == 'a') {
                                clCar.no_steer = true;
                            } else if (e.getKeyChar() == 'd') {
                                clCar.no_steer = true;
                            } else if (e.getKeyChar() == ' ') {
                                clCar.fake_drift = false;
                                clCar.fake_drift_right = false;
                                clCar.fake_drift_left = false;
                                angle_adjust = 0.0f;
                            } else if (e.getKeyChar() == '7') {
                                shotState = 0.0f;
                            }
                        }
                    }

                    @Override
                    public void keyTyped(KeyEvent arg0) {
                    }
                });
                final FPSAnimator animator = new FPSAnimator(canvas, 60, true);
                JFrame frame = new JFrame();
                frame.getContentPane().add(canvas);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        new Thread(){

                            @Override
                            public void run() {
                                if (animator.isStarted()) {
                                    animator.stop();
                                }
                                System.exit(0);
                            }
                        }.start();
                    }
                });
                frame.pack();
                frame.setTitle("Clash of Cars");
                frame.setVisible(true);
                animator.start();
            }
        });
    }

    public void ispressed() {
        for (char i : pressed) {
            if (i == 'w') {
                if (openGL.clCar.fake_drift) {
                    openGL.clCar.drift_r = (float)((double)openGL.clCar.drift_r - 0.005);
                    openGL.clCar.drift_increase = (float)((double)openGL.clCar.drift_increase + 0.005);
                    continue;
                }
                if ((double)openGL.clCar.speed < 0.45) {
                    clCar.faster();
                }
                if (!openGL.clCar.drifted) continue;
                openGL.clCar.drift += 0.005f;
                continue;
            }
            if (i == 's') {
                clCar.slower();
                if ((double)openGL.clCar.speed > 0.04) {
                    openGL.clCar.drift = openGL.clCar.speed / 3.0f;
                    openGL.clCar.drifted = true;
                }
                if (!(openGL.clCar.speed <= -0.05f)) continue;
                openGL.clCar.speed = -0.05f;
                continue;
            }
            if (i == 'a') {
                if (openGL.clCar.fake_drift) {
                    openGL.clCar.drift_r = openGL.clCar.fake_drift_right ? (float)((double)openGL.clCar.drift_r + 0.005) : (float)((double)openGL.clCar.drift_r - 0.003);
                }
                openGL.clCar.no_steer = false;
                openGL.clCar.steered_right = true;
                openGL.clCar.steered_left = false;
                if (openGL.clCar.drifted) {
                    openGL.clCar.drifted_right = true;
                    openGL.clCar.steer += 3.0f;
                }
                openGL.clCar.steer += 3.0f;
                if (!(openGL.clCar.steer >= 30.0f)) continue;
                if (!openGL.clCar.drifted_right) {
                    openGL.clCar.steer = 30.0f;
                    continue;
                }
                openGL.clCar.steer = 40.0f;
                continue;
            }
            if (i == 'd') {
                if (openGL.clCar.fake_drift) {
                    openGL.clCar.drift_r = openGL.clCar.fake_drift_left ? (float)((double)openGL.clCar.drift_r + 0.005) : (float)((double)openGL.clCar.drift_r - 0.003);
                }
                openGL.clCar.no_steer = false;
                openGL.clCar.steered_right = false;
                openGL.clCar.steered_left = true;
                if (openGL.clCar.drifted) {
                    openGL.clCar.drifted_left = true;
                    openGL.clCar.steer -= 3.0f;
                }
                openGL.clCar.steer -= 3.0f;
                if (!(openGL.clCar.steer <= -35.0f)) continue;
                if (!openGL.clCar.drifted_left) {
                    openGL.clCar.steer = -30.0f;
                    continue;
                }
                openGL.clCar.steer = -40.0f;
                continue;
            }
            if (i == 'k') {
                clCar.breaker();
                continue;
            }
            if (i == 'o') continue;
        }
    }

    public void isShot(car c) {
    }

    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL2 gl = drawable.getGL().getGL2();
        if (height == 0) {
            height = 1;
        }
        float aspect = (float)width / (float)height;
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.glu.gluPerspective(45.0, (double)aspect, 0.1, 1000.0);
        gl.glMatrixMode(5888);
    }

    @Override
    public void display(GLAutoDrawable arg0) {
        GL2 gl = arg0.getGL().getGL2();
        gl.glClear(16640);
        gl.glLoadIdentity();
        this.ispressed();
        cam.look(this.glu, clCar, cameraS);
        if (openGL.clCar.fake_drift) {
            openGL.clCar.speed -= 3.0E-4f;
            if (openGL.clCar.fake_drift_right) {
                clCar.setAngle(openGL.clCar.drift_t - 90.0f - angle_adjust);
            } else if (openGL.clCar.fake_drift_left) {
                clCar.setAngle(openGL.clCar.drift_t + 90.0f + angle_adjust);
            }
            clCar.setxPos((float)((double)openGL.clCar.drift_x + (double)openGL.clCar.drift_r * Math.cos(Math.toRadians(openGL.clCar.drift_t))));
            clCar.setyPos((float)((double)openGL.clCar.drift_y + (double)openGL.clCar.drift_r * Math.sin(Math.toRadians(openGL.clCar.drift_t))));
            if (angle_adjust < 60.0f) {
                angle_adjust = (float)((double)angle_adjust + 0.8);
            }
        }
        if (!openGL.clCar.fake_drift) {
            clCar.Move();
        } else {
            clCar.setCube();
        }
        clCar.isCollide(serCar);
        serCar.isCollide(clCar);
        clCar.isCollide(World);
        if (net.getState() && System.currentTimeMillis() - shootEnemy >= 200L) {
            shootEnemy = System.currentTimeMillis();
            serCar.shoot();
        }
        serCar.isShot(openGL.clCar.bullets);
        clCar.isShot(openGL.serCar.bullets);
        World.isShot(openGL.clCar.bullets, this.textures);
        World.isShot(openGL.serCar.bullets, this.textures);
        clCar.isShot(openGL.serCar.bullets);
        clCar.uploadBullets();
        serCar.uploadBullets();
        clCar.iscollided(serCar);
        serCar.iscollided(clCar);
        serCar.Move();
        gl.glEnable(3553);
        World.drawWorld(gl, this.textures);
        clCar.drawCar(gl, 2, this.glu, this.textures);
        serCar.drawCar(gl, 1, this.glu, this.textures);
        float[] rgba = new float[]{0.4f, 0.4f, 0.4f};
        float[] dif = new float[]{0.6f, 0.6f, 0.6f};
        gl.glMaterialfv(1028, 4608, rgba, 0);
        gl.glMaterialfv(1028, 4610, rgba, 0);
        gl.glMaterialfv(1028, 4609, dif, 0);
        gl.glMaterialf(1028, 5633, 50.0f);
        gl.glBegin(7);
        gl.glNormal3f(0.0f, 0.0f, 1.0f);
        int i = -100;
        while (i <= 100) {
            int j = -100;
            while (j <= 100) {
                if (i < -15 || i > 14 || j < -7 || j > 6) {
                    gl.glVertex3f(j, i, -0.1f);
                    gl.glVertex3f(j + 1, i, -0.1f);
                    gl.glVertex3f(j + 1, i + 1, -0.1f);
                    gl.glVertex3f(j, i + 1, -0.1f);
                }
                ++j;
            }
            ++i;
        }
        gl.glEnd();
        float[] rgb = new float[]{0.7f, 0.7f, 0.7f};
        gl.glMaterialfv(1028, 4608, rgb, 0);
        gl.glMaterialfv(1028, 4610, rgb, 0);
        gl.glMaterialf(1028, 5633, 0.0f);
        this.textures.get(1).enable(gl);
        this.textures.get(1).bind(gl);
        gl.glBegin(7);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(-7.0f, -15.0f, -0.1f);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(7.0f, -15.0f, -0.1f);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(7.0f, 15.0f, -0.1f);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(-7.0f, 15.0f, -0.1f);
        gl.glEnd();
        this.textures.get(1).disable(gl);
        if (cameraS == 0) {
            gl.glPushMatrix();
            gl.glColor3f(1.0f, 0.0f, 0.0f);
            gl.glRasterPos3f(14.0f, 20.0f, 10.0f);
            this.glut.glutBitmapString(8, Float.toString(serCar.pointP()));
            gl.glRasterPos3f(14.0f, -18.0f, 10.0f);
            this.glut.glutBitmapString(8, Float.toString(clCar.pointP()));
            gl.glPopMatrix();
        } else if (cameraS == 1) {
            gl.glPushMatrix();
            gl.glColor3f(1.0f, 0.0f, 0.0f);
            gl.glRasterPos3f(clCar.xPos() + (float)Math.cos(Math.toRadians(clCar.getAngle() + 90.0f)) * 9.5f, clCar.yPos() + (float)Math.sin(Math.toRadians(clCar.getAngle() + 90.0f)) * 9.5f, 7.5f);
            this.glut.glutBitmapString(8, Float.toString(serCar.pointP()));
            gl.glRasterPos3f(clCar.xPos() + (float)Math.cos(Math.toRadians(clCar.getAngle() - 90.0f)) * 9.5f, clCar.yPos() + (float)Math.sin(Math.toRadians(clCar.getAngle() - 90.0f)) * 8.5f, 7.5f);
            this.glut.glutBitmapString(8, Float.toString(clCar.pointP()));
            gl.glPopMatrix();
        }
        if (serCar.getPoint() >= 150) {
            gl.glPushMatrix();
            gl.glColor3f(1.0f, 0.0f, 0.0f);
            gl.glRasterPos3f(clCar.xPos(), clCar.yPos(), 5.0f);
            this.glut.glutBitmapString(8, "GAME OVER!!! You WON.");
            gl.glPopMatrix();
        } else if (clCar.getPoint() >= 150) {
            gl.glPushMatrix();
            gl.glColor3f(1.0f, 0.0f, 0.0f);
            gl.glRasterPos3f(clCar.xPos(), clCar.yPos(), 5.0f);
            this.glut.glutBitmapString(8, "GAME OVER!!! Enemy WON.");
            gl.glPopMatrix();
        }
        if (openGL.clCar.fake_drift_right) {
            openGL.clCar.drift_t -= openGL.clCar.drift_increase;
        } else if (openGL.clCar.fake_drift_left) {
            openGL.clCar.drift_t += openGL.clCar.drift_increase;
        }
    }

    @Override
    public void dispose(GLAutoDrawable arg0) {
    }

    @Override
    public void init(GLAutoDrawable drawable) {
        Texture arenaA;
        TextureData dataB;
        InputStream stream1;
        TextureData data;
        GL2 gl = drawable.getGL().getGL2();
        this.glu = new GLU();
        float SHINE_ALL_DIRECTIONS = 1.0f;
        float[] lightPos = new float[]{0.0f, 0.0f, 30.0f, SHINE_ALL_DIRECTIONS};
        float[] lightColorAmbient = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
        float[] lightColorSpecular = new float[]{0.8f, 0.8f, 0.8f, 1.0f};
        float[] lightDiffuse = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
        gl.glShadeModel(7425);
        gl.glLightfv(16385, 4611, lightPos, 0);
        gl.glLightfv(16385, 4608, lightColorAmbient, 0);
        gl.glLightfv(16385, 4610, lightColorSpecular, 0);
        gl.glLightfv(16385, 4609, lightDiffuse, 0);
        gl.glEnable(16385);
        gl.glLightModeli(2897, 1);
        gl.glDisable(16384);
        float[] light1_ambient = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
        float[] light1_diffuse = new float[]{0.8f, 0.8f, 0.8f, 1.0f};
        float[] light1_specular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        gl.glLightfv(16386, 4608, light1_ambient, 0);
        gl.glLightfv(16386, 4609, light1_diffuse, 0);
        gl.glLightfv(16386, 4610, light1_specular, 0);
        gl.glLightModelfv(2899, light1_ambient, 0);
        gl.glLightf(16386, 4615, 0.0f);
        gl.glLightf(16386, 4616, 0.07f);
        gl.glLightf(16386, 4617, 0.008f);
        gl.glLightf(16386, 4613, 50.0f);
        gl.glLightf(16386, 4614, 25.0f);
        gl.glEnable(16386);
        float[] light2_ambient = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
        float[] light2_diffuse = new float[]{0.8f, 0.8f, 0.8f, 1.0f};
        float[] light2_specular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        gl.glLightfv(16387, 4608, light2_ambient, 0);
        gl.glLightfv(16387, 4609, light2_diffuse, 0);
        gl.glLightfv(16387, 4610, light2_specular, 0);
        gl.glLightModelfv(2899, light2_ambient, 0);
        gl.glLightf(16387, 4615, 0.0f);
        gl.glLightf(16387, 4616, 0.07f);
        gl.glLightf(16387, 4617, 0.008f);
        gl.glLightf(16387, 4613, 50.0f);
        gl.glLightf(16387, 4614, 25.0f);
        gl.glEnable(16387);
        float[] light4_ambient = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
        float[] light4_diffuse = new float[]{0.8f, 0.8f, 0.8f, 1.0f};
        float[] light4_specular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        gl.glLightfv(16388, 4608, light4_ambient, 0);
        gl.glLightfv(16388, 4609, light4_diffuse, 0);
        gl.glLightfv(16388, 4610, light4_specular, 0);
        gl.glLightModelfv(2899, light4_ambient, 0);
        gl.glLightf(16388, 4615, 0.0f);
        gl.glLightf(16388, 4616, 0.07f);
        gl.glLightf(16388, 4617, 0.008f);
        gl.glLightf(16388, 4613, 50.0f);
        gl.glLightf(16388, 4614, 25.0f);
        gl.glEnable(16388);
        float[] light5_ambient = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
        float[] light5_diffuse = new float[]{0.8f, 0.8f, 0.8f, 1.0f};
        float[] light5_specular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        gl.glLightfv(16389, 4608, light5_ambient, 0);
        gl.glLightfv(16389, 4609, light5_diffuse, 0);
        gl.glLightfv(16389, 4610, light5_specular, 0);
        gl.glLightModelfv(2899, light5_ambient, 0);
        gl.glLightf(16389, 4615, 0.0f);
        gl.glLightf(16389, 4616, 0.07f);
        gl.glLightf(16389, 4617, 0.008f);
        gl.glLightf(16389, 4613, 50.0f);
        gl.glLightf(16389, 4614, 25.0f);
        gl.glEnable(16389);
        gl.glEnable(2896);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glClearDepthf(1.0f);
        gl.glEnable(2929);
        gl.glEnable(2977);
        gl.glDepthFunc(513);
        gl.glHint(3152, 4354);
        gl.glShadeModel(7425);
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream("hangar2.png");
            data = TextureIO.newTextureData(gl.getGLProfile(), stream, false, "png");
            Texture WallR = TextureIO.newTexture(data);
            this.textures.add(WallR);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            stream1 = this.getClass().getClassLoader().getResourceAsStream("sabanciLogo.png");
            data = TextureIO.newTextureData(gl.getGLProfile(), stream1, false, "png");
            Texture arena = TextureIO.newTexture(data);
            this.textures.add(arena);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            stream1 = this.getClass().getClassLoader().getResourceAsStream("splatter.png");
            dataB = TextureIO.newTextureData(gl.getGLProfile(), stream1, false, "png");
            arenaA = TextureIO.newTexture(dataB);
            this.textures.add(arenaA);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            stream1 = this.getClass().getClassLoader().getResourceAsStream("2_store.png");
            dataB = TextureIO.newTextureData(gl.getGLProfile(), stream1, false, "png");
            arenaA = TextureIO.newTexture(dataB);
            this.textures.add(arenaA);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            stream1 = this.getClass().getClassLoader().getResourceAsStream("tire.png");
            dataB = TextureIO.newTextureData(gl.getGLProfile(), stream1, false, "png");
            arenaA = TextureIO.newTexture(dataB);
            this.textures.add(arenaA);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        clCar.setSteerGLU(this.glu);
        serCar.setSteerGLU(this.glu);
    }
}

