/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.awt;

import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.nativewindow.awt.AWTPrintLifecycle;
import com.jogamp.nativewindow.awt.AWTWindowClosingProtocol;
import com.jogamp.nativewindow.awt.JAWTWindow;
import com.jogamp.newt.Display;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTAdapter;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import com.jogamp.opengl.util.GLDrawableUtil;
import com.jogamp.opengl.util.TileRenderer;
import java.awt.AWTKeyStroke;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.KeyboardFocusManager;
import java.awt.geom.NoninvertibleTransformException;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.OffscreenLayerOption;
import javax.media.nativewindow.WindowClosingProtocol;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.swing.MenuSelectionManager;
import jogamp.nativewindow.awt.AWTMisc;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.newt.Debug;
import jogamp.newt.WindowImpl;
import jogamp.newt.awt.NewtFactoryAWT;
import jogamp.newt.awt.event.AWTParentWindowAdapter;
import jogamp.newt.driver.DriverClearFocus;
import jogamp.opengl.awt.AWTTilePainter;

public class NewtCanvasAWT
extends Canvas
implements WindowClosingProtocol,
OffscreenLayerOption,
AWTPrintLifecycle {
    public static final boolean DEBUG = Debug.debug("Window");
    private JAWTWindow jawtWindow = null;
    private boolean shallUseOffscreenLayer = false;
    private Window newtChild = null;
    private boolean newtChildAttached = false;
    private boolean isOnscreen = true;
    private WindowClosingProtocol.WindowClosingMode newtChildCloseOp;
    private AWTParentWindowAdapter awtAdapter = null;
    private AWTAdapter awtMouseAdapter = null;
    private AWTAdapter awtKeyAdapter = null;
    private final AWTWindowClosingProtocol awtWindowClosingProtocol = new AWTWindowClosingProtocol(this, new Runnable(){

        @Override
        public void run() {
            NewtCanvasAWT.this.destroyImpl(false, true);
        }
    }, new Runnable(){

        @Override
        public void run() {
            if (NewtCanvasAWT.this.newtChild != null) {
                NewtCanvasAWT.this.newtChild.sendWindowEvent(102);
            }
        }
    });
    private final FocusAction focusAction = new FocusAction();
    WindowListener clearAWTMenusOnNewtFocus = new WindowAdapter(){

        @Override
        public void windowResized(WindowEvent windowEvent) {
            NewtCanvasAWT.this.updateLayoutSize();
        }

        @Override
        public void windowGainedFocus(WindowEvent windowEvent) {
            if (NewtCanvasAWT.this.isParent() && !NewtCanvasAWT.this.isFullscreen()) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    };
    private final FocusTraversalKeyListener newtFocusTraversalKeyListener = new FocusTraversalKeyListener();
    private final FocusPropertyChangeListener focusPropertyChangeListener = new FocusPropertyChangeListener();
    private volatile KeyboardFocusManager keyboardFocusManager = null;
    private volatile boolean printActive = false;
    private GLAnimatorControl printAnimator = null;
    private GLAutoDrawable printGLAD = null;
    private AWTTilePainter printAWTTiles = null;
    private final Runnable setupPrintOnEDT = new Runnable(){

        @Override
        public void run() {
            boolean bl;
            if (!NewtCanvasAWT.this.validateComponent(true)) {
                if (DEBUG) {
                    System.err.println(NewtCanvasAWT.getThreadName() + ": Info: NewtCanvasAWT setupPrint - skipped GL render, drawable not valid yet");
                }
                NewtCanvasAWT.this.printActive = false;
                return;
            }
            if (!NewtCanvasAWT.this.isVisible()) {
                if (DEBUG) {
                    System.err.println(NewtCanvasAWT.getThreadName() + ": Info: NewtCanvasAWT setupPrint - skipped GL render, drawable visible");
                }
                NewtCanvasAWT.this.printActive = false;
                return;
            }
            GLAutoDrawable gLAutoDrawable = NewtCanvasAWT.this.getGLAD();
            if (null == gLAutoDrawable) {
                if (DEBUG) {
                    System.err.println("AWT print.setup exit, newtChild not a GLAutoDrawable: " + NewtCanvasAWT.this.newtChild);
                }
                NewtCanvasAWT.this.printActive = false;
                return;
            }
            NewtCanvasAWT.this.printAnimator = gLAutoDrawable.getAnimator();
            if (null != NewtCanvasAWT.this.printAnimator) {
                NewtCanvasAWT.this.printAnimator.remove(gLAutoDrawable);
            }
            NewtCanvasAWT.this.printGLAD = gLAutoDrawable;
            GLCapabilities gLCapabilities = (GLCapabilities)gLAutoDrawable.getChosenGLCapabilities().cloneMutable();
            int n = NewtCanvasAWT.this.printAWTTiles.getNumSamples(gLCapabilities);
            GLDrawable gLDrawable = NewtCanvasAWT.this.printGLAD.getDelegatedDrawable();
            boolean bl2 = n != gLCapabilities.getNumSamples();
            boolean bl3 = ((NewtCanvasAWT)NewtCanvasAWT.this).printAWTTiles.customTileWidth != -1 && ((NewtCanvasAWT)NewtCanvasAWT.this).printAWTTiles.customTileWidth != gLDrawable.getWidth() || ((NewtCanvasAWT)NewtCanvasAWT.this).printAWTTiles.customTileHeight != -1 && ((NewtCanvasAWT)NewtCanvasAWT.this).printAWTTiles.customTileHeight != gLDrawable.getHeight();
            boolean bl4 = gLCapabilities.isOnscreen();
            boolean bl5 = bl = !gLCapabilities.getSampleBuffers() && (bl4 || bl2 || bl3);
            if (DEBUG) {
                System.err.println("AWT print.setup: reqNewGLAD " + bl + "[ onscreen " + bl4 + ", samples " + bl2 + ", size " + bl3 + "], " + ", drawableSize " + gLDrawable.getWidth() + "x" + gLDrawable.getHeight() + ", customTileSize " + ((NewtCanvasAWT)NewtCanvasAWT.this).printAWTTiles.customTileWidth + "x" + ((NewtCanvasAWT)NewtCanvasAWT.this).printAWTTiles.customTileHeight + ", scaleMat " + ((NewtCanvasAWT)NewtCanvasAWT.this).printAWTTiles.scaleMatX + " x " + ((NewtCanvasAWT)NewtCanvasAWT.this).printAWTTiles.scaleMatY + ", numSamples " + ((NewtCanvasAWT)NewtCanvasAWT.this).printAWTTiles.customNumSamples + " -> " + n + ", printAnimator " + NewtCanvasAWT.this.printAnimator);
            }
            if (bl) {
                gLCapabilities.setDoubleBuffered(false);
                gLCapabilities.setOnscreen(false);
                if (n != gLCapabilities.getNumSamples()) {
                    gLCapabilities.setSampleBuffers(0 < n);
                    gLCapabilities.setNumSamples(n);
                }
                GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilities.getGLProfile());
                NewtCanvasAWT.this.printGLAD = gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilities, null, ((NewtCanvasAWT)NewtCanvasAWT.this).printAWTTiles.customTileWidth != -1 ? ((NewtCanvasAWT)NewtCanvasAWT.this).printAWTTiles.customTileWidth : 1024, ((NewtCanvasAWT)NewtCanvasAWT.this).printAWTTiles.customTileHeight != -1 ? ((NewtCanvasAWT)NewtCanvasAWT.this).printAWTTiles.customTileHeight : 1024);
                GLDrawableUtil.swapGLContextAndAllGLEventListener(gLAutoDrawable, NewtCanvasAWT.this.printGLAD);
                gLDrawable = NewtCanvasAWT.this.printGLAD.getDelegatedDrawable();
            }
            NewtCanvasAWT.this.printAWTTiles.setIsGLOriented(NewtCanvasAWT.this.printGLAD.isGLOriented());
            ((NewtCanvasAWT)NewtCanvasAWT.this).printAWTTiles.renderer.setTileSize(gLDrawable.getWidth(), gLDrawable.getHeight(), 0);
            ((NewtCanvasAWT)NewtCanvasAWT.this).printAWTTiles.renderer.attachAutoDrawable(NewtCanvasAWT.this.printGLAD);
            if (DEBUG) {
                System.err.println("AWT print.setup " + NewtCanvasAWT.this.printAWTTiles);
                System.err.println("AWT print.setup AA " + n + ", " + gLCapabilities);
                System.err.println("AWT print.setup printGLAD: " + NewtCanvasAWT.this.printGLAD.getWidth() + "x" + NewtCanvasAWT.this.printGLAD.getHeight() + ", " + NewtCanvasAWT.this.printGLAD);
                System.err.println("AWT print.setup printDraw: " + gLDrawable.getWidth() + "x" + gLDrawable.getHeight() + ", " + gLDrawable);
            }
        }
    };
    private final Runnable releasePrintOnEDT = new Runnable(){

        @Override
        public void run() {
            if (DEBUG) {
                System.err.println("AWT print.release " + NewtCanvasAWT.this.printAWTTiles);
            }
            GLAutoDrawable gLAutoDrawable = NewtCanvasAWT.this.getGLAD();
            NewtCanvasAWT.this.printAWTTiles.dispose();
            NewtCanvasAWT.this.printAWTTiles = null;
            if (NewtCanvasAWT.this.printGLAD != gLAutoDrawable) {
                GLDrawableUtil.swapGLContextAndAllGLEventListener(NewtCanvasAWT.this.printGLAD, gLAutoDrawable);
                NewtCanvasAWT.this.printGLAD.destroy();
            }
            NewtCanvasAWT.this.printGLAD = null;
            if (null != NewtCanvasAWT.this.printAnimator) {
                NewtCanvasAWT.this.printAnimator.add(gLAutoDrawable);
                NewtCanvasAWT.this.printAnimator = null;
            }
            NewtCanvasAWT.this.printActive = false;
        }
    };
    private final Runnable forceRelayout = new Runnable(){

        @Override
        public void run() {
            if (DEBUG) {
                System.err.println("NewtCanvasAWT.forceRelayout.0");
            }
            NewtCanvasAWT newtCanvasAWT = NewtCanvasAWT.this;
            int n = newtCanvasAWT.getWidth();
            int n2 = newtCanvasAWT.getHeight();
            newtCanvasAWT.setSize(n + 1, n2 + 1);
            newtCanvasAWT.setSize(n, n2);
            if (DEBUG) {
                System.err.println("NewtCanvasAWT.forceRelayout.X");
            }
        }
    };
    private static boolean disableBackgroundEraseInitialized;
    private static Method disableBackgroundEraseMethod;

    public NewtCanvasAWT() {
    }

    public NewtCanvasAWT(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
    }

    public NewtCanvasAWT(Window window) {
        this.setNEWTChild(window);
    }

    public NewtCanvasAWT(GraphicsConfiguration graphicsConfiguration, Window window) {
        super(graphicsConfiguration);
        this.setNEWTChild(window);
    }

    @Override
    public void setShallUseOffscreenLayer(boolean bl) {
        this.shallUseOffscreenLayer = bl;
    }

    @Override
    public final boolean getShallUseOffscreenLayer() {
        return this.shallUseOffscreenLayer;
    }

    @Override
    public final boolean isOffscreenLayerSurfaceEnabled() {
        return this.jawtWindow.isOffscreenLayerSurfaceEnabled();
    }

    public boolean isApplet() {
        return this.jawtWindow.isApplet();
    }

    boolean isParent() {
        return null != this.newtChild && this.jawtWindow == this.newtChild.getParent();
    }

    boolean isFullscreen() {
        return null != this.newtChild && this.newtChild.isFullscreen();
    }

    private final void requestFocusNEWTChild() {
        if (null != this.newtChild) {
            this.newtChild.setFocusAction(null);
            if (this.isOnscreen) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
            }
            this.newtChild.requestFocus();
            this.newtChild.setFocusAction(this.focusAction);
        }
    }

    public Window setNEWTChild(Window window) {
        Window window2 = this.newtChild;
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.setNEWTChild.0: win " + NewtCanvasAWT.newtWinHandleToHexString(window2) + " -> " + NewtCanvasAWT.newtWinHandleToHexString(window));
        }
        Container container = AWTMisc.getContainer(this);
        if (null != this.newtChild) {
            this.detachNewtChild(container);
            this.newtChild = null;
        }
        this.newtChild = window;
        this.updateLayoutSize();
        return window2;
    }

    private final void updateLayoutSize() {
        if (null != this.newtChild) {
            Dimension dimension = new Dimension(this.newtChild.getWidth(), this.newtChild.getHeight());
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
        }
    }

    public Window getNEWTChild() {
        return this.newtChild;
    }

    public NativeWindow getNativeWindow() {
        return this.jawtWindow;
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        return this.awtWindowClosingProtocol.getDefaultCloseOperation();
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        return this.awtWindowClosingProtocol.setDefaultCloseOperation(windowClosingMode);
    }

    @Override
    public void addNotify() {
        if (Beans.isDesignTime()) {
            super.addNotify();
        } else {
            this.disableBackgroundErase();
            super.addNotify();
            this.disableBackgroundErase();
            this.jawtWindow = NewtFactoryAWT.getNativeWindow(this, null != this.newtChild ? this.newtChild.getRequestedCapabilities() : null);
            this.jawtWindow.setShallUseOffscreenLayer(this.shallUseOffscreenLayer);
            if (DEBUG) {
                System.err.println("NewtCanvasAWT.addNotify: win " + NewtCanvasAWT.newtWinHandleToHexString(this.newtChild) + ", comp " + this + ", visible " + this.isVisible() + ", showing " + this.isShowing() + ", displayable " + this.isDisplayable() + ", cont " + AWTMisc.getContainer(this));
            }
        }
        this.awtWindowClosingProtocol.addClosingListener();
    }

    @Override
    public void removeNotify() {
        this.awtWindowClosingProtocol.removeClosingListener();
        if (Beans.isDesignTime()) {
            super.removeNotify();
        } else {
            this.destroyImpl(true, false);
            super.removeNotify();
        }
    }

    public final void destroy() {
        this.destroyImpl(false, false);
    }

    private final void destroyImpl(boolean bl, boolean bl2) {
        if (null != this.newtChild) {
            Container container = AWTMisc.getContainer(this);
            if (DEBUG) {
                System.err.println("NewtCanvasAWT.destroy(removeNotify " + bl + ", windowClosing " + bl2 + "): nw " + NewtCanvasAWT.newtWinHandleToHexString(this.newtChild) + ", from " + container);
            }
            this.detachNewtChild(container);
            if (!bl) {
                Window window = this.newtChild;
                Window window2 = window.getDelegatedWindow();
                this.newtChild = null;
                if (bl2 && window2 instanceof WindowImpl) {
                    ((WindowImpl)window2).windowDestroyNotify(true);
                } else {
                    window.destroy();
                }
            }
        }
        if ((bl || bl2) && null != this.jawtWindow) {
            NewtFactoryAWT.destroyNativeWindow(this.jawtWindow);
            this.jawtWindow = null;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.validateComponent(true) && !this.printActive) {
            this.newtChild.windowRepaint(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.reshape(n, n2, n3, n4);
            if (DEBUG) {
                System.err.println("NewtCanvasAWT.reshape: " + n + "/" + n2 + " " + n3 + "x" + n4);
            }
            if (this.validateComponent(true)) {
                // empty if block
            }
        }
    }

    private final GLAutoDrawable getGLAD() {
        if (null != this.newtChild && this.newtChild instanceof GLAutoDrawable) {
            return (GLAutoDrawable)((Object)this.newtChild);
        }
        return null;
    }

    @Override
    public void setupPrint(double d, double d2, int n, int n2, int n3) {
        this.printActive = true;
        int n4 = this.isOpaque() ? 3 : 4;
        TileRenderer tileRenderer = new TileRenderer();
        this.printAWTTiles = new AWTTilePainter(tileRenderer, n4, d, d2, n, n2, n3, DEBUG);
        AWTEDTExecutor.singleton.invoke(this.getTreeLock(), true, true, this.setupPrintOnEDT);
    }

    @Override
    public void releasePrint() {
        if (!this.printActive || null == this.printGLAD) {
            throw new IllegalStateException("setupPrint() not called");
        }
        AWTEDTExecutor.singleton.invoke(this.getTreeLock(), true, true, this.releasePrintOnEDT);
        this.newtChild.sendWindowEvent(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Graphics graphics) {
        block11: {
            if (!this.printActive || null == this.printGLAD) {
                throw new IllegalStateException("setupPrint() not called");
            }
            if (DEBUG && !EventQueue.isDispatchThread()) {
                System.err.println(NewtCanvasAWT.getThreadName() + ": Warning: GLCanvas print - not called from AWT-EDT");
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            try {
                this.printAWTTiles.setupGraphics2DAndClipBounds(graphics2D, this.getWidth(), this.getHeight());
                TileRenderer tileRenderer = this.printAWTTiles.renderer;
                if (DEBUG) {
                    System.err.println("AWT print.0: " + tileRenderer);
                }
                if (tileRenderer.eot()) break block11;
                try {
                    do {
                        tileRenderer.display();
                    } while (!tileRenderer.eot());
                    if (DEBUG) {
                        System.err.println("AWT print.1: " + this.printAWTTiles);
                    }
                    tileRenderer.reset();
                }
                finally {
                    this.printAWTTiles.resetGraphics2D();
                }
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                System.err.println("Catched: Inversion failed of: " + graphics2D.getTransform());
                noninvertibleTransformException.printStackTrace();
            }
        }
        if (DEBUG) {
            System.err.println("AWT print.X: " + this.printAWTTiles);
        }
    }

    private final boolean validateComponent(boolean bl) {
        if (Beans.isDesignTime() || !this.isDisplayable()) {
            return false;
        }
        if (null == this.newtChild || null == this.jawtWindow) {
            return false;
        }
        if (0 >= this.getWidth() || 0 >= this.getHeight()) {
            return false;
        }
        if (bl && !this.newtChildAttached && null != this.newtChild) {
            this.attachNewtChild();
        }
        return true;
    }

    private final void configureNewtChild(boolean bl) {
        if (null != this.awtAdapter) {
            this.awtAdapter.removeFrom(this);
            this.awtAdapter = null;
        }
        if (null != this.awtMouseAdapter) {
            this.awtMouseAdapter.removeFrom(this);
            this.awtMouseAdapter = null;
        }
        if (null != this.awtKeyAdapter) {
            this.awtKeyAdapter.removeFrom(this);
            this.awtKeyAdapter = null;
        }
        if (null != this.keyboardFocusManager) {
            this.keyboardFocusManager.removePropertyChangeListener("focusOwner", this.focusPropertyChangeListener);
            this.keyboardFocusManager = null;
        }
        if (null != this.newtChild) {
            this.newtChild.setKeyboardFocusHandler(null);
            if (bl) {
                if (null == this.jawtWindow.getGraphicsConfiguration()) {
                    throw new InternalError("XXX");
                }
                this.isOnscreen = this.jawtWindow.getGraphicsConfiguration().getChosenCapabilities().isOnscreen();
                this.awtAdapter = (AWTParentWindowAdapter)new AWTParentWindowAdapter(this.jawtWindow, this.newtChild).addTo(this);
                this.awtAdapter.removeWindowClosingFrom(this);
                this.newtChild.addWindowListener(this.clearAWTMenusOnNewtFocus);
                this.newtChild.setFocusAction(this.focusAction);
                this.newtChildCloseOp = this.newtChild.setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode.DO_NOTHING_ON_CLOSE);
                this.keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                this.keyboardFocusManager.addPropertyChangeListener("focusOwner", this.focusPropertyChangeListener);
                this.setFocusable(true);
                if (this.isOnscreen) {
                    this.newtChild.setKeyboardFocusHandler(this.newtFocusTraversalKeyListener);
                } else {
                    this.awtMouseAdapter = new AWTMouseAdapter(this.newtChild).addTo(this);
                    this.awtKeyAdapter = new AWTKeyAdapter(this.newtChild).addTo(this);
                }
            } else {
                this.newtChild.removeWindowListener(this.clearAWTMenusOnNewtFocus);
                this.newtChild.setFocusAction(null);
                this.newtChild.setDefaultCloseOperation(this.newtChildCloseOp);
                this.setFocusable(false);
            }
        }
    }

    private final void attachNewtChild() {
        if (null == this.newtChild || null == this.jawtWindow || this.newtChildAttached) {
            return;
        }
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.attachNewtChild.0 @ " + Thread.currentThread().getName() + ": win " + NewtCanvasAWT.newtWinHandleToHexString(this.newtChild) + ", EDTUtil: cur " + this.newtChild.getScreen().getDisplay().getEDTUtil() + ", comp " + this + ", visible " + this.isVisible() + ", showing " + this.isShowing() + ", displayable " + this.isDisplayable() + ", cont " + AWTMisc.getContainer(this));
        }
        this.newtChildAttached = true;
        this.newtChild.setFocusAction(null);
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.attachNewtChild.1: newtChild: " + this.newtChild);
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.attachNewtChild.2: size " + n + "x" + n2);
        }
        this.newtChild.setVisible(false);
        this.newtChild.setSize(n, n2);
        this.newtChild.reparentWindow(this.jawtWindow);
        this.newtChild.addSurfaceUpdatedListener(this.jawtWindow);
        if (this.jawtWindow.isOffscreenLayerSurfaceEnabled() && 0 != (2 & JAWTUtil.getOSXCALayerQuirks())) {
            AWTEDTExecutor.singleton.invoke(false, this.forceRelayout);
        }
        this.newtChild.setVisible(true);
        this.configureNewtChild(true);
        this.newtChild.sendWindowEvent(100);
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.attachNewtChild.X: win " + NewtCanvasAWT.newtWinHandleToHexString(this.newtChild) + ", EDTUtil: cur " + this.newtChild.getScreen().getDisplay().getEDTUtil() + ", comp " + this);
        }
    }

    private final void detachNewtChild(Container container) {
        if (null == this.newtChild || null == this.jawtWindow || !this.newtChildAttached) {
            return;
        }
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.detachNewtChild.0: win " + NewtCanvasAWT.newtWinHandleToHexString(this.newtChild) + ", EDTUtil: cur " + this.newtChild.getScreen().getDisplay().getEDTUtil() + ", comp " + this + ", visible " + this.isVisible() + ", showing " + this.isShowing() + ", displayable " + this.isDisplayable() + ", cont " + container);
        }
        this.newtChild.removeSurfaceUpdatedListener(this.jawtWindow);
        this.newtChildAttached = false;
        this.newtChild.setFocusAction(null);
        this.configureNewtChild(false);
        this.newtChild.setVisible(false);
        this.newtChild.reparentWindow(null);
        if (DEBUG) {
            System.err.println("NewtCanvasAWT.detachNewtChild.X: win " + NewtCanvasAWT.newtWinHandleToHexString(this.newtChild) + ", EDTUtil: cur " + this.newtChild.getScreen().getDisplay().getEDTUtil() + ", comp " + this);
        }
    }

    private void disableBackgroundErase() {
        if (!disableBackgroundEraseInitialized) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Class<?> clazz = NewtCanvasAWT.this.getToolkit().getClass();
                            while (clazz != null && disableBackgroundEraseMethod == null) {
                                try {
                                    disableBackgroundEraseMethod = clazz.getDeclaredMethod("disableBackgroundErase", Canvas.class);
                                    disableBackgroundEraseMethod.setAccessible(true);
                                }
                                catch (Exception exception) {
                                    clazz = clazz.getSuperclass();
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            disableBackgroundEraseInitialized = true;
            if (DEBUG) {
                System.err.println("NewtCanvasAWT: TK disableBackgroundErase method found: " + (null != disableBackgroundEraseMethod));
            }
        }
        if (disableBackgroundEraseMethod != null) {
            Exception exception = null;
            try {
                disableBackgroundEraseMethod.invoke((Object)this.getToolkit(), this);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (DEBUG) {
                System.err.println("NewtCanvasAWT: TK disableBackgroundErase error: " + exception);
            }
        }
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    static String newtWinHandleToHexString(Window window) {
        return null != window ? NewtCanvasAWT.toHexString(window.getWindowHandle()) : "nil";
    }

    static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    class FocusPropertyChangeListener
    implements PropertyChangeListener {
        FocusPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            boolean bl = NewtCanvasAWT.this.isParent();
            boolean bl2 = NewtCanvasAWT.this.isFullscreen();
            if (DEBUG) {
                System.err.println("NewtCanvasAWT.FocusProperty: " + propertyChangeEvent.getPropertyName() + ", src " + propertyChangeEvent.getSource() + ", " + object + " -> " + object2 + ", isParent " + bl + ", isFS " + bl2);
            }
            if (bl && !bl2) {
                if (object2 == NewtCanvasAWT.this) {
                    if (DEBUG) {
                        System.err.println("NewtCanvasAWT.FocusProperty: AWT focus -> NEWT focus traversal");
                    }
                    NewtCanvasAWT.this.requestFocusNEWTChild();
                } else if (object == NewtCanvasAWT.this && object2 == null) {
                    if (DEBUG) {
                        System.err.println("NewtCanvasAWT.FocusProperty: NEWT focus");
                    }
                } else if (null != object2 && object2 != NewtCanvasAWT.this) {
                    if (DEBUG) {
                        System.err.println("NewtCanvasAWT.FocusProperty: lost focus - clear focus");
                    }
                    if (NewtCanvasAWT.this.newtChild.getDelegatedWindow() instanceof DriverClearFocus) {
                        ((DriverClearFocus)((Object)NewtCanvasAWT.this.newtChild.getDelegatedWindow())).clearFocus();
                    }
                }
            }
        }
    }

    class FocusTraversalKeyListener
    implements KeyListener {
        FocusTraversalKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (NewtCanvasAWT.this.isParent() && !NewtCanvasAWT.this.isFullscreen()) {
                this.handleKey(keyEvent, false);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (NewtCanvasAWT.this.isParent() && !NewtCanvasAWT.this.isFullscreen()) {
                this.handleKey(keyEvent, true);
            }
        }

        void handleKey(KeyEvent keyEvent, boolean bl) {
            if (null == NewtCanvasAWT.this.keyboardFocusManager) {
                throw new InternalError("XXX");
            }
            AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), bl);
            boolean bl2 = false;
            if (null != aWTKeyStroke) {
                Set<AWTKeyStroke> set = NewtCanvasAWT.this.keyboardFocusManager.getDefaultFocusTraversalKeys(0);
                Set<AWTKeyStroke> set2 = NewtCanvasAWT.this.keyboardFocusManager.getDefaultFocusTraversalKeys(1);
                if (set.contains(aWTKeyStroke)) {
                    Component component = AWTMisc.getNextFocus(NewtCanvasAWT.this, true);
                    if (DEBUG) {
                        System.err.println("NewtCanvasAWT.focusKey (fwd): " + aWTKeyStroke + ", current focusOwner " + NewtCanvasAWT.this.keyboardFocusManager.getFocusOwner() + ", hasFocus: " + NewtCanvasAWT.this.hasFocus() + ", nextFocus " + component);
                    }
                    component.requestFocus();
                    bl2 = true;
                } else if (set2.contains(aWTKeyStroke)) {
                    Component component = AWTMisc.getNextFocus(NewtCanvasAWT.this, false);
                    if (DEBUG) {
                        System.err.println("NewtCanvasAWT.focusKey (bwd): " + aWTKeyStroke + ", current focusOwner " + NewtCanvasAWT.this.keyboardFocusManager.getFocusOwner() + ", hasFocus: " + NewtCanvasAWT.this.hasFocus() + ", prevFocus " + component);
                    }
                    component.requestFocus();
                    bl2 = true;
                }
            }
            if (bl2) {
                keyEvent.setConsumed(true);
            }
            if (DEBUG) {
                System.err.println("NewtCanvasAWT.focusKey: XXX: " + aWTKeyStroke);
            }
        }
    }

    class FocusAction
    implements Window.FocusRunnable {
        FocusAction() {
        }

        @Override
        public boolean run() {
            boolean bl = NewtCanvasAWT.this.isParent();
            boolean bl2 = NewtCanvasAWT.this.isFullscreen();
            if (DEBUG) {
                System.err.println("NewtCanvasAWT.FocusAction: " + Display.getThreadName() + ", isOnscreen " + NewtCanvasAWT.this.isOnscreen + ", hasFocus " + NewtCanvasAWT.this.hasFocus() + ", isParent " + bl + ", isFS " + bl2);
            }
            if (bl && !bl2) {
                if (!NewtCanvasAWT.this.hasFocus()) {
                    NewtCanvasAWT.super.requestFocus();
                }
                if (NewtCanvasAWT.this.isOnscreen) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                }
            }
            return false;
        }
    }
}

