/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.awt.applet;

import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.util.Animator;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.WindowClosingProtocol;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLPipelineFactory;
import jogamp.newt.Debug;

public class JOGLNewtAppletBase
implements KeyListener,
GLEventListener {
    public static final boolean DEBUG = Debug.debug("Applet");
    String glEventListenerClazzName;
    int glSwapInterval;
    boolean noDefaultKeyListener;
    boolean glClosable;
    boolean glDebug;
    boolean glTrace;
    GLEventListener glEventListener = null;
    GLWindow glWindow = null;
    Animator glAnimator = null;
    boolean isValid = false;
    NativeWindow awtParent;

    public JOGLNewtAppletBase(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.glEventListenerClazzName = string;
        this.glSwapInterval = n;
        this.noDefaultKeyListener = bl;
        this.glClosable = bl2;
        this.glDebug = bl3;
        this.glTrace = bl4;
    }

    public GLEventListener getGLEventListener() {
        return this.glEventListener;
    }

    public GLWindow getGLWindow() {
        return this.glWindow;
    }

    public Animator getGLAnimator() {
        return this.glAnimator;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public static boolean str2Bool(String string, boolean bl) {
        if (null == string) {
            return bl;
        }
        try {
            return Boolean.valueOf(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return bl;
        }
    }

    public static int str2Int(String string, int n) {
        if (null == string) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return n;
        }
    }

    public static GLEventListener createInstance(final String string) {
        Object var1_1 = null;
        try {
            Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(string, false, classLoader);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    return clazz;
                }
            });
            var1_1 = clazz.newInstance();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException("Error while instantiating demo: " + string);
        }
        if (null == var1_1) {
            throw new RuntimeException("Null GLEventListener: " + string);
        }
        if (!(var1_1 instanceof GLEventListener)) {
            throw new RuntimeException("Not a GLEventListener: " + string);
        }
        return var1_1;
    }

    public static boolean setField(Object object, String string, Object object2) {
        try {
            Field field = object.getClass().getField(string);
            if (field.getType().isInstance(object2)) {
                field.set(object, object2);
                return true;
            }
            System.out.println(object.getClass() + " '" + string + "' field not assignable with " + object2.getClass() + ", it's a: " + field.getType());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            System.out.println(object.getClass() + " has no '" + string + "' field");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public void init(GLWindow gLWindow) {
        this.init(Thread.currentThread().getThreadGroup(), gLWindow);
    }

    public void init(ThreadGroup threadGroup, final GLWindow gLWindow) {
        this.isValid = false;
        this.glWindow = gLWindow;
        this.glWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDestroyNotify(WindowEvent windowEvent) {
                if (JOGLNewtAppletBase.this.isValid() && WindowClosingProtocol.WindowClosingMode.DO_NOTHING_ON_CLOSE == gLWindow.getDefaultCloseOperation() && null == gLWindow.getParent()) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (gLWindow.isNativeValid()) {
                                gLWindow.reparentWindow(JOGLNewtAppletBase.this.awtParent);
                            }
                        }
                    }).start();
                }
            }
        });
        this.glEventListener = JOGLNewtAppletBase.createInstance(this.glEventListenerClazzName);
        if (null == this.glEventListener) {
            return;
        }
        try {
            if (!JOGLNewtAppletBase.setField(this.glEventListener, "window", gLWindow)) {
                JOGLNewtAppletBase.setField(this.glEventListener, "glWindow", gLWindow);
            }
            gLWindow.addGLEventListener(this);
            gLWindow.addGLEventListener(this.glEventListener);
            if (this.glEventListener instanceof WindowListener) {
                gLWindow.addWindowListener((WindowListener)((Object)this.glEventListener));
            }
            if (this.glEventListener instanceof MouseListener) {
                gLWindow.addMouseListener((MouseListener)((Object)this.glEventListener));
            }
            if (this.glEventListener instanceof KeyListener) {
                gLWindow.addKeyListener((KeyListener)((Object)this.glEventListener));
            }
            if (!this.noDefaultKeyListener) {
                gLWindow.addKeyListener(this);
            }
            gLWindow.setUpdateFPSFrames(300, System.err);
            this.glAnimator = new Animator();
            this.glAnimator.setModeBits(false, 1);
            this.glAnimator.setThreadGroup(threadGroup);
            this.glAnimator.add(gLWindow);
            this.glAnimator.setUpdateFPSFrames(300, null);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        this.isValid = true;
    }

    public void start() {
        if (this.isValid) {
            this.glWindow.setVisible(true);
            this.glWindow.sendWindowEvent(100);
            this.glAnimator.start();
            this.awtParent = this.glWindow.getParent();
        }
    }

    public void stop() {
        if (null != this.glAnimator) {
            this.glAnimator.stop();
            this.glWindow.setVisible(false);
        }
    }

    public void destroy() {
        this.isValid = false;
        if (null != this.glAnimator) {
            this.glAnimator.stop();
            this.glAnimator.remove(this.glWindow);
            this.glAnimator = null;
        }
        if (null != this.glWindow) {
            this.glWindow.destroy();
            this.glWindow = null;
        }
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        if (this.glDebug) {
            try {
                gL = gL.getContext().setGL(GLPipelineFactory.create("javax.media.opengl.Debug", null, gL, null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.glTrace) {
            try {
                gL = gL.getContext().setGL(GLPipelineFactory.create("javax.media.opengl.Trace", null, gL, new Object[]{System.err}));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.glSwapInterval >= 0) {
            gL.setSwapInterval(this.glSwapInterval);
        }
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
            return;
        }
        if (keyEvent.getKeyChar() == 'd') {
            this.glWindow.setUndecorated(!this.glWindow.isUndecorated());
        }
        if (keyEvent.getKeyChar() == 'f') {
            this.glWindow.setFullscreen(!this.glWindow.isFullscreen());
        } else if (keyEvent.getKeyChar() == 'a') {
            this.glWindow.setAlwaysOnTop(!this.glWindow.isAlwaysOnTop());
        } else if (keyEvent.getKeyChar() == 'r' && null != this.awtParent) {
            if (null == this.glWindow.getParent()) {
                this.glWindow.reparentWindow(this.awtParent);
            } else {
                int n;
                int n2;
                InsetsImmutable insetsImmutable = this.glWindow.getInsets();
                if (0 >= insetsImmutable.getTopHeight()) {
                    n2 = 32;
                    n = 32;
                } else {
                    n2 = insetsImmutable.getLeftWidth();
                    n = insetsImmutable.getTopHeight();
                }
                this.glWindow.reparentWindow(null, n2, n, false);
                this.glWindow.setDefaultCloseOperation(this.glClosable ? WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE : WindowClosingProtocol.WindowClosingMode.DO_NOTHING_ON_CLOSE);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

