/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLProperty;
import com.jogamp.opencl.CLVersion;
import com.jogamp.opencl.impl.CLTLAccessorFactory;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.CLBufferBinding;
import com.jogamp.opencl.llb.CLCommandQueueBinding;
import com.jogamp.opencl.llb.CLContextBinding;
import com.jogamp.opencl.llb.CLDeviceBinding;
import com.jogamp.opencl.llb.CLEventBinding;
import com.jogamp.opencl.llb.CLImageBinding;
import com.jogamp.opencl.llb.CLKernelBinding;
import com.jogamp.opencl.llb.CLMemObjBinding;
import com.jogamp.opencl.llb.CLPlatformBinding;
import com.jogamp.opencl.llb.CLProgramBinding;
import com.jogamp.opencl.llb.CLSamplerBinding;
import com.jogamp.opencl.llb.impl.CLImpl;
import com.jogamp.opencl.spi.CLAccessorFactory;
import com.jogamp.opencl.spi.CLPlatformInfoAccessor;
import com.jogamp.opencl.util.CLUtil;
import com.jogamp.opencl.util.Filter;
import com.jogamp.opencl.util.JOCLVersion;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class CLPlatform {
    public final long ID;
    public final CLVersion version;
    protected static CL cl;
    private static CLAccessorFactory defaultFactory;
    private final CLAccessorFactory factory;
    private Set<String> extensions;
    protected final CLPlatformInfoAccessor info;

    private CLPlatform(long l) {
        this(l, null);
    }

    protected CLPlatform(long l, CLAccessorFactory cLAccessorFactory) {
        CLPlatform.initialize();
        this.ID = l;
        this.factory = cLAccessorFactory == null ? defaultFactory : cLAccessorFactory;
        this.info = this.factory.createPlatformInfoAccessor(cl, l);
        this.version = new CLVersion(this.getInfoString(2305));
    }

    public static void initialize() throws JogampRuntimeException {
        CLPlatform.initialize(null);
    }

    static synchronized void initialize(CLAccessorFactory cLAccessorFactory) throws JogampRuntimeException {
        if (cl != null) {
            return;
        }
        if (defaultFactory == null) {
            defaultFactory = cLAccessorFactory == null ? new CLTLAccessorFactory() : cLAccessorFactory;
        }
        try {
            if (null == CLImpl.getCLProcAddressTable()) {
                throw new JogampRuntimeException("JOCL ProcAddressTable is NULL");
            }
            cl = new CLImpl();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(JOCLVersion.getAllVersions());
            throw unsatisfiedLinkError;
        }
        catch (Exception exception) {
            System.err.println(JOCLVersion.getAllVersions());
            throw new JogampRuntimeException("JOCL initialization error.", exception);
        }
    }

    public static CLPlatform getDefault() {
        CLPlatform.initialize();
        return CLPlatform.latest(CLPlatform.listCLPlatforms());
    }

    public static CLPlatform getDefault(Filter<CLPlatform> ... filterArray) {
        CLPlatform[] cLPlatformArray = CLPlatform.listCLPlatforms(filterArray);
        if (cLPlatformArray.length > 0) {
            return CLPlatform.latest(cLPlatformArray);
        }
        return null;
    }

    private static CLPlatform latest(CLPlatform[] cLPlatformArray) {
        CLPlatform cLPlatform = cLPlatformArray[0];
        for (CLPlatform cLPlatform2 : cLPlatformArray) {
            if (cLPlatform2.version.compareTo(cLPlatform.version) <= 0) continue;
            cLPlatform = cLPlatform2;
        }
        return cLPlatform;
    }

    public static CLPlatform[] listCLPlatforms() {
        return CLPlatform.listCLPlatforms(null);
    }

    public static CLPlatform[] listCLPlatforms(Filter<CLPlatform> ... filterArray) {
        CLPlatform.initialize();
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        int n = cl.clGetPlatformIDs(0, null, intBuffer);
        CLException.checkForError(n, "can not enumerate platforms");
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect(intBuffer.get(0));
        n = cl.clGetPlatformIDs(pointerBuffer.capacity(), pointerBuffer, null);
        CLException.checkForError(n, "can not enumerate platforms");
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < pointerBuffer.capacity(); ++i) {
            CLPlatform cLPlatform = new CLPlatform(pointerBuffer.get(i));
            CLPlatform.addIfAccepted(cLPlatform, arrayList, filterArray);
        }
        return arrayList.toArray(new CLPlatform[arrayList.size()]);
    }

    public static CL getLowLevelCLInterface() {
        CLPlatform.initialize();
        return cl;
    }

    public static void unloadCompiler() {
        CLPlatform.initialize();
        int n = cl.clUnloadCompiler();
        CLException.checkForError(n, "error while sending unload compiler hint");
    }

    public CLDevice[] listCLDevices() {
        return this.listCLDevices(CLDevice.Type.ALL);
    }

    public CLDevice[] listCLDevices(CLDevice.Type ... typeArray) {
        CLPlatform.initialize();
        ArrayList<CLDevice> arrayList = new ArrayList<CLDevice>();
        for (int i = 0; i < typeArray.length; ++i) {
            CLDevice.Type type = typeArray[i];
            long[] lArray = this.info.getDeviceIDs(type.TYPE);
            for (int j = 0; j < lArray.length; ++j) {
                arrayList.add(this.createDevice(lArray[j]));
            }
        }
        return arrayList.toArray(new CLDevice[arrayList.size()]);
    }

    public CLDevice[] listCLDevices(Filter<CLDevice> ... filterArray) {
        CLPlatform.initialize();
        ArrayList arrayList = new ArrayList();
        long[] lArray = this.info.getDeviceIDs(-1L);
        for (int i = 0; i < lArray.length; ++i) {
            CLDevice cLDevice = this.createDevice(lArray[i]);
            CLPlatform.addIfAccepted(cLDevice, arrayList, filterArray);
        }
        return arrayList.toArray(new CLDevice[arrayList.size()]);
    }

    protected CLDevice createDevice(long l) {
        return new CLDevice(this, l);
    }

    private static <I> void addIfAccepted(I i, List<I> list, Filter<I>[] filterArray) {
        if (filterArray == null) {
            list.add(i);
        } else {
            boolean bl = true;
            for (Filter<I> filter : filterArray) {
                if (filter.accept(i)) continue;
                bl = false;
                break;
            }
            if (bl) {
                list.add(i);
            }
        }
    }

    static CLDevice findMaxFlopsDevice(CLDevice[] cLDeviceArray) {
        return CLPlatform.findMaxFlopsDevice(cLDeviceArray, null);
    }

    static CLDevice findMaxFlopsDevice(CLDevice[] cLDeviceArray, CLDevice.Type type) {
        CLPlatform.initialize();
        CLDevice cLDevice = null;
        int n = -1;
        for (int i = 0; i < cLDeviceArray.length; ++i) {
            int n2;
            int n3;
            int n4;
            CLDevice cLDevice2 = cLDeviceArray[i];
            if (type != null && !type.equals((Object)cLDevice2.getType()) || (n4 = (n3 = cLDevice2.getMaxComputeUnits()) * (n2 = cLDevice2.getMaxClockFrequency())) <= n) continue;
            n = n4;
            cLDevice = cLDevice2;
        }
        return cLDevice;
    }

    public CLDevice getMaxFlopsDevice() {
        return CLPlatform.findMaxFlopsDevice(this.listCLDevices());
    }

    public CLDevice getMaxFlopsDevice(CLDevice.Type ... typeArray) {
        return CLPlatform.findMaxFlopsDevice(this.listCLDevices(typeArray));
    }

    public CLDevice getMaxFlopsDevice(Filter<CLDevice> ... filterArray) {
        return CLPlatform.findMaxFlopsDevice(this.listCLDevices(filterArray));
    }

    @CLProperty(value="CL_PLATFORM_NAME")
    public String getName() {
        return this.getInfoString(2306);
    }

    @CLProperty(value="CL_PLATFORM_VERSION")
    public CLVersion getVersion() {
        return this.version;
    }

    public String getSpecVersion() {
        return this.version.getSpecVersion();
    }

    public boolean isAtLeast(CLVersion cLVersion) {
        return this.version.isAtLeast(cLVersion);
    }

    public boolean isAtLeast(int n, int n2) {
        return this.version.isAtLeast(n, n2);
    }

    @CLProperty(value="CL_PLATFORM_PROFILE")
    public String getProfile() {
        return this.getInfoString(2304);
    }

    @CLProperty(value="CL_PLATFORM_VENDOR")
    public String getVendor() {
        return this.getInfoString(2307);
    }

    @CLProperty(value="CL_PLATFORM_ICD_SUFFIX_KHR")
    public String getICDSuffix() {
        return this.getInfoString(2336);
    }

    public boolean isExtensionAvailable(String string) {
        return this.getExtensions().contains(string);
    }

    @CLProperty(value="CL_PLATFORM_EXTENSIONS")
    public synchronized Set<String> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new HashSet<String>();
            String string = this.getInfoString(2308);
            Scanner scanner = new Scanner(string);
            while (scanner.hasNext()) {
                this.extensions.add(scanner.next());
            }
            this.extensions = Collections.unmodifiableSet(this.extensions);
        }
        return this.extensions;
    }

    public Map<String, String> getProperties() {
        return CLUtil.obtainPlatformProperties(this);
    }

    public final String getInfoString(int n) {
        return this.info.getString(n);
    }

    final CLAccessorFactory getAccessorFactory() {
        return this.factory;
    }

    public final CLPlatformInfoAccessor getCLAccessor() {
        return this.info;
    }

    protected CLBufferBinding getBufferBinding() {
        return cl;
    }

    protected CLCommandQueueBinding getCommandQueueBinding() {
        return cl;
    }

    protected CLContextBinding getContextBinding() {
        return cl;
    }

    protected CLDeviceBinding getDeviceBinding() {
        return cl;
    }

    protected CLEventBinding getEventBinding() {
        return cl;
    }

    protected CLImageBinding getImageBinding() {
        return cl;
    }

    protected CLKernelBinding getKernelBinding() {
        return cl;
    }

    protected CLMemObjBinding getMemObjectBinding() {
        return cl;
    }

    protected CLPlatformBinding getPlatformBinding() {
        return cl;
    }

    protected CLProgramBinding getProgramBinding() {
        return cl;
    }

    protected CLSamplerBinding getSamplerBinding() {
        return cl;
    }

    protected CL getCLBinding() {
        return cl;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name: " + this.getName() + ", vendor: " + this.getVendor() + ", profile: " + this.getProfile() + ", version: " + this.getVersion() + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CLPlatform cLPlatform = (CLPlatform)object;
        return this.ID == cLPlatform.ID;
    }

    public int hashCode() {
        int n = 7;
        n = 71 * n + (int)(this.ID ^ this.ID >>> 32);
        return n;
    }
}

