/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import jogamp.opengl.GLContextImpl;

final class ExtensionAvailabilityCache {
    protected static final boolean DEBUG = GLContextImpl.DEBUG;
    private boolean initialized = false;
    private String glExtensions = null;
    private int glExtensionCount = 0;
    private String glXExtensions = null;
    private int glXExtensionCount = 0;
    private final HashSet<String> availableExtensionCache = new HashSet(50);

    ExtensionAvailabilityCache() {
        this.flush();
    }

    final void flush() {
        this.initialized = false;
        this.glExtensions = null;
        this.glExtensionCount = 0;
        this.glXExtensions = null;
        this.glXExtensionCount = 0;
        this.availableExtensionCache.clear();
    }

    final void reset(GLContextImpl gLContextImpl) {
        this.flush();
        this.initAvailableExtensions(gLContextImpl);
    }

    final boolean isInitialized() {
        return this.initialized && !this.availableExtensionCache.isEmpty();
    }

    final int getTotalExtensionCount() {
        this.validateInitialization();
        return this.availableExtensionCache.size();
    }

    final boolean isExtensionAvailable(String string) {
        this.validateInitialization();
        return this.availableExtensionCache.contains(string);
    }

    final int getPlatformExtensionCount() {
        this.validateInitialization();
        return this.glXExtensionCount;
    }

    final String getPlatformExtensionsString() {
        this.validateInitialization();
        return this.glXExtensions;
    }

    final int getGLExtensionCount() {
        this.validateInitialization();
        return this.glExtensionCount;
    }

    final String getGLExtensionsString() {
        this.validateInitialization();
        if (DEBUG) {
            System.err.println("ExtensionAvailabilityCache: getGLExtensions() called");
        }
        return this.glExtensions;
    }

    private final void validateInitialization() {
        if (!this.isInitialized()) {
            throw new InternalError("ExtensionAvailabilityCache not initialized!");
        }
    }

    private final void initAvailableExtensions(GLContextImpl gLContextImpl) {
        Object object;
        Object object2;
        Object object3;
        GL gL = gLContextImpl.getGL();
        if (this.isInitialized()) {
            throw new InternalError("ExtensionAvailabilityCache already initialized!");
        }
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Pre-caching init " + gL + ", OpenGL " + gLContextImpl.getGLVersion());
        }
        boolean bl = false;
        if (gLContextImpl.isGL3()) {
            if (!gLContextImpl.isFunctionAvailable("glGetStringi")) {
                if (DEBUG) {
                    System.err.println("GLContext: GL >= 3.1 usage, but no glGetStringi");
                }
            } else {
                bl = true;
            }
        }
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Pre-caching extension availability OpenGL " + gLContextImpl.getGLVersion() + ", use " + (bl ? "glGetStringi" : "glGetString"));
        }
        HashSet<String> hashSet = new HashSet<String>(gL.isGLES() ? 50 : 320);
        if (bl) {
            object3 = gL.getGL2GL3();
            object2 = new int[]{0};
            object3.glGetIntegerv(33309, (int[])object2, 0);
            int n = object2[0];
            object2 = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    ((StringBuilder)object2).append(" ");
                }
                object = object3.glGetStringi(7939, i);
                hashSet.add((String)object);
                ((StringBuilder)object2).append((String)object);
            }
            if (0 == n || ((StringBuilder)object2).length() == 0) {
                bl = false;
            } else {
                this.glExtensions = ((StringBuilder)object2).toString();
            }
        }
        if (!bl) {
            this.glExtensions = gL.glGetString(7939);
            if (null != this.glExtensions) {
                object3 = new StringTokenizer(this.glExtensions);
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    hashSet.add(((StringTokenizer)object3).nextToken().trim());
                }
            }
        }
        this.glExtensionCount = hashSet.size();
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: GL_EXTENSIONS: " + this.glExtensionCount + ", used " + (bl ? "glGetStringi" : "glGetString"));
        }
        object3 = new HashSet(50);
        StringTokenizer stringTokenizer = new StringTokenizer(gLContextImpl.getPlatformExtensionsStringImpl().toString());
        while (stringTokenizer.hasMoreTokens()) {
            ((HashSet)object3).add(stringTokenizer.nextToken().trim());
        }
        object2 = new StringBuilder();
        Object object4 = ((HashSet)object3).iterator();
        while (object4.hasNext()) {
            ((StringBuilder)object2).append((String)object4.next());
            if (!object4.hasNext()) continue;
            ((StringBuilder)object2).append(" ");
        }
        this.glXExtensions = ((StringBuilder)object2).toString();
        this.glXExtensionCount = ((HashSet)object3).size();
        this.availableExtensionCache.addAll(hashSet);
        this.availableExtensionCache.addAll((Collection<String>)object3);
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: GLX_EXTENSIONS: " + this.glXExtensionCount);
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: GL vendor: " + gL.glGetString(7936));
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: ALL EXTENSIONS: " + this.availableExtensionCache.size());
        }
        int n = gLContextImpl.getCtxOptions();
        object2 = gLContextImpl.getGLVersionNumber();
        object4 = new int[]{object2.getMajor()};
        object = new int[]{object2.getMinor()};
        do {
            String string = (gLContextImpl.isGLES() ? "GL_ES_VERSION_" : "GL_VERSION_") + (int)object4[0] + "_" + (int)object[0];
            this.availableExtensionCache.add(string);
            if (!DEBUG) continue;
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Added " + string + " to known extensions");
        } while (GLContext.decrementGLVersion(n, (int[])object4, (int[])object));
        this.availableExtensionCache.add("<INTERNAL_DUMMY_PLACEHOLDER>");
        this.initialized = true;
    }

    static String getThreadName() {
        return Thread.currentThread().getName();
    }
}

