/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.bugs;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es2.LandscapeES2;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLArrayData;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import javax.media.opengl.GLUniformData;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;

public class Bug735Inv1AppletAWT
extends Applet
implements Runnable {
    public static int AWT = 0;
    public static int NEWT = 1;
    public static int APPLET_WIDTH = 500;
    public static int APPLET_HEIGHT = 290;
    public static int TARGET_FPS = 120;
    public static int TOOLKIT = NEWT;
    public static boolean MANUAL_FRAME_HANDLING = true;
    private static Frame frame;
    private static Bug735Inv1AppletAWT applet;
    private GLCanvas awtCanvas;
    private GLWindow newtWindow;
    private NewtCanvasAWT newtCanvas;
    private DrawRunnable drawRunnable;
    private GLU glu;
    private int width;
    private int height;
    private Thread thread;
    private boolean doneInit = false;
    private boolean doneSetup = false;
    private long frameRatePeriod = 1000000000L / (long)TARGET_FPS;
    private long millisOffset;
    private int frameCount;
    private float frameRate;
    private ShaderCode vertShader;
    private ShaderCode fragShader;
    private ShaderProgram shaderProg;
    private ShaderState shaderState;
    private GLUniformData resolution;
    private GLUniformData time;
    private GLArrayDataServer vertices;
    private int fcount = 0;
    private int lastm = 0;
    private int fint = 1;

    @Override
    public void init() {
        this.setSize(APPLET_WIDTH, APPLET_HEIGHT);
        this.setPreferredSize(new Dimension(APPLET_WIDTH, APPLET_HEIGHT));
        this.width = APPLET_WIDTH;
        this.height = APPLET_HEIGHT;
    }

    @Override
    public void start() {
        this.thread = new Thread((Runnable)this, "Animation Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        int n = 0;
        long l = System.nanoTime();
        long l2 = 0L;
        this.millisOffset = System.currentTimeMillis();
        this.frameCount = 1;
        while (Thread.currentThread() == this.thread) {
            long l3;
            long l4;
            long l5;
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.requestDraw(countDownLatch);
            try {
                countDownLatch.await(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (this.frameCount == 1) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Bug735Inv1AppletAWT.this.requestFocusInWindow();
                    }
                });
            }
            if ((l5 = this.frameRatePeriod - (l4 = (l3 = System.nanoTime()) - l) - l2) > 0L) {
                try {
                    Thread.sleep(l5 / 1000000L, (int)(l5 % 1000000L));
                    n = 0;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = System.nanoTime() - l3 - l5;
            } else {
                l2 = 0L;
                if (++n > 15) {
                    Thread.yield();
                    n = 0;
                }
            }
            l = System.nanoTime();
        }
    }

    public void requestDraw(CountDownLatch countDownLatch) {
        if (!this.doneInit) {
            this.initDraw();
        }
        if (TOOLKIT == AWT) {
            this.awtCanvas.invoke(true, (GLRunnable)this.drawRunnable);
        } else if (TOOLKIT == NEWT) {
            this.newtWindow.invoke(true, (GLRunnable)this.drawRunnable);
        }
        if (countDownLatch != null) {
            countDownLatch.countDown();
        }
    }

    private void initGL() {
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setBackgroundOpaque(true);
        gLCapabilities.setOnscreen(true);
        gLCapabilities.setSampleBuffers(false);
        if (TOOLKIT == AWT) {
            this.awtCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
            this.awtCanvas.setBounds(0, 0, Bug735Inv1AppletAWT.applet.width, Bug735Inv1AppletAWT.applet.height);
            this.awtCanvas.setBackground(new Color(-3355444, true));
            this.awtCanvas.setFocusable(true);
            applet.setLayout(new BorderLayout());
            applet.add((Component)this.awtCanvas, "Center");
            if (MANUAL_FRAME_HANDLING) {
                this.awtCanvas.setIgnoreRepaint(true);
                this.awtCanvas.setAutoSwapBufferMode(false);
            }
        } else if (TOOLKIT == NEWT) {
            this.newtWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
            this.newtCanvas = new NewtCanvasAWT((Window)this.newtWindow);
            this.newtCanvas.setBounds(0, 0, Bug735Inv1AppletAWT.applet.width, Bug735Inv1AppletAWT.applet.height);
            this.newtCanvas.setBackground(new Color(-3355444, true));
            this.newtCanvas.setFocusable(true);
            applet.setLayout(new BorderLayout());
            applet.add((Component)this.newtCanvas, "Center");
            if (MANUAL_FRAME_HANDLING) {
                this.newtCanvas.setIgnoreRepaint(true);
                this.newtWindow.setAutoSwapBufferMode(false);
            }
        }
    }

    private void initDraw() {
        if (TOOLKIT == AWT) {
            this.awtCanvas.setVisible(true);
            this.awtCanvas.display();
            if (this.awtCanvas.getDelegatedDrawable().isRealized()) {
                this.awtCanvas.requestFocus();
            }
        } else if (TOOLKIT == NEWT) {
            this.newtCanvas.setVisible(true);
            this.newtWindow.display();
            if (this.newtWindow.isRealized()) {
                this.newtCanvas.requestFocus();
            }
        }
        this.drawRunnable = new DrawRunnable();
        this.doneInit = true;
    }

    private void setup(GL2ES2 gL2ES2) {
        if (60 < TARGET_FPS) {
            gL2ES2.setSwapInterval(0);
        }
        this.glu = new GLU();
        this.vertShader = ShaderCode.create((GL2ES2)gL2ES2, (int)35633, LandscapeES2.class, (String)"shader", (String)"shader/bin", (String)"landscape", (boolean)true);
        this.fragShader = ShaderCode.create((GL2ES2)gL2ES2, (int)35632, LandscapeES2.class, (String)"shader", (String)"shader/bin", (String)"landscape", (boolean)true);
        this.vertShader.defaultShaderCustomization(gL2ES2, true, true);
        this.fragShader.defaultShaderCustomization(gL2ES2, true, true);
        this.shaderProg = new ShaderProgram();
        this.shaderProg.add(gL2ES2, this.vertShader, System.err);
        this.shaderProg.add(gL2ES2, this.fragShader, System.err);
        this.shaderState = new ShaderState();
        this.shaderState.attachShaderProgram(gL2ES2, this.shaderProg, true);
        this.resolution = new GLUniformData("iResolution", 3, FloatBuffer.wrap(new float[]{this.width, this.height, 0.0f}));
        this.shaderState.ownUniform(this.resolution);
        this.shaderState.uniform(gL2ES2, this.resolution);
        this.time = new GLUniformData("iGlobalTime", 0.0f);
        this.shaderState.ownUniform(this.time);
        this.vertices = GLArrayDataServer.createGLSL((String)"inVertex", (int)2, (int)5126, (boolean)false, (int)4, (int)35044);
        this.vertices.putf(-1.0f);
        this.vertices.putf(-1.0f);
        this.vertices.putf(1.0f);
        this.vertices.putf(-1.0f);
        this.vertices.putf(-1.0f);
        this.vertices.putf(1.0f);
        this.vertices.putf(1.0f);
        this.vertices.putf(1.0f);
        this.vertices.seal((GL)gL2ES2, true);
        this.shaderState.ownAttribute((GLArrayData)this.vertices, true);
        this.shaderState.useProgram(gL2ES2, false);
        this.doneSetup = true;
    }

    private void draw(GL2ES2 gL2ES2) {
        this.shaderState.useProgram(gL2ES2, true);
        this.time.setData((float)(System.currentTimeMillis() - this.millisOffset) / 1000.0f);
        this.shaderState.uniform(gL2ES2, this.time);
        this.vertices.enableBuffer((GL)gL2ES2, true);
        gL2ES2.glDrawArrays(5, 0, 4);
        this.vertices.enableBuffer((GL)gL2ES2, false);
        this.shaderState.useProgram(gL2ES2, false);
        ++this.frameCount;
        ++this.fcount;
        int n = (int)(System.currentTimeMillis() - this.millisOffset);
        if (n - this.lastm > 1000 * this.fint) {
            this.frameRate = (float)this.fcount / (float)this.fint;
            this.fcount = 0;
            this.lastm = n;
        }
        if (this.frameCount % TARGET_FPS == 0) {
            System.out.println("FrameCount: " + this.frameCount + " - " + "FrameRate: " + this.frameRate);
        }
    }

    private void checkGLErrors(GL gL) {
        int n = gL.glGetError();
        if (n != 0) {
            String string = this.glu.gluErrorString(n);
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        frame = new Frame(graphicsDevice.getDefaultConfiguration());
        frame.setBackground(new Color(204, 204, 204));
        frame.setTitle("TestBug735Inv1AppletAWT");
        try {
            serializable = Thread.currentThread().getContextClassLoader().loadClass(Bug735Inv1AppletAWT.class.getName());
            applet = (Bug735Inv1AppletAWT)serializable.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        frame.setLayout(null);
        frame.add(applet);
        frame.pack();
        frame.setResizable(false);
        applet.init();
        serializable = frame.getInsets();
        int n = Bug735Inv1AppletAWT.applet.width + ((Insets)serializable).left + ((Insets)serializable).right;
        int n2 = Bug735Inv1AppletAWT.applet.height + ((Insets)serializable).top + ((Insets)serializable).bottom;
        frame.setSize(n, n2);
        Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
        frame.setLocation(rectangle.x + (rectangle.width - Bug735Inv1AppletAWT.applet.width) / 2, rectangle.y + (rectangle.height - Bug735Inv1AppletAWT.applet.height) / 2);
        int n3 = n2 - ((Insets)serializable).top - ((Insets)serializable).bottom;
        applet.setBounds((n - Bug735Inv1AppletAWT.applet.width) / 2, ((Insets)serializable).top + (n3 - Bug735Inv1AppletAWT.applet.height) / 2, Bug735Inv1AppletAWT.applet.width, Bug735Inv1AppletAWT.applet.height);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        applet.initGL();
        frame.setVisible(true);
        applet.start();
    }

    private class DrawRunnable
    implements GLRunnable {
        private boolean notCurrent;

        private DrawRunnable() {
        }

        public boolean run(GLAutoDrawable gLAutoDrawable) {
            if (MANUAL_FRAME_HANDLING) {
                this.makeContextCurrent(gLAutoDrawable.getContext());
            }
            if (!Bug735Inv1AppletAWT.this.doneSetup) {
                Bug735Inv1AppletAWT.this.setup(gLAutoDrawable.getGL().getGL2ES2());
            }
            Bug735Inv1AppletAWT.this.draw(gLAutoDrawable.getGL().getGL2ES2());
            Bug735Inv1AppletAWT.this.checkGLErrors(gLAutoDrawable.getGL());
            if (MANUAL_FRAME_HANDLING) {
                this.swapBuffers(gLAutoDrawable.getContext());
                this.releaseCurrentContext(gLAutoDrawable.getContext());
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void makeContextCurrent(GLContext gLContext) {
            int n = 10;
            if (gLContext.isCurrent()) {
                this.notCurrent = false;
            } else {
                this.notCurrent = true;
                int n2 = 0;
                int n3 = 0;
                do {
                    block10: {
                        try {
                            n2 = gLContext.makeCurrent();
                            System.out.println("Made context current");
                        }
                        catch (GLException gLException) {
                            gLException.printStackTrace();
                        }
                        finally {
                            if (++n3 != n) break block10;
                            throw new RuntimeException("Failed to claim OpenGL context.");
                        }
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                } while (n2 == 0);
            }
        }

        private void swapBuffers(GLContext gLContext) {
            GL gL = gLContext.getGL();
            gL.glFlush();
            gLContext.getGLDrawable().swapBuffers();
        }

        private void releaseCurrentContext(GLContext gLContext) {
            if (this.notCurrent) {
                try {
                    gLContext.release();
                    System.out.println("Released context");
                }
                catch (GLException gLException) {
                    gLException.printStackTrace();
                }
            }
        }
    }
}

