/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.common.os.Platform;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.graph.geom.opengl.SVertex;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.graph.demos.GPURegionGLListener01;
import com.jogamp.opengl.test.junit.graph.demos.GPURegionGLListener02;
import com.jogamp.opengl.test.junit.graph.demos.GPURegionRendererListenerBase01;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.io.IOException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestRegionRendererNEWT01
extends UITestCase {
    public static void main(String[] stringArray) throws IOException {
        String string = TestRegionRendererNEWT01.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static void destroyWindow(GLWindow gLWindow) {
        if (null != gLWindow) {
            gLWindow.destroy();
        }
    }

    static GLWindow createWindow(String string, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, int n2) {
        Assert.assertNotNull((Object)gLCapabilitiesImmutable);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilitiesImmutable);
        gLWindow.setSize(n, n2);
        gLWindow.setPosition(10, 10);
        gLWindow.setTitle(string);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setVisible(true);
        return gLWindow;
    }

    @Test
    public void testRegionRendererR2T01() throws InterruptedException {
        if (Platform.CPUFamily.X86 != Platform.CPU_ARCH.family) {
            System.err.println("disabled on non desktop (x86) arch for now ..");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        GLWindow gLWindow = TestRegionRendererNEWT01.createWindow("shape-vbaa1-msaa0", (GLCapabilitiesImmutable)gLCapabilities, 800, 400);
        RenderState renderState = RenderState.createRenderState((ShaderState)new ShaderState(), (Vertex.Factory)SVertex.factory());
        GPURegionGLListener02 gPURegionGLListener02 = new GPURegionGLListener02(renderState, 1, 1140, false, false);
        gPURegionGLListener02.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener((GLEventListener)gPURegionGLListener02);
        RegionGLListener regionGLListener = new RegionGLListener(gPURegionGLListener02, gLWindow.getTitle(), "GPURegionNewtDemo02");
        gLWindow.addGLEventListener((GLEventListener)regionGLListener);
        regionGLListener.setTech(-20.0f, 0.0f, 0.0f, -300, 400);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, 0.0f, -150, 800);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, 0.0f, -50, 1000);
        gLWindow.display();
        TestRegionRendererNEWT01.destroyWindow(gLWindow);
    }

    @Test
    public void testRegionRendererMSAA01() throws InterruptedException {
        GLProfile gLProfile = GLProfile.get((String)"GL2ES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        GLWindow gLWindow = TestRegionRendererNEWT01.createWindow("shape-vbaa0-msaa1", (GLCapabilitiesImmutable)gLCapabilities, 800, 400);
        RenderState renderState = RenderState.createRenderState((ShaderState)new ShaderState(), (Vertex.Factory)SVertex.factory());
        GPURegionGLListener01 gPURegionGLListener01 = new GPURegionGLListener01(renderState, 0, 0, false, false);
        gPURegionGLListener01.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener((GLEventListener)gPURegionGLListener01);
        RegionGLListener regionGLListener = new RegionGLListener(gPURegionGLListener01, gLWindow.getTitle(), "GPURegion01");
        gLWindow.addGLEventListener((GLEventListener)regionGLListener);
        regionGLListener.setTech(-20.0f, 0.0f, 0.0f, -300, 400);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, 0.0f, -150, 800);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, 0.0f, -50, 1000);
        gLWindow.display();
        TestRegionRendererNEWT01.destroyWindow(gLWindow);
    }

    @Test
    public void testRegionRendererMSAA02() throws InterruptedException {
        if (Platform.CPUFamily.X86 != Platform.CPU_ARCH.family) {
            System.err.println("disabled on non desktop (x86) arch for now ..");
            return;
        }
        GLProfile gLProfile = GLProfile.get((String)"GL2ES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        GLWindow gLWindow = TestRegionRendererNEWT01.createWindow("shape-vbaa0-msaa1", (GLCapabilitiesImmutable)gLCapabilities, 800, 400);
        RenderState renderState = RenderState.createRenderState((ShaderState)new ShaderState(), (Vertex.Factory)SVertex.factory());
        GPURegionGLListener01 gPURegionGLListener01 = new GPURegionGLListener01(renderState, 2, 0, false, false);
        gPURegionGLListener01.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener((GLEventListener)gPURegionGLListener01);
        RegionGLListener regionGLListener = new RegionGLListener(gPURegionGLListener01, gLWindow.getTitle(), "GPURegion02");
        gLWindow.addGLEventListener((GLEventListener)regionGLListener);
        regionGLListener.setTech(-20.0f, 0.0f, 0.0f, -300, 400);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, 0.0f, -150, 800);
        gLWindow.display();
        regionGLListener.setTech(-20.0f, 0.0f, 0.0f, -50, 1000);
        gLWindow.display();
        TestRegionRendererNEWT01.destroyWindow(gLWindow);
    }

    private class RegionGLListener
    implements GLEventListener {
        String winTitle;
        String name;
        GPURegionRendererListenerBase01 impl;

        public RegionGLListener(GPURegionRendererListenerBase01 gPURegionRendererListenerBase01, String string, String string2) {
            this.impl = gPURegionRendererListenerBase01;
            this.winTitle = string;
            this.name = string2;
        }

        public void setTech(float f, float f2, float f3, int n, int n2) {
            this.impl.setMatrix(f, f2, f3, n, n2);
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            this.impl.init(gLAutoDrawable);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            this.impl.display(gLAutoDrawable);
            try {
                this.impl.printScreen(gLAutoDrawable, "./", this.winTitle, this.name, false);
            }
            catch (GLException gLException) {
                gLException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
            this.impl.dispose(gLAutoDrawable);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            this.impl.reshape(gLAutoDrawable, n, n2, n3, n4);
        }
    }
}

