/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.curve.opengl.TextRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.graph.geom.opengl.SVertex;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTextRendererNEWT00
extends UITestCase {
    static final boolean DEBUG = false;
    static final boolean TRACE = false;
    static long duration = 100L;
    static final float[] textPosition = new float[]{0.0f, 0.0f, 0.0f};
    static final int[] texSize = new int[]{0};
    static final int fontSize = 24;
    static Font font;
    int screenshot_num = 0;
    int lastRow = -1;

    @BeforeClass
    public static void setup() throws IOException {
        font = FontFactory.get((int)0).getDefault();
    }

    static int atoi(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = TestTextRendererNEWT00.atoi(stringArray[++i]);
        }
        String string = TestTextRendererNEWT00.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static void sleep() {
        try {
            System.err.println("** new frame ** (sleep: " + duration + "ms)");
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void destroyWindow(GLWindow gLWindow) {
        if (null != gLWindow) {
            gLWindow.destroy();
        }
    }

    static GLWindow createWindow(String string, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, int n2) {
        Assert.assertNotNull((Object)gLCapabilitiesImmutable);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilitiesImmutable);
        gLWindow.setSize(n, n2);
        gLWindow.setPosition(10, 10);
        gLWindow.setTitle(string);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setVisible(true);
        return gLWindow;
    }

    @Test
    public void testTextRendererMSAA01() throws InterruptedException {
        GLProfile gLProfile = GLProfile.get((String)"GL2ES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        System.err.println("Requested: " + gLCapabilities);
        GLWindow gLWindow = TestTextRendererNEWT00.createWindow("text-vbaa0-msaa1", (GLCapabilitiesImmutable)gLCapabilities, 800, 400);
        gLWindow.display();
        System.err.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        RenderState renderState = RenderState.createRenderState((ShaderState)new ShaderState(), (Vertex.Factory)SVertex.factory());
        final TextRendererListener textRendererListener = new TextRendererListener(renderState);
        final TextRenderer textRenderer = textRendererListener.getRenderer();
        gLWindow.addGLEventListener((GLEventListener)textRendererListener);
        gLWindow.invoke(true, new GLRunnable(){

            public boolean run(GLAutoDrawable gLAutoDrawable) {
                int n = 0;
                TestTextRendererNEWT00.this.renderString(gLAutoDrawable, textRenderer, "GlueGen", n++, -1, -1000);
                TestTextRendererNEWT00.this.renderString(gLAutoDrawable, textRenderer, "JOAL", n++, -1, -1000);
                TestTextRendererNEWT00.this.renderString(gLAutoDrawable, textRenderer, "JOGL", n++, -1, -1000);
                TestTextRendererNEWT00.this.renderString(gLAutoDrawable, textRenderer, "JOCL", n++, -1, -1000);
                try {
                    textRendererListener.printScreen(gLAutoDrawable, "./", "TestTextRendererNEWT00-snap" + TestTextRendererNEWT00.this.screenshot_num, false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return true;
            }
        });
        TestTextRendererNEWT00.sleep();
        TestTextRendererNEWT00.destroyWindow(gLWindow);
    }

    void renderString(GLAutoDrawable gLAutoDrawable, TextRenderer textRenderer, String string, int n, int n2, int n3) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        int n4 = gLAutoDrawable.getHeight();
        int n5 = 0;
        int n6 = n4;
        if (0 > n2) {
            n2 = this.lastRow + 1;
        }
        AABBox aABBox = font.getStringBounds((CharSequence)string, 24.0f);
        n5 = (int)((float)n5 + font.getAdvanceWidth(88, 24.0f) * (float)n);
        textRenderer.resetModelview(null);
        textRenderer.translate(gL2ES2, (float)n5, (float)(n6 -= (int)aABBox.getHeight() * (n2 + 1)), (float)n3);
        textRenderer.drawString3D(gL2ES2, font, string, textPosition, 24, texSize);
        this.lastRow = n2;
    }

    public class TextRendererListener
    implements GLEventListener {
        private GLReadBufferUtil screenshot = new GLReadBufferUtil(false, false);
        private TextRenderer renderer;

        public TextRendererListener(RenderState renderState) {
            this.renderer = TextRenderer.create((RenderState)renderState, (int)0);
        }

        public final TextRenderer getRenderer() {
            return this.renderer;
        }

        public void printScreen(GLAutoDrawable gLAutoDrawable, String string, String string2, boolean bl) throws GLException, IOException {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%s-%03dx%03d-T%04d", string2, gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight(), texSize[0]);
            String string3 = string + stringWriter + ".png";
            if (this.screenshot.readPixels(gLAutoDrawable.getGL(), false)) {
                this.screenshot.write(new File(string3));
            }
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.renderer.init(gL2ES2);
            this.renderer.setAlpha(gL2ES2, 1.0f);
            this.renderer.setColorStatic(gL2ES2, 0.0f, 0.0f, 0.0f);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            gL2ES2.glViewport(n, n2, n3, n4);
            this.renderer.reshapeOrtho(gL2ES2, n3, n4, 0.1f, 1000.0f);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            gL2ES2.glClear(16640);
            TestTextRendererNEWT00.this.renderString(gLAutoDrawable, this.renderer, "012345678901234567890123456789", 0, 0, -1000);
            TestTextRendererNEWT00.this.renderString(gLAutoDrawable, this.renderer, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", 0, -1, -1000);
            TestTextRendererNEWT00.this.renderString(gLAutoDrawable, this.renderer, "Hello World", 0, -1, -1000);
            TestTextRendererNEWT00.this.renderString(gLAutoDrawable, this.renderer, "4567890123456", 4, -1, -1000);
            TestTextRendererNEWT00.this.renderString(gLAutoDrawable, this.renderer, "I like JogAmp", 4, -1, -1000);
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            this.screenshot.dispose((GL)gL2ES2);
            this.renderer.destroy(gL2ES2);
        }
    }
}

