/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.curve.opengl.TextRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.graph.geom.opengl.SVertex;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.test.junit.util.NEWTGLContext;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.io.IOException;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTextRendererNEWT10
extends UITestCase {
    static final boolean DEBUG = false;
    static final boolean TRACE = false;
    static long duration = 100L;
    static boolean forceES2 = false;
    static boolean forceGL3 = false;
    static boolean mainRun = false;
    static final float[] textPosition = new float[]{0.0f, 0.0f, 0.0f};
    static final int[] texSize = new int[]{0};
    static final int fontSize = 24;
    static Font font;
    int screenshot_num = 0;
    int lastRow = -1;

    @BeforeClass
    public static void setup() throws IOException {
        font = FontFactory.get((int)0).getDefault();
    }

    static int atoi(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        mainRun = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = TestTextRendererNEWT10.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (!stringArray[i].equals("-gl3")) continue;
            forceGL3 = true;
        }
        String string = TestTextRendererNEWT10.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static void sleep() {
        try {
            System.err.println("** new frame ** (sleep: " + duration + "ms)");
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testTextRendererMSAA01() throws InterruptedException {
        GLProfile gLProfile = forceGL3 ? GLProfile.get((String)"GL3") : (forceES2 ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2());
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        System.err.println("Requested: " + gLCapabilities);
        NEWTGLContext.WindowContext windowContext = NEWTGLContext.createOnscreenWindow(gLCapabilities, 800, 400, true);
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        GL2ES2 gL2ES2 = windowContext.context.getGL().getGL2ES2();
        System.err.println(windowContext.context);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        System.err.println("Chosen: " + windowContext.window.getChosenCapabilities());
        RenderState renderState = RenderState.createRenderState((ShaderState)new ShaderState(), (Vertex.Factory)SVertex.factory());
        TextRenderer textRenderer = TextRenderer.create((RenderState)renderState, (int)0);
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        textRenderer.init(gL2ES2);
        textRenderer.setAlpha(gL2ES2, 1.0f);
        textRenderer.setColorStatic(gL2ES2, 0.0f, 0.0f, 0.0f);
        gL2ES2.glViewport(0, 0, gLDrawable.getWidth(), gLDrawable.getHeight());
        textRenderer.reshapeOrtho(gL2ES2, gLDrawable.getWidth(), gLDrawable.getHeight(), 0.1f, 1000.0f);
        gL2ES2.glClear(16640);
        this.renderString(gLDrawable, gL2ES2, textRenderer, "012345678901234567890123456789", 0, 0, -1000);
        this.renderString(gLDrawable, gL2ES2, textRenderer, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", 0, -1, -1000);
        this.renderString(gLDrawable, gL2ES2, textRenderer, "Hello World", 0, -1, -1000);
        this.renderString(gLDrawable, gL2ES2, textRenderer, "4567890123456", 4, -1, -1000);
        this.renderString(gLDrawable, gL2ES2, textRenderer, "I like JogAmp", 4, -1, -1000);
        int n = 0;
        this.renderString(gLDrawable, gL2ES2, textRenderer, "GlueGen", n++, -1, -1000);
        this.renderString(gLDrawable, gL2ES2, textRenderer, "JOAL", n++, -1, -1000);
        this.renderString(gLDrawable, gL2ES2, textRenderer, "JOGL", n++, -1, -1000);
        this.renderString(gLDrawable, gL2ES2, textRenderer, "JOCL", n++, -1, -1000);
        gLDrawable.swapBuffers();
        TestTextRendererNEWT10.sleep();
        textRenderer.destroy(gL2ES2);
        NEWTGLContext.destroyWindow(windowContext);
    }

    void renderString(GLDrawable gLDrawable, GL2ES2 gL2ES2, TextRenderer textRenderer, String string, int n, int n2, int n3) {
        int n4 = gLDrawable.getHeight();
        int n5 = 0;
        int n6 = n4;
        if (0 > n2) {
            n2 = this.lastRow + 1;
        }
        AABBox aABBox = font.getStringBounds((CharSequence)string, 24.0f);
        n5 = (int)((float)n5 + font.getAdvanceWidth(88, 24.0f) * (float)n);
        textRenderer.resetModelview(null);
        textRenderer.translate(gL2ES2, (float)n5, (float)(n6 -= (int)aABBox.getHeight() * (n2 + 1)), (float)n3);
        textRenderer.drawString3D(gL2ES2, font, string, textPosition, 24, texSize);
        this.lastRow = n2;
    }
}

