/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos;

import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.curve.opengl.Renderer;
import com.jogamp.graph.curve.opengl.TextRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.test.junit.graph.demos.GPURendererListenerBase01;
import java.io.IOException;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLException;

public abstract class GPUTextRendererListenerBase01
extends GPURendererListenerBase01 {
    int fontSet = 0;
    Font font;
    int headType = 0;
    boolean drawFPS = false;
    final int fontSizeFixed = 6;
    int fontSize = 40;
    final int fontSizeModulo = 100;
    String fontName;
    AABBox fontNameBox;
    String headtext;
    AABBox headbox;
    static final String text1 = "abcdefghijklmnopqrstuvwxyz\nABCDEFGHIJKLMNOPQRSTUVWXYZ\n0123456789.:,;(*!?/\\\")$%^&-+@~#<>{}[]";
    static final String text2 = "The quick brown fox jumps over the lazy dog";
    static final String textX = "JOGAMP graph demo using Resolution Independent NURBS\nJOGAMP JOGL - OpenGL ES2 profile\nPress 1/2 to zoom in/out the below text\nPress 6/7 to edit texture size if using VBAA\nPress 0/9 to rotate the below string\nPress v to toggle vsync\nPress i for live input text input (CR ends it, backspace supported)\nPress f to toggle fps. H for different text, space for font type\n";
    static final String textX2 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec nec sapien tellus. \nUt purus odio, rhoncus sit amet commodo eget, ullamcorper vel urna. Mauris ultricies \nquam iaculis urna cursus ornare. Nullam ut felis a ante ultrices ultricies nec a elit. \nIn hac habitasse platea dictumst. Vivamus et mi a quam lacinia pharetra at venenatis est.\nMorbi quis bibendum nibh. Donec lectus orci, sagittis in consequat nec, volutpat nec nisi.\nDonec ut dolor et nulla tristique varius. In nulla magna, fermentum id tempus quis, semper \nin lorem. Maecenas in ipsum ac justo scelerisque sollicitudin. Quisque sit amet neque lorem,\n-------Press H to change text---------\n";
    StringBuilder userString = new StringBuilder();
    boolean userInput = false;
    KeyAction keyAction = null;

    public GPUTextRendererListenerBase01(RenderState renderState, int n, boolean bl, boolean bl2) {
        super((Renderer)TextRenderer.create((RenderState)renderState, (int)n), n, bl, bl2);
        try {
            this.font = FontFactory.get((int)this.fontSet).getDefault();
            this.dumpFontNames();
            this.fontName = this.font.toString();
            this.fontNameBox = this.font.getStringBounds((CharSequence)this.fontName, 12.0f);
            this.switchHeadBox();
        }
        catch (IOException iOException) {
            System.err.println("Catched: " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    void dumpFontNames() {
        System.err.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        System.err.println(this.font.getAllNames(null, "\n"));
        System.err.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
    }

    void switchHeadBox() {
        this.headType = (this.headType + 1) % 4;
        switch (this.headType) {
            case 0: {
                this.headtext = null;
                break;
            }
            case 1: {
                this.headtext = textX2;
                break;
            }
            case 2: {
                this.headtext = textX;
                break;
            }
            default: {
                this.headtext = text1;
            }
        }
        if (null != this.headtext) {
            this.headbox = this.font.getStringBounds((CharSequence)this.headtext, 18.0f);
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        boolean bl;
        int n = gLAutoDrawable.getWidth();
        int n2 = gLAutoDrawable.getHeight();
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gL2ES2.glClear(16640);
        TextRenderer textRenderer = (TextRenderer)this.getRenderer();
        textRenderer.reshapeOrtho(null, n, n2, 0.1f, 7000.0f);
        textRenderer.setColorStatic(gL2ES2, 0.0f, 0.0f, 0.0f);
        GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
        boolean bl2 = bl = this.drawFPS && null != gLAnimatorControl && gLAnimatorControl.getTotalFPSFrames() > 10;
        if (bl) {
            float f = gLAnimatorControl.getTotalFPS();
            String string = String.valueOf(f);
            int n3 = string.indexOf(46);
            textRenderer.resetModelview(null);
            textRenderer.translate(gL2ES2, 6.0f, 6.0f, -6000.0f);
            textRenderer.drawString3D(gL2ES2, this.font, string.substring(0, n3 + 2) + " fps", this.getPosition(), 18, this.getTexSize());
        }
        int n4 = n - (int)this.fontNameBox.getWidth() - 2;
        int n5 = n2 - 10;
        textRenderer.resetModelview(null);
        textRenderer.translate(gL2ES2, (float)n4, (float)n5, -6000.0f);
        textRenderer.drawString3D(gL2ES2, this.font, this.fontName, this.getPosition(), 12, this.getTexSize());
        n4 = 10;
        n5 += -((int)this.fontNameBox.getHeight()) - 10;
        if (null != this.headtext) {
            textRenderer.resetModelview(null);
            textRenderer.translate(gL2ES2, (float)n4, (float)n5, -6000.0f);
            textRenderer.drawString3D(gL2ES2, this.font, this.headtext, this.getPosition(), 18, this.getTexSize());
        }
        textRenderer.reshapePerspective(null, 45.0f, n, n2, 0.1f, 7000.0f);
        textRenderer.resetModelview(null);
        textRenderer.translate(null, this.getXTran(), this.getYTran(), this.getZoom());
        textRenderer.rotate(gL2ES2, this.getAngle(), 0.0f, 1.0f, 0.0f);
        textRenderer.setColorStatic(gL2ES2, 1.0f, 0.0f, 0.0f);
        if (!this.userInput) {
            textRenderer.drawString3D(gL2ES2, this.font, text2, this.getPosition(), this.fontSize, this.getTexSize());
        } else {
            textRenderer.drawString3D(gL2ES2, this.font, this.userString.toString(), this.getPosition(), this.fontSize, this.getTexSize());
        }
    }

    public void fontIncr(int n) {
        this.fontSize = Math.abs((this.fontSize + n) % 100);
        this.dumpMatrix(true);
    }

    public boolean nextFontSet() {
        try {
            int n = this.fontSet == 0 ? 1 : 0;
            Font font = FontFactory.get((int)n).getDefault();
            if (null != font) {
                this.fontSet = n;
                this.font = font;
                this.fontName = this.font.getFullFamilyName(null).toString();
                this.fontNameBox = this.font.getStringBounds((CharSequence)this.fontName, 18.0f);
                this.dumpFontNames();
                return true;
            }
        }
        catch (IOException iOException) {
            System.err.println("Catched: " + iOException.getMessage());
        }
        return false;
    }

    public boolean setFontSet(int n, int n2, int n3) {
        try {
            Font font = FontFactory.get((int)n).get(n2, n3);
            if (null != font) {
                this.fontSet = n;
                this.font = font;
                this.fontName = this.font.getFullFamilyName(null).toString();
                this.fontNameBox = this.font.getStringBounds((CharSequence)this.fontName, 18.0f);
                this.dumpFontNames();
                return true;
            }
        }
        catch (IOException iOException) {
            System.err.println("Catched: " + iOException.getMessage());
        }
        return false;
    }

    public boolean isUserInputMode() {
        return this.userInput;
    }

    void dumpMatrix(boolean bl) {
        System.err.println("Matrix: " + this.getXTran() + "/" + this.getYTran() + " x" + this.getZoom() + " @" + this.getAngle() + " fontSize " + this.fontSize);
        if (bl) {
            System.err.println("bbox: " + this.font.getStringBounds((CharSequence)text2, (float)this.fontSize));
        }
    }

    @Override
    public void attachInputListenerTo(GLWindow gLWindow) {
        if (null == this.keyAction) {
            this.keyAction = new KeyAction();
            gLWindow.addKeyListener((KeyListener)this.keyAction);
            super.attachInputListenerTo(gLWindow);
        }
    }

    @Override
    public void detachInputListenerFrom(GLWindow gLWindow) {
        super.detachInputListenerFrom(gLWindow);
        if (null == this.keyAction) {
            return;
        }
        gLWindow.removeKeyListener((KeyListener)this.keyAction);
    }

    public void printScreen(GLAutoDrawable gLAutoDrawable, String string, String string2, boolean bl) throws GLException, IOException {
        String string3 = this.font.getFullFamilyName(null).toString();
        this.printScreen(gLAutoDrawable, string, string2, string3.replace(' ', '_'), bl);
    }

    public class KeyAction
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
            if (GPUTextRendererListenerBase01.this.userInput) {
                return;
            }
            short s = keyEvent.getKeySymbol();
            if (s == 51) {
                GPUTextRendererListenerBase01.this.fontIncr(10);
            } else if (s == 52) {
                GPUTextRendererListenerBase01.this.fontIncr(-10);
            } else if (s == 72) {
                GPUTextRendererListenerBase01.this.switchHeadBox();
            } else if (s == 70) {
                GPUTextRendererListenerBase01.this.drawFPS = !GPUTextRendererListenerBase01.this.drawFPS;
            } else if (s == 32) {
                GPUTextRendererListenerBase01.this.nextFontSet();
            } else if (s == 73) {
                GPUTextRendererListenerBase01.this.userInput = true;
                GPUTextRendererListenerBase01.this.setIgnoreInput(true);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
                return;
            }
            if (GPUTextRendererListenerBase01.this.userInput) {
                short s = keyEvent.getKeySymbol();
                if (13 == s) {
                    GPUTextRendererListenerBase01.this.userInput = false;
                    GPUTextRendererListenerBase01.this.setIgnoreInput(false);
                } else if (8 == s && GPUTextRendererListenerBase01.this.userString.length() > 0) {
                    GPUTextRendererListenerBase01.this.userString.deleteCharAt(GPUTextRendererListenerBase01.this.userString.length() - 1);
                } else {
                    char c = keyEvent.getKeyChar();
                    if (GPUTextRendererListenerBase01.this.font.isPrintableChar(c)) {
                        GPUTextRendererListenerBase01.this.userString.append(c);
                    }
                }
            }
        }
    }
}

