/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT
extends UITestCase {
    static final int widthStep = 200;
    static final int heightStep = 150;
    static boolean waitForKey = false;
    volatile int szStep = 2;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable((String)string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get((String)string));
    }

    static void setGLCanvasSize(final Frame frame, final GLCanvas gLCanvas, final int n, final int n2) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Dimension dimension = new Dimension(n, n2);
                    gLCanvas.setMinimumSize(dimension);
                    gLCanvas.setPreferredSize(dimension);
                    gLCanvas.setSize(dimension);
                    frame.pack();
                    frame.validate();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    void doTest(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLEventListener gLEventListener) throws InterruptedException {
        if (gLCapabilitiesImmutable.isOnscreen() && JAWTUtil.isOffscreenLayerRequired()) {
            System.err.println("onscreen layer n/a");
            return;
        }
        if (!gLCapabilitiesImmutable.isOnscreen() && !JAWTUtil.isOffscreenLayerSupported()) {
            System.err.println("offscreen layer n/a");
            return;
        }
        System.out.println("Requested  GL Caps: " + gLCapabilitiesImmutable);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilitiesImmutable.getGLProfile());
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixGLCapabilities((GLCapabilitiesImmutable)gLCapabilitiesImmutable, (GLDrawableFactory)gLDrawableFactory, null);
        System.out.println("Expected   GL Caps: " + gLCapabilitiesImmutable2);
        final GLCanvas gLCanvas = new GLCanvas(gLCapabilitiesImmutable);
        Assert.assertNotNull((Object)gLCanvas);
        Dimension dimension = new Dimension(200 * this.szStep, 150 * this.szStep);
        gLCanvas.setMinimumSize(dimension);
        gLCanvas.setPreferredSize(dimension);
        gLCanvas.setSize(dimension);
        final Frame frame = new Frame(this.getSimpleTestName("."));
        Assert.assertNotNull((Object)frame);
        frame.add((Component)gLCanvas);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLCanvas, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLCanvas, true));
        System.out.println("Window: " + gLCanvas.getClass().getName());
        GLCapabilitiesImmutable gLCapabilitiesImmutable3 = gLCanvas.getChosenGLCapabilities();
        System.out.println("Window Caps Pre_GL: " + gLCapabilitiesImmutable3);
        Assert.assertNotNull((Object)gLCapabilitiesImmutable3);
        Assert.assertTrue((gLCapabilitiesImmutable3.getGreenBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable3.getBlueBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable3.getRedBits() > 5 ? 1 : 0) != 0);
        gLCanvas.display();
        GLDrawable gLDrawable = gLCanvas.getDelegatedDrawable();
        Assert.assertNotNull((Object)gLDrawable);
        System.out.println("Drawable    Pre-GL(0): " + gLDrawable.getClass().getName() + ", " + gLDrawable.getNativeSurface().getClass().getName());
        System.out.println("Window Caps PostGL   : " + gLCanvas.getChosenGLCapabilities());
        System.out.println("Drawable   Post-GL(1): " + gLCanvas.getClass().getName() + ", " + gLCanvas.getNativeSurface().getClass().getName());
        gLDrawable = gLCanvas.getChosenGLCapabilities();
        System.out.println("Chosen     GL Caps(1): " + gLDrawable);
        Assert.assertNotNull((Object)gLDrawable);
        Assert.assertTrue((gLDrawable.getGreenBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLDrawable.getBlueBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLDrawable.getRedBits() > 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLDrawable.getDepthBits() > 4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isOnscreen(), (Object)gLDrawable.isOnscreen());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isFBO(), (Object)gLDrawable.isFBO());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isPBuffer(), (Object)gLDrawable.isPBuffer());
        Assert.assertEquals((Object)gLCapabilitiesImmutable2.isBitmap(), (Object)gLDrawable.isBitmap());
        Object object = gLCanvas.getContext();
        System.out.println("Chosen     GL CTX (2): " + object.getGLVersion());
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)object.isCreated());
        System.out.println("Chosen     GL Caps(2): " + gLCanvas.getChosenGLCapabilities());
        System.out.println("Drawable   Post-GL(2): " + gLCanvas.getClass().getName() + ", " + gLCanvas.getNativeSurface().getClass().getName());
        gLCanvas.addGLEventListener(gLEventListener);
        object = new UITestCase.SnapshotGLEventListener(this);
        gLCanvas.addGLEventListener((GLEventListener)object);
        gLCanvas.display();
        Assert.assertTrue((String)("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLCanvas.getWidth() + "x" + gLCanvas.getHeight()), (boolean)AWTRobotUtil.waitForSize((GLDrawable)gLCanvas, 200 * this.szStep, 150 * this.szStep));
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        gLCanvas.display();
        this.szStep = 1;
        TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.setGLCanvasSize(frame, gLCanvas, 200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue((String)("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLCanvas.getWidth() + "x" + gLCanvas.getHeight()), (boolean)AWTRobotUtil.waitForSize((GLDrawable)gLCanvas, 200 * this.szStep, 150 * this.szStep));
        gLCanvas.display();
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        gLCanvas.display();
        this.szStep = 4;
        TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.setGLCanvasSize(frame, gLCanvas, 200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue((String)("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLCanvas.getWidth() + "x" + gLCanvas.getHeight()), (boolean)AWTRobotUtil.waitForSize((GLDrawable)gLCanvas, 200 * this.szStep, 150 * this.szStep));
        gLCanvas.display();
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        gLCanvas.display();
        Thread.sleep(50L);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(false);
                    frame.remove((Component)gLCanvas);
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        System.out.println("Fin: " + gLCanvas);
    }

    @Test
    public void testAvailableInfo() {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getDesktopFactory();
        if (null != gLDrawableFactory) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo((AbstractGraphicsDevice)gLDrawableFactory.getDefaultDevice(), null, (boolean)true).toString());
        }
        if (null != (gLDrawableFactory = GLDrawableFactory.getEGLFactory())) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo((AbstractGraphicsDevice)gLDrawableFactory.getDefaultDevice(), null, (boolean)true).toString());
        }
    }

    @Test
    public void testGL2OnScreenDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OnScreenDblBufStencil() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setStencilBits(1);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OnScreenDblBufMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OnScreenDblBufStencilMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setStencilBits(1);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenAutoDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBODblBufStencil() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setStencilBits(1);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBODblBufMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenFBODblBufStencilMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setStencilBits(1);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testGL2OffScreenPbuffer() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.getCaps("GL2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, new GearsES2(1));
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-wait")) continue;
            waitForKey = true;
        }
        if (waitForKey) {
            UITestCase.waitForKey("Start");
        }
        JUnitCore.main((String[])new String[]{TestGLAutoDrawableGLCanvasOnOffscrnCapsAWT.class.getName()});
    }

    static interface MyGLEventListener
    extends GLEventListener {
        public void setMakeSnapshot();
    }
}

