/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.nativewindow.NativeWindowVersion;
import com.jogamp.newt.NewtVersion;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.util.DumpGLInfo;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLProfile01NEWT
extends UITestCase {
    @Test
    public void testVersion() throws InterruptedException {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println(NativeWindowVersion.getInstance());
        System.err.println(JoglVersion.getInstance());
        System.err.println(NewtVersion.getInstance());
        System.err.println(JoglVersion.getDefaultOpenGLInfo(null, null, (boolean)true).toString());
    }

    @Test
    public void testGLProfileDefault() throws InterruptedException {
        System.out.println("GLProfile " + GLProfile.glAvailabilityToString());
        System.out.println("GLProfile.getDefaultDevice(): " + GLProfile.getDefaultDevice());
        GLProfile gLProfile = GLProfile.getDefault();
        System.out.println("GLProfile.getDefault(): " + gLProfile);
        if (gLProfile.getName().equals("GL4bc")) {
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL4bc"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL3bc"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES1"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES2"));
        } else if (gLProfile.getName().equals("GL3bc")) {
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL3bc"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES1"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES2"));
        } else if (gLProfile.getName().equals("GL2")) {
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES1"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES2"));
        } else if (gLProfile.getName().equals("GL2ES1")) {
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES1"));
        }
        this.dumpVersion(gLProfile);
    }

    @Test
    public void testGLProfileMaxProgrammable() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getMaxProgrammable((boolean)true);
        System.out.println("GLProfile.getMaxProgrammable(): " + gLProfile);
        if (gLProfile.getName().equals("GL4")) {
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL4"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL3"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES2"));
        } else if (gLProfile.getName().equals("GL3")) {
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL3"));
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES2"));
        } else if (gLProfile.getName().equals("GL2ES2")) {
            Assert.assertTrue((boolean)GLProfile.isAvailable((String)"GL2ES2"));
        }
        this.dumpVersion(gLProfile);
    }

    @Test
    public void testGLProfileGL2ES1() throws InterruptedException {
        if (!GLProfile.isAvailable((String)"GL2ES1")) {
            System.out.println("GLProfile GL2ES1 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES1();
        System.out.println("GLProfile GL2ES1: " + gLProfile);
        this.dumpVersion(gLProfile);
    }

    @Test
    public void testGLProfileGL2ES2() throws InterruptedException {
        if (!GLProfile.isAvailable((String)"GL2ES2")) {
            System.out.println("GLProfile GL2ES2 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES2();
        System.out.println("GLProfile GL2ES2: " + gLProfile);
        this.dumpVersion(gLProfile);
    }

    @Test
    public void testGLProfileGL4ES3() throws InterruptedException {
        if (!GLProfile.isAvailable((String)"GL4ES3")) {
            System.out.println("GLProfile GL4ES3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL4ES3();
        System.out.println("GLProfile GL4ES3: " + gLProfile);
        this.dumpVersion(gLProfile);
    }

    void testSpecificProfile(String string) throws InterruptedException {
        if (GLProfile.isAvailable((String)string)) {
            GLProfile gLProfile = GLProfile.get((String)string);
            this.dumpVersion(gLProfile);
        } else {
            System.err.println("Profile " + string + " n/a");
        }
    }

    @Test
    public void testGL4bc() throws InterruptedException {
        this.testSpecificProfile("GL4bc");
    }

    @Test
    public void testGL3bc() throws InterruptedException {
        this.testSpecificProfile("GL3bc");
    }

    @Test
    public void testGL2() throws InterruptedException {
        this.testSpecificProfile("GL2");
    }

    @Test
    public void testGL4() throws InterruptedException {
        this.testSpecificProfile("GL4");
    }

    @Test
    public void testGL3() throws InterruptedException {
        this.testSpecificProfile("GL3");
    }

    @Test
    public void testGLES1() throws InterruptedException {
        this.testSpecificProfile("GLES1");
    }

    @Test
    public void testGLES2() throws InterruptedException {
        this.testSpecificProfile("GLES2");
    }

    @Test
    public void testGLES3() throws InterruptedException {
        this.testSpecificProfile("GLES3");
    }

    protected void dumpVersion(GLProfile gLProfile) throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle("TestGLProfile01NEWT");
        gLWindow.addGLEventListener((GLEventListener)new DumpGLInfo());
        gLWindow.addGLEventListener(new GLEventListener(){

            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                GLProfile gLProfile = gL.getGLProfile();
                System.err.println("GL impl. class " + gL.getClass().getName());
                if (gL.isGL4()) {
                    Assert.assertNotNull((Object)gL.getGL4());
                    System.err.println("GL Mapping " + gLProfile + " -> GL4");
                }
                if (gL.isGL4bc()) {
                    Assert.assertNotNull((Object)gL.getGL4bc());
                    System.err.println("GL Mapping " + gLProfile + " -> GL4bc");
                }
                if (gL.isGL3()) {
                    Assert.assertNotNull((Object)gL.getGL3());
                    System.err.println("GL Mapping " + gLProfile + " -> GL3");
                }
                if (gL.isGL3bc()) {
                    Assert.assertNotNull((Object)gL.getGL3bc());
                    System.err.println("GL Mapping " + gLProfile + " -> GL3bc");
                }
                if (gL.isGLES3()) {
                    Assert.assertNotNull((Object)gL.getGLES3());
                    System.err.println("GL Mapping " + gLProfile + " -> GLES3");
                }
                if (gL.isGLES2()) {
                    Assert.assertNotNull((Object)gL.getGLES2());
                    System.err.println("GL Mapping " + gLProfile + " -> GLES2");
                }
                if (gL.isGL4ES3()) {
                    Assert.assertNotNull((Object)gL.getGL4ES3());
                    System.err.println("GL Mapping " + gLProfile + " -> GL4ES3");
                }
                if (gL.isGL2ES2()) {
                    Assert.assertNotNull((Object)gL.getGL2ES2());
                    System.err.println("GL Mapping " + gLProfile + " -> GL2ES2");
                }
                if (gL.isGL2ES1()) {
                    Assert.assertNotNull((Object)gL.getGL2ES1());
                    System.err.println("GL Mapping " + gLProfile + " -> GL2ES1");
                }
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        gLWindow.setSize(128, 128);
        gLWindow.setVisible(true);
        gLWindow.display();
        Thread.sleep(100L);
        gLWindow.destroy();
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestGLProfile01NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

