/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLBuffers;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLOffscreenAutoDrawable;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextNewtAWTBug523
extends UITestCase {
    static long durationPerTest = 1000L;
    private static int initializationCounter;
    private static Semaphore disposalCompleteSemaphore;
    private static volatile int[] sharedVertexBufferObjects;
    private static volatile int[] sharedIndexBufferObjects;
    private static final Set<String> errorSet;

    @BeforeClass
    public static void initClass() {
        if (!GLProfile.isAvailable((String)"GL2")) {
            TestSharedContextNewtAWTBug523.setTestSupported(false);
        }
    }

    private static GLOffscreenAutoDrawable initShared(GLCapabilities gLCapabilities) {
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = GLDrawableFactory.getFactory((GLProfile)gLCapabilities.getGLProfile()).createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, 64, 64);
        Assert.assertNotNull((Object)gLOffscreenAutoDrawable);
        gLOffscreenAutoDrawable.display();
        GLContext gLContext = gLOffscreenAutoDrawable.getContext();
        Assert.assertNotNull((String)"Shared drawable's ctx is null", (Object)gLContext);
        Assert.assertTrue((String)"Shared drawable's ctx is not created", (boolean)gLContext.isCreated());
        return gLOffscreenAutoDrawable;
    }

    private static void releaseShared(GLOffscreenAutoDrawable gLOffscreenAutoDrawable) {
        if (null != gLOffscreenAutoDrawable) {
            gLOffscreenAutoDrawable.destroy();
        }
    }

    public static void logAnyErrorCodes(Object object, GL gL, String string) {
        String string2;
        int n;
        String string3;
        int n2 = gL.glGetError();
        if (n2 != 0 && errorSet.add(string3 = "GL-Error: " + string + " on obj 0x" + Integer.toHexString(object.hashCode()) + ", OpenGL error: 0x" + Integer.toHexString(n2))) {
            System.err.println(string3);
            Thread.dumpStack();
        }
        if ((n = gL.glCheckFramebufferStatus(36160)) != 36053 && errorSet.add(string2 = "GL-Error: " + string + " on obj 0x" + Integer.toHexString(object.hashCode()) + ", glCheckFramebufferStatus: 0x" + Integer.toHexString(n))) {
            System.err.println(string2);
            Thread.dumpStack();
        }
    }

    public static float setupViewFrustum(GL2 gL2, int n, int n2, float f, float f2, float f3) {
        assert (f > 0.0f);
        assert (f2 > 0.0f);
        assert (f3 > 0.0f);
        GLU gLU = new GLU();
        float f4 = (float)n / (float)n2;
        float f5 = f / f2;
        float f6 = f4 > 1.0f ? f3 : f4 * f3;
        float f7 = (float)((double)f5 / Math.sin((double)f6 / 2.0 * (Math.PI / 180)));
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gLU.gluPerspective((double)f3, (double)f4, 0.1 * (double)f7, (double)(f7 + f5));
        return f7;
    }

    @Test
    public void test01UseAWTNotShared() throws InterruptedException, InvocationTargetException {
        this.testContextSharingCreateVisibleDestroy(false, false);
    }

    @Test
    public void test02UseAWTSharedContext() throws InterruptedException, InvocationTargetException {
        this.testContextSharingCreateVisibleDestroy(false, true);
    }

    @Test
    public void test10UseNEWTNotShared() throws InterruptedException, InvocationTargetException {
        this.testContextSharingCreateVisibleDestroy(true, false);
    }

    @Test
    public void test11UseNEWTSharedContext() throws InterruptedException, InvocationTargetException {
        this.testContextSharingCreateVisibleDestroy(true, true);
    }

    public void testContextSharingCreateVisibleDestroy(final boolean bl, boolean bl2) throws InterruptedException, InvocationTargetException {
        boolean bl3;
        NewtCanvasAWT newtCanvasAWT;
        Object object;
        NewtCanvasAWT newtCanvasAWT2;
        GLWindow gLWindow;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        final JFrame jFrame = new JFrame("Simple JOGL App for testing context sharing");
        AWTRobotUtil.WindowClosingListener windowClosingListener = AWTRobotUtil.addClosingListener(jFrame);
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get((String)"GL2"));
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = bl2 ? TestSharedContextNewtAWTBug523.initShared(gLCapabilities) : null;
        final TwoTriangles twoTriangles = new TwoTriangles(640, 480, bl2);
        final TwoTriangles twoTriangles2 = new TwoTriangles(320, 480, bl2);
        if (bl) {
            object5 = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
            if (bl2) {
                object5.setSharedAutoDrawable((GLAutoDrawable)gLOffscreenAutoDrawable);
            }
            object4 = new NewtCanvasAWT((Window)object5);
            object4.setPreferredSize(new Dimension(twoTriangles.canvasWidth, twoTriangles.canvasHeight));
            object5.addGLEventListener((GLEventListener)twoTriangles);
            object3 = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
            if (bl2) {
                object3.setSharedAutoDrawable((GLAutoDrawable)gLOffscreenAutoDrawable);
            }
            object2 = new NewtCanvasAWT((Window)object3);
            object2.setPreferredSize(new Dimension(twoTriangles2.canvasWidth, twoTriangles2.canvasHeight));
            object3.addGLEventListener((GLEventListener)twoTriangles2);
            gLWindow = object4;
            newtCanvasAWT2 = object2;
            object = object5;
            newtCanvasAWT = object3;
        } else {
            if (bl2) {
                object5 = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
                object5.setSharedAutoDrawable((GLAutoDrawable)gLOffscreenAutoDrawable);
                object4 = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
                object4.setSharedAutoDrawable((GLAutoDrawable)gLOffscreenAutoDrawable);
            } else {
                object5 = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
                object4 = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
            }
            object5.setSize(twoTriangles.canvasWidth, twoTriangles.canvasHeight);
            object5.addGLEventListener((GLEventListener)twoTriangles);
            object4.setSize(twoTriangles2.canvasWidth, twoTriangles2.canvasHeight);
            object4.addGLEventListener((GLEventListener)twoTriangles2);
            gLWindow = object5;
            newtCanvasAWT2 = object4;
            object = object5;
            newtCanvasAWT = object4;
        }
        object5 = new JSlider(1, -180, 180, 1);
        ((JSlider)object5).setPaintTicks(false);
        ((JSlider)object5).setPaintLabels(false);
        ((JSlider)object5).setSnapToTicks(false);
        ((JSlider)object5).addChangeListener(new ChangeListener((JSlider)object5, twoTriangles2){
            final /* synthetic */ JSlider val$xAxisRotationSlider;
            final /* synthetic */ TwoTriangles val$eventListener2;
            {
                this.val$xAxisRotationSlider = jSlider;
                this.val$eventListener2 = twoTriangles2;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                twoTriangles.setXAxisRotation(this.val$xAxisRotationSlider.getValue());
                this.val$eventListener2.setXAxisRotation(this.val$xAxisRotationSlider.getValue());
            }
        });
        object4 = new JLabel("X-Axis Rotation");
        object3 = new JSlider(0, -180, 180, 1);
        ((JSlider)object3).setPaintTicks(false);
        ((JSlider)object3).setPaintLabels(false);
        ((JSlider)object3).setSnapToTicks(false);
        ((JSlider)object3).addChangeListener(new ChangeListener((JSlider)object3, twoTriangles2){
            final /* synthetic */ JSlider val$yAxisRotationSlider;
            final /* synthetic */ TwoTriangles val$eventListener2;
            {
                this.val$yAxisRotationSlider = jSlider;
                this.val$eventListener2 = twoTriangles2;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                twoTriangles.setYAxisRotation(this.val$yAxisRotationSlider.getValue());
                this.val$eventListener2.setYAxisRotation(this.val$yAxisRotationSlider.getValue());
            }
        });
        object2 = new JLabel("Y-Axis Rotation");
        final JSlider jSlider = new JSlider(0, 0, 100, 10);
        jSlider.setPaintTicks(false);
        jSlider.setPaintLabels(false);
        jSlider.setSnapToTicks(false);
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                twoTriangles.setViewDistanceFactor((float)jSlider.getValue() / 10.0f);
                twoTriangles2.setViewDistanceFactor((float)jSlider.getValue() / 10.0f);
            }
        });
        JLabel jLabel = new JLabel("View Distance Factor");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jSlider);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add((Component)gLWindow);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)newtCanvasAWT2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 3));
        jPanel3.add(jPanel2);
        jPanel3.add(Box.createVerticalGlue());
        jPanel3.add((Component)object3);
        jPanel3.add((Component)object2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        jPanel4.add((Component)object5);
        jPanel4.add((Component)object4);
        JPanel jPanel5 = (JPanel)jFrame.getContentPane();
        jPanel5.setLayout(new BoxLayout(jPanel5, 2));
        jPanel5.add(jPanel);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(jPanel3);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(jPanel4);
        Animator animator = new Animator(Thread.currentThread().getThreadGroup());
        animator.setUpdateFPSFrames(1, null);
        animator.add((GLAutoDrawable)object);
        animator.add((GLAutoDrawable)newtCanvasAWT);
        final Semaphore semaphore = new Semaphore(0);
        final Semaphore semaphore2 = new Semaphore(0);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                semaphore2.release();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jFrame.pack();
                jFrame.setVisible(true);
                semaphore.release();
            }
        });
        try {
            bl3 = semaphore.tryAcquire(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)true, (Object)bl3);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Closing wait interrupted: " + interruptedException.getMessage());
        }
        animator.start();
        try {
            while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
                Thread.sleep(100L);
            }
            AWTRobotUtil.closeWindow(jFrame, true, windowClosingListener);
            bl3 = semaphore2.tryAcquire(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)true, (Object)bl3);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Closing wait interrupted: " + interruptedException.getMessage());
        }
        animator.stop();
        SwingUtilities.invokeLater(new Runnable((Component)gLWindow, (Component)newtCanvasAWT2, semaphore2){
            final /* synthetic */ Component val$openGLComponent1;
            final /* synthetic */ Component val$openGLComponent2;
            final /* synthetic */ Semaphore val$closingSemaphore;
            {
                this.val$openGLComponent1 = component;
                this.val$openGLComponent2 = component2;
                this.val$closingSemaphore = semaphore;
            }

            @Override
            public void run() {
                jFrame.setVisible(false);
                jFrame.dispose();
                if (bl) {
                    ((NewtCanvasAWT)this.val$openGLComponent1).destroy();
                    ((NewtCanvasAWT)this.val$openGLComponent2).destroy();
                }
                this.val$closingSemaphore.release();
            }
        });
        try {
            boolean bl4 = semaphore2.tryAcquire(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)true, (Object)bl4);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Closing wait interrupted: " + interruptedException.getMessage());
        }
        int n = 0;
        try {
            boolean bl5 = disposalCompleteSemaphore.tryAcquire(5000L, TimeUnit.MILLISECONDS);
            if (bl5) {
                ++n;
            }
            if (bl5 = disposalCompleteSemaphore.tryAcquire(5000L, TimeUnit.MILLISECONDS)) {
                ++n;
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Clean exit interrupted: " + interruptedException.getMessage());
        }
        Assert.assertEquals((Object)true, (Object)(n == 2 ? 1 : 0));
        TestSharedContextNewtAWTBug523.releaseShared(gLOffscreenAutoDrawable);
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time") || ++i >= stringArray.length) continue;
            durationPerTest = TestSharedContextNewtAWTBug523.atoi(stringArray[i]);
        }
        String string = TestSharedContextNewtAWTBug523.class.getName();
        JUnitTestRunner.main((String[])new String[]{string, "filtertrace=true", "haltOnError=false", "haltOnFailure=false", "showoutput=true", "outputtoformatters=true", "logfailedtests=true", "logtestlistenerevents=true", "formatter=org.apache.tools.ant.taskdefs.optional.junit.PlainJUnitResultFormatter", "formatter=org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter,TEST-" + string + ".xml"});
    }

    static {
        disposalCompleteSemaphore = new Semaphore(0);
        sharedVertexBufferObjects = new int[]{0};
        sharedIndexBufferObjects = new int[]{0};
        errorSet = new HashSet<String>();
    }

    static class TwoTriangles
    implements GLEventListener {
        boolean useShared;
        int canvasWidth;
        int canvasHeight;
        private final float boundsRadius = 2.0f;
        private float viewDistance;
        private float viewDistanceFactor = 1.0f;
        private float xAxisRotation;
        private float yAxisRotation;
        private final float viewFovDegrees = 15.0f;
        private final int[] privateVertexBufferObjects = new int[]{0};
        private final int[] privateIndexBufferObjects = new int[]{0};

        public static int createVertexBuffer(GL2 gL2) {
            FloatBuffer floatBuffer = GLBuffers.newDirectFloatBuffer((int)18);
            floatBuffer.put(new float[]{1.0f, -0.5f, 0.0f, 0.0f, 0.0f, 1.0f, 1.5f, -0.5f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f, 0.0f, 0.0f, 0.0f, 1.0f});
            floatBuffer.position(0);
            int[] nArray = new int[]{0};
            gL2.glGenBuffers(1, nArray, 0);
            gL2.glBindBuffer(34962, nArray[0]);
            gL2.glBufferData(34962, (long)(floatBuffer.capacity() * 4), (Buffer)floatBuffer, 35044);
            gL2.glBindBuffer(34962, 0);
            return nArray[0];
        }

        public static int createVertexIndexBuffer(GL2 gL2) {
            IntBuffer intBuffer = GLBuffers.newDirectIntBuffer((int)3);
            intBuffer.put(new int[]{0, 1, 2});
            intBuffer.position(0);
            int[] nArray = new int[]{0};
            gL2.glGenBuffers(1, nArray, 0);
            gL2.glBindBuffer(34963, nArray[0]);
            gL2.glBufferData(34963, (long)(intBuffer.capacity() * 4), (Buffer)intBuffer, 35044);
            gL2.glBindBuffer(34963, 0);
            return nArray[0];
        }

        TwoTriangles(int n, int n2, boolean bl) {
            this.canvasWidth = n;
            this.canvasHeight = n2;
            this.useShared = bl;
        }

        public void setXAxisRotation(float f) {
            this.xAxisRotation = f;
        }

        public void setYAxisRotation(float f) {
            this.yAxisRotation = f;
        }

        public void setViewDistanceFactor(float f) {
            this.viewDistanceFactor = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            System.err.println("INIT GL IS: " + gL2.getClass().getName());
            gL2.setSwapInterval(0);
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            TwoTriangles twoTriangles = this;
            synchronized (twoTriangles) {
                int[] nArray;
                int[] nArray2;
                if (this.useShared) {
                    System.err.println("Using shared VBOs on slave 0x" + Integer.toHexString(this.hashCode()));
                    nArray2 = sharedVertexBufferObjects;
                    nArray = sharedIndexBufferObjects;
                } else {
                    System.err.println("Using local VBOs on slave 0x" + Integer.toHexString(this.hashCode()));
                    nArray2 = this.privateVertexBufferObjects;
                    nArray = this.privateIndexBufferObjects;
                }
                if (nArray2[0] == 0) {
                    System.err.println("Creating vertex VBO on slave 0x" + Integer.toHexString(this.hashCode()));
                    nArray2[0] = TwoTriangles.createVertexBuffer(gL2);
                }
                if (gL2.glIsBuffer(nArray2[0])) {
                    gL2.glBindBuffer(34962, nArray2[0]);
                    gL2.glEnableClientState(32884);
                    gL2.glVertexPointer(3, 5126, 24, 0L);
                    gL2.glEnableClientState(32885);
                    gL2.glNormalPointer(5126, 24, 12L);
                } else {
                    System.err.println("Vertex VBO is not a buffer on slave 0x" + Integer.toHexString(this.hashCode()));
                }
                if (nArray[0] == 0) {
                    System.err.println("Creating index VBO on slave 0x" + Integer.toHexString(this.hashCode()));
                    nArray[0] = TwoTriangles.createVertexIndexBuffer(gL2);
                }
                if (gL2.glIsBuffer(nArray[0])) {
                    gL2.glBindBuffer(34963, nArray[0]);
                } else {
                    System.err.println("Index VBO is not a buffer on slave 0x" + Integer.toHexString(this.hashCode()));
                }
                gL2.glBindBuffer(34963, 0);
                gL2.glBindBuffer(34962, 0);
                gL2.glDisableClientState(32884);
                gL2.glDisableClientState(32885);
                initializationCounter++;
            }
            this.viewDistance = TestSharedContextNewtAWTBug523.setupViewFrustum(gL2, this.canvasWidth, this.canvasHeight, 2.0f, 1.0f, 15.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            TwoTriangles twoTriangles = this;
            synchronized (twoTriangles) {
                initializationCounter--;
                GL2 gL2 = gLAutoDrawable.getGL().getGL2();
                if (initializationCounter == 0 || !this.useShared) {
                    int[] nArray;
                    int[] nArray2;
                    if (this.useShared) {
                        nArray2 = sharedVertexBufferObjects;
                        nArray = sharedIndexBufferObjects;
                    } else {
                        nArray2 = this.privateVertexBufferObjects;
                        nArray = this.privateIndexBufferObjects;
                    }
                    gL2.glDeleteBuffers(1, nArray2, 0);
                    TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, (GL)gL2, "dispose.2");
                    gL2.glDeleteBuffers(1, nArray, 0);
                    TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, (GL)gL2, "dispose.3");
                    nArray2[0] = 0;
                    nArray[0] = 0;
                }
                disposalCompleteSemaphore.release();
            }
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void display(GLAutoDrawable gLAutoDrawable) {
            TwoTriangles twoTriangles = this;
            synchronized (twoTriangles) {
                if (initializationCounter != 2) {
                    return;
                }
            }
            twoTriangles = gLAutoDrawable.getGL().getGL2();
            GLU gLU = new GLU();
            TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, (GL)twoTriangles, "display.0");
            twoTriangles.glClear(16640);
            twoTriangles.glViewport(0, 0, this.canvasWidth, this.canvasHeight);
            twoTriangles.glMatrixMode(5889);
            twoTriangles.glLoadIdentity();
            gLU.gluPerspective(15.0f, (float)this.canvasWidth / (float)this.canvasHeight, this.viewDistance * this.viewDistanceFactor - 2.0f, this.viewDistance * this.viewDistanceFactor + 2.0f);
            twoTriangles.glMatrixMode(5888);
            twoTriangles.glLoadIdentity();
            twoTriangles.glPushAttrib(1048575);
            twoTriangles.glPushMatrix();
            gLU.gluLookAt(0.0f, 0.0f, 0.0f + this.viewDistance * this.viewDistanceFactor, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
            twoTriangles.glRotatef(this.xAxisRotation, 1.0f, 0.0f, 0.0f);
            twoTriangles.glRotatef(this.yAxisRotation, 0.0f, 1.0f, 0.0f);
            twoTriangles.glDisable(2884);
            twoTriangles.glEnable(2929);
            TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, (GL)twoTriangles, "display.1");
            this.drawTwoTriangles((GL2)twoTriangles);
            twoTriangles.glPopMatrix();
            twoTriangles.glPopAttrib();
            twoTriangles.glFlush();
            TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, (GL)twoTriangles, "display.X");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawTwoTriangles(GL2 gL2) {
            boolean bl;
            int[] nArray;
            int[] nArray2;
            gL2.glColor3f(1.0f, 0.0f, 0.0f);
            gL2.glBegin(4);
            gL2.glVertex3d(-1.5, -0.5, 0.0);
            gL2.glNormal3d(0.0, 0.0, 1.0);
            gL2.glVertex3d(-0.5, -0.5, 0.0);
            gL2.glNormal3d(0.0, 0.0, 1.0);
            gL2.glVertex3d(-0.75, 0.5, 0.0);
            gL2.glNormal3d(0.0, 0.0, 1.0);
            gL2.glEnd();
            TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, (GL)gL2, "drawTwoTriangles.1");
            boolean bl2 = false;
            TwoTriangles twoTriangles = this;
            synchronized (twoTriangles) {
                if (this.useShared) {
                    nArray2 = sharedVertexBufferObjects;
                    nArray = sharedIndexBufferObjects;
                } else {
                    nArray2 = this.privateVertexBufferObjects;
                    nArray = this.privateIndexBufferObjects;
                }
            }
            boolean bl3 = gL2.glIsBuffer(nArray[0]);
            boolean bl4 = gL2.glIsBuffer(nArray2[0]);
            boolean bl5 = bl = bl3 && bl4;
            if (bl) {
                gL2.glBindBuffer(34962, nArray2[0]);
                gL2.glBindBuffer(34963, nArray[0]);
                gL2.glEnableClientState(32884);
                gL2.glEnableClientState(32885);
                bl2 = true;
            }
            TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, (GL)gL2, "drawTwoTriangles.2");
            if (bl2) {
                gL2.glColor3f(0.0f, 0.0f, 1.0f);
                gL2.glDrawElements(4, 3, 5125, 0L);
                gL2.glBindBuffer(34962, 0);
                gL2.glBindBuffer(34963, 0);
                gL2.glDisableClientState(32884);
                gL2.glDisableClientState(32885);
            }
            TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, (GL)gL2, "drawTwoTriangles.3");
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }
}

