/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextVBOES2AWT3
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable((String)"GL2ES2")) {
            glp = GLProfile.get((String)"GL2ES2");
            Assert.assertNotNull((Object)glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull((Object)caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextVBOES2AWT3.setTestSupported(false);
        }
    }

    protected GLCanvas createGLCanvas(Frame frame, int n, int n2, GearsES2 gearsES2) throws InterruptedException {
        GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)caps);
        Assert.assertNotNull((Object)gLCanvas);
        gLCanvas.addGLEventListener((GLEventListener)gearsES2);
        frame.add((Component)gLCanvas);
        frame.setLocation(n, n2);
        frame.setSize(width, height);
        frame.setTitle("AWT GLCanvas Shared Gears Test: " + n + "/" + n2 + " shared true");
        return gLCanvas;
    }

    @Test
    public void test01SyncedOneAnimatorCleanDtorOrder() throws InterruptedException, InvocationTargetException {
        this.syncedOneAnimator(true);
    }

    @Test
    public void test02SyncedOneAnimatorDirtyDtorOrder() throws InterruptedException, InvocationTargetException {
        this.syncedOneAnimator(false);
    }

    public void syncedOneAnimator(final boolean bl) throws InterruptedException, InvocationTargetException {
        final Frame frame = new Frame();
        Animator animator = new Animator();
        GearsES2 gearsES2 = new GearsES2(0);
        GLCanvas gLCanvas = this.createGLCanvas(frame, 0, 0, gearsES2);
        animator.add((GLAutoDrawable)gLCanvas);
        final Frame frame2 = new Frame();
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGears(gearsES2);
        GLCanvas gLCanvas2 = this.createGLCanvas(frame2, frame.getX() + width, frame.getY() + 0, gearsES22);
        gLCanvas2.setSharedAutoDrawable((GLAutoDrawable)gLCanvas);
        animator.add((GLAutoDrawable)gLCanvas2);
        final Frame frame3 = new Frame();
        GearsES2 gearsES23 = new GearsES2(0);
        gearsES23.setSharedGears(gearsES2);
        GLCanvas gLCanvas3 = this.createGLCanvas(frame3, frame.getX() + 0, frame.getY() + height, gearsES23);
        gLCanvas3.setSharedAutoDrawable((GLAutoDrawable)gLCanvas);
        animator.add((GLAutoDrawable)gLCanvas3);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame2.setVisible(true);
                frame.setVisible(true);
                frame3.setVisible(true);
            }
        });
        animator.start();
        Thread.sleep(160L);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLCanvas, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLCanvas, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated((GLAutoDrawable)gLCanvas, true));
        Assert.assertTrue((String)"Gears1 not initialized", (boolean)gearsES2.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLCanvas2, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLCanvas2, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated((GLAutoDrawable)gLCanvas2, true));
        Assert.assertTrue((String)"Gears2 not initialized", (boolean)gearsES22.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLCanvas3, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLCanvas3, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated((GLAutoDrawable)gLCanvas3, true));
        Assert.assertTrue((String)"Gears3 not initialized", (boolean)gearsES23.waitForInit(true));
        GLContext gLContext = gLCanvas.getContext();
        GLContext gLContext2 = gLCanvas2.getContext();
        GLContext gLContext3 = gLCanvas3.getContext();
        List list = gLContext.getCreatedShares();
        List list2 = gLContext2.getCreatedShares();
        List list3 = gLContext3.getCreatedShares();
        System.err.println("XXX-C-3.1:");
        MiscUtils.dumpSharedGLContext(gLContext);
        System.err.println("XXX-C-3.2:");
        MiscUtils.dumpSharedGLContext(gLContext2);
        System.err.println("XXX-C-3.3:");
        MiscUtils.dumpSharedGLContext(gLContext3);
        Assert.assertTrue((String)"Ctx1 is not shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is not shared", (boolean)gLContext2.isShared());
        Assert.assertTrue((String)"Ctx3 is not shared", (boolean)gLContext3.isShared());
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)2L, (long)list.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)2L, (long)list2.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)2L, (long)list3.size());
        Assert.assertTrue((String)"Gears1 is shared", (!gearsES2.usesSharedGears() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Gears2 is not shared", (boolean)gearsES22.usesSharedGears());
        Assert.assertTrue((String)"Gears3 is not shared", (boolean)gearsES23.usesSharedGears());
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        if (bl) {
            System.err.println("XXX Destroy in clean order NOW");
        } else {
            System.err.println("XXX Destroy in creation order NOW - Driver Impl. Ma trigger driver Bug i.e. not postponing GL ctx destruction after releasing all refs.");
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    if (bl) {
                        frame3.dispose();
                    } else {
                        frame.dispose();
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    if (bl) {
                        frame2.dispose();
                    } else {
                        frame2.dispose();
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    if (bl) {
                        frame.dispose();
                    } else {
                        frame3.dispose();
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLCanvas, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLCanvas2, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLCanvas3, false));
    }

    @Test
    public void test11AsyncEachAnimatorCleanDtorOrder() throws InterruptedException, InvocationTargetException {
        this.syncedOneAnimator(true);
    }

    @Test
    public void test12AsyncEachAnimatorDirtyDtorOrder() throws InterruptedException, InvocationTargetException {
        this.asyncEachOneAnimator(false);
    }

    public void asyncEachOneAnimator(final boolean bl) throws InterruptedException, InvocationTargetException {
        final Frame frame = new Frame();
        Animator animator = new Animator();
        GearsES2 gearsES2 = new GearsES2(0);
        GLCanvas gLCanvas = this.createGLCanvas(frame, 0, 0, gearsES2);
        animator.add((GLAutoDrawable)gLCanvas);
        animator.start();
        final Frame frame2 = new Frame();
        Animator animator2 = new Animator();
        GearsES2 gearsES22 = new GearsES2(0);
        gearsES22.setSharedGears(gearsES2);
        GLCanvas gLCanvas2 = this.createGLCanvas(frame2, frame.getX() + width, frame.getY() + 0, gearsES22);
        gLCanvas2.setSharedAutoDrawable((GLAutoDrawable)gLCanvas);
        animator2.add((GLAutoDrawable)gLCanvas2);
        animator2.start();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame2.setVisible(true);
            }
        });
        Thread.sleep(200L);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
        final Frame frame3 = new Frame();
        Animator animator3 = new Animator();
        GearsES2 gearsES23 = new GearsES2(0);
        gearsES23.setSharedGears(gearsES2);
        GLCanvas gLCanvas3 = this.createGLCanvas(frame3, frame.getX() + 0, frame.getY() + height, gearsES23);
        gLCanvas3.setSharedAutoDrawable((GLAutoDrawable)gLCanvas);
        animator3.add((GLAutoDrawable)gLCanvas3);
        animator3.start();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame3.setVisible(true);
            }
        });
        Thread.sleep(160L);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLCanvas, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLCanvas, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated((GLAutoDrawable)gLCanvas, true));
        Assert.assertTrue((String)"Gears1 not initialized", (boolean)gearsES2.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLCanvas2, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLCanvas2, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated((GLAutoDrawable)gLCanvas2, true));
        Assert.assertTrue((String)"Gears2 not initialized", (boolean)gearsES22.waitForInit(true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLCanvas3, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLCanvas3, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForContextCreated((GLAutoDrawable)gLCanvas3, true));
        Assert.assertTrue((String)"Gears3 not initialized", (boolean)gearsES23.waitForInit(true));
        GLContext gLContext = gLCanvas.getContext();
        GLContext gLContext2 = gLCanvas2.getContext();
        GLContext gLContext3 = gLCanvas3.getContext();
        List list = gLContext.getCreatedShares();
        List list2 = gLContext2.getCreatedShares();
        List list3 = gLContext3.getCreatedShares();
        System.err.println("XXX-C-3.1:");
        MiscUtils.dumpSharedGLContext(gLContext);
        System.err.println("XXX-C-3.2:");
        MiscUtils.dumpSharedGLContext(gLContext2);
        System.err.println("XXX-C-3.3:");
        MiscUtils.dumpSharedGLContext(gLContext3);
        Assert.assertTrue((String)"Ctx1 is not shared", (boolean)gLContext.isShared());
        Assert.assertTrue((String)"Ctx2 is not shared", (boolean)gLContext2.isShared());
        Assert.assertTrue((String)"Ctx3 is not shared", (boolean)gLContext3.isShared());
        Assert.assertEquals((String)"Ctx1 has unexpected number of created shares", (long)2L, (long)list.size());
        Assert.assertEquals((String)"Ctx2 has unexpected number of created shares", (long)2L, (long)list2.size());
        Assert.assertEquals((String)"Ctx3 has unexpected number of created shares", (long)2L, (long)list3.size());
        Assert.assertTrue((String)"Gears1 is shared", (!gearsES2.usesSharedGears() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Gears2 is not shared", (boolean)gearsES22.usesSharedGears());
        Assert.assertTrue((String)"Gears3 is not shared", (boolean)gearsES23.usesSharedGears());
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        animator2.stop();
        Assert.assertEquals((Object)false, (Object)animator2.isAnimating());
        animator3.stop();
        Assert.assertEquals((Object)false, (Object)animator3.isAnimating());
        if (bl) {
            System.err.println("XXX Destroy in clean order NOW");
        } else {
            System.err.println("XXX Destroy in creation order NOW - Driver Impl. Ma trigger driver Bug i.e. not postponing GL ctx destruction after releasing all refs.");
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    if (bl) {
                        frame3.dispose();
                    } else {
                        frame.dispose();
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    if (bl) {
                        frame2.dispose();
                    } else {
                        frame2.dispose();
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    if (bl) {
                        frame.dispose();
                    } else {
                        frame3.dispose();
                    }
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        });
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLCanvas, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLCanvas2, false));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLCanvas3, false));
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestSharedContextVBOES2AWT3.class.getName()});
    }

    static {
        duration = 1000L;
    }
}

