/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.ect;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.opengl.test.junit.jogl.acore.ect.ExclusiveContextBase00;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.awt.GLCanvas;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class ExclusiveContextBase00AWT
extends ExclusiveContextBase00 {
    static Thread awtEDT;
    static boolean osxCALayerAWTModBug;

    @BeforeClass
    public static void initClass00AWT() {
        VersionNumber versionNumber = new VersionNumber(1, 7, 0);
        osxCALayerAWTModBug = Platform.OSType.MACOS == Platform.getOSType() && 0 > Platform.getJavaVersionNumber().compareTo(versionNumber);
        System.err.println("OSX CALayer AWT-Mod Bug " + osxCALayerAWTModBug);
        System.err.println("OSType " + Platform.getOSType());
        System.err.println("Java Version " + Platform.getJavaVersionNumber());
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    awtEDT = Thread.currentThread();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.assertNull((Object)exception);
        }
    }

    @AfterClass
    public static void releaseClass00AWT() {
    }

    @Override
    protected boolean isAWTTestCase() {
        return true;
    }

    @Override
    protected Thread getAWTRenderThread() {
        return awtEDT;
    }

    @Override
    protected GLAutoDrawable createGLAutoDrawable(final String string, final int n, final int n2, final int n3, final int n4, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        final GLCanvas gLCanvas = new GLCanvas();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Frame frame = new Frame();
                    frame.setLayout(new BorderLayout());
                    frame.setMinimumSize(new Dimension(n3, n4));
                    frame.setBounds(n, n2, n3, n4);
                    frame.add((Component)gLCanvas, "Center");
                    frame.validate();
                    if (!osxCALayerAWTModBug) {
                        frame.setTitle(string);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.assertNull((Object)exception);
        }
        return gLCanvas;
    }

    protected Frame getFrame(GLAutoDrawable gLAutoDrawable) {
        Container container;
        for (container = ((Component)gLAutoDrawable).getParent(); null != container && !(container instanceof Frame); container = container.getParent()) {
        }
        return (Frame)container;
    }

    @Override
    protected void setGLAutoDrawableVisible(final GLAutoDrawable[] gLAutoDrawableArray) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    for (GLAutoDrawable gLAutoDrawable : gLAutoDrawableArray) {
                        Frame frame = ExclusiveContextBase00AWT.this.getFrame(gLAutoDrawable);
                        frame.setVisible(true);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.assertNull((Object)exception);
        }
    }

    @Override
    protected void destroyGLAutoDrawableVisible(GLAutoDrawable gLAutoDrawable) {
        final Frame frame = this.getFrame(gLAutoDrawable);
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.dispose();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.assertNull((Object)exception);
        }
    }
}

