/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.ect;

import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Window;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.AnimatorBase;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class ExclusiveContextBase10
extends UITestCase {
    static boolean testExclusiveWithAWT = false;
    static long duration = 1400L;
    static boolean showFPS = true;
    static int showFPSRate = 60;
    static final int demoSize = 128;
    static InsetsImmutable insets = null;
    static int scrnHeight;
    static int scrnWidth;
    static int num_x;
    static int num_y;
    static int swapInterval;

    @BeforeClass
    public static void initClass00() {
        Window window = NewtFactory.createWindow((CapabilitiesImmutable)new Capabilities());
        window.setSize(128, 128);
        window.setVisible(true);
        Assert.assertEquals((Object)true, (Object)window.isVisible());
        Assert.assertEquals((Object)true, (Object)window.isNativeValid());
        insets = window.getInsets();
        scrnHeight = window.getScreen().getHeight();
        scrnWidth = window.getScreen().getWidth();
        num_x = scrnWidth / (128 + insets.getTotalWidth()) - 2;
        num_y = scrnHeight / (128 + insets.getTotalHeight()) - 2;
        window.destroy();
    }

    @AfterClass
    public static void releaseClass00() {
    }

    protected abstract boolean isAWTTestCase();

    protected abstract Thread getAWTRenderThread();

    protected abstract AnimatorBase createAnimator();

    protected abstract GLAutoDrawable createGLAutoDrawable(String var1, int var2, int var3, int var4, int var5, GLCapabilitiesImmutable var6);

    protected abstract void setGLAutoDrawableVisible(GLAutoDrawable[] var1);

    protected abstract void destroyGLAutoDrawableVisible(GLAutoDrawable var1);

    protected void runTestGL(GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, boolean bl) throws InterruptedException {
        int n2;
        int n3;
        boolean bl2 = this.isAWTTestCase();
        if (bl2 && bl) {
            if (testExclusiveWithAWT) {
                System.err.println("Warning: Testing AWT + Exclusive -> Not advised!");
            } else {
                System.err.println("Info: Skip test: AWT + Exclusive!");
                return;
            }
        }
        if (bl2 && bl && !testExclusiveWithAWT) {
            System.err.println("Skip test: AWT + Exclusive -> Not advised!");
            return;
        }
        Thread thread = this.getAWTRenderThread();
        AnimatorBase animatorBase = this.createAnimator();
        if (!bl2) {
            animatorBase.setModeBits(false, 1);
        }
        GLAutoDrawable[] gLAutoDrawableArray = new GLAutoDrawable[n];
        for (n3 = 0; n3 < n; ++n3) {
            n2 = n3 % num_x * (128 + insets.getTotalHeight()) + insets.getLeftWidth();
            int n4 = n3 / num_x % num_y * (128 + insets.getTotalHeight()) + insets.getTopHeight();
            gLAutoDrawableArray[n3] = this.createGLAutoDrawable("Win #" + n3, n2, n4, 128, 128, gLCapabilitiesImmutable);
            Assert.assertNotNull((Object)gLAutoDrawableArray[n3]);
            GearsES2 gearsES2 = new GearsES2(swapInterval);
            gearsES2.setVerbose(false);
            gLAutoDrawableArray[n3].addGLEventListener((GLEventListener)gearsES2);
        }
        for (n3 = 0; n3 < n; ++n3) {
            animatorBase.add(gLAutoDrawableArray[n3]);
        }
        if (bl) {
            if (bl2) {
                Assert.assertEquals(null, (Object)animatorBase.setExclusiveContext(thread));
            } else {
                Assert.assertEquals((Object)false, (Object)animatorBase.setExclusiveContext(true));
            }
        }
        Assert.assertFalse((boolean)animatorBase.isAnimating());
        Assert.assertFalse((boolean)animatorBase.isStarted());
        Assert.assertTrue((boolean)animatorBase.start());
        Assert.assertTrue((boolean)animatorBase.isStarted());
        Assert.assertTrue((boolean)animatorBase.isAnimating());
        Assert.assertEquals((Object)bl, (Object)animatorBase.isExclusiveContextEnabled());
        Thread thread2 = animatorBase.getExclusiveContextThread();
        if (bl) {
            if (bl2) {
                Assert.assertEquals((Object)thread, (Object)thread2);
            } else {
                Assert.assertEquals((Object)animatorBase.getThread(), (Object)thread2);
            }
        } else {
            Assert.assertEquals(null, (Object)thread2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            Assert.assertEquals((Object)thread2, (Object)gLAutoDrawableArray[n2].getExclusiveContextThread());
        }
        this.setGLAutoDrawableVisible(gLAutoDrawableArray);
        animatorBase.setUpdateFPSFrames(showFPSRate, showFPS ? System.err : null);
        Thread.sleep(duration);
        Assert.assertTrue((boolean)animatorBase.stop());
        Assert.assertFalse((boolean)animatorBase.isAnimating());
        Assert.assertFalse((boolean)animatorBase.isStarted());
        Assert.assertFalse((boolean)animatorBase.isPaused());
        Assert.assertEquals((Object)bl, (Object)animatorBase.isExclusiveContextEnabled());
        Assert.assertEquals(null, (Object)animatorBase.getExclusiveContextThread());
        for (int i = 0; i < n; ++i) {
            this.destroyGLAutoDrawableVisible(gLAutoDrawableArray[i]);
            Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLAutoDrawableArray[i], false));
        }
    }

    @Test
    public void test01Normal_1Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 1, false);
    }

    @Test
    public void test03Excl_1Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 1, true);
    }

    @Test
    public void test05Normal_4Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 4, false);
    }

    @Test
    public void test07Excl_4Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 4, true);
    }

    static {
        swapInterval = 0;
    }
}

