/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.FPSAnimator;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestAWTCardLayoutAnimatorStartStopBug532
extends UITestCase {
    static final String LABEL = "Label";
    static final String CANVAS = "GLCanvas";
    static long durationPerTest = 800L;
    static boolean manual = false;
    static volatile boolean shouldStop = false;
    private String selected = "Label";

    @Test
    public void testFPSAnimatorStartStop() throws InterruptedException, InvocationTargetException {
        this.testImpl(AnimatorControlBehavior.StartStop, true);
    }

    @Test
    public void testFPSAnimatorResumePause() throws InterruptedException, InvocationTargetException {
        this.testImpl(AnimatorControlBehavior.PauseResume, true);
    }

    @Test
    public void testFPSAnimatorContinue() throws InterruptedException, InvocationTargetException {
        this.testImpl(AnimatorControlBehavior.Continue, true);
    }

    @Test
    public void testAnimatorStartStop() throws InterruptedException, InvocationTargetException {
        this.testImpl(AnimatorControlBehavior.StartStop, false);
    }

    @Test
    public void testAnimatorResumePause() throws InterruptedException, InvocationTargetException {
        this.testImpl(AnimatorControlBehavior.PauseResume, false);
    }

    @Test
    public void testAnimatorContinue() throws InterruptedException, InvocationTargetException {
        this.testImpl(AnimatorControlBehavior.Continue, false);
    }

    void testImpl(final AnimatorControlBehavior animatorControlBehavior, boolean bl) throws InterruptedException, InvocationTargetException {
        GLProfile gLProfile = GLProfile.get((String)"GL2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        gLCanvas.setPreferredSize(new Dimension(640, 480));
        FPSAnimator fPSAnimator = bl ? new FPSAnimator((GLAutoDrawable)gLCanvas, 60) : new Animator((GLAutoDrawable)gLCanvas);
        fPSAnimator.setUpdateFPSFrames(60, null);
        switch (animatorControlBehavior) {
            case PauseResume: {
                fPSAnimator.start();
                fPSAnimator.pause();
                break;
            }
            case Continue: {
                fPSAnimator.start();
                break;
            }
        }
        gLCanvas.addGLEventListener((GLEventListener)new GearsES2(1));
        final JFrame jFrame = new JFrame();
        jFrame.setTitle(this.getSimpleTestName(" - "));
        jFrame.addWindowListener(new WindowAdapter((GLAnimatorControl)fPSAnimator){
            final /* synthetic */ GLAnimatorControl val$animatorCtrl;
            {
                this.val$animatorCtrl = gLAnimatorControl;
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                this.val$animatorCtrl.stop();
                shouldStop = true;
            }
        });
        jFrame.setDefaultCloseOperation(2);
        final JPanel jPanel = new JPanel(new CardLayout());
        JPanel jPanel2 = new JPanel();
        final JComboBox<String> jComboBox = new JComboBox<String>(new String[]{LABEL, CANVAS});
        jComboBox.setEditable(false);
        jComboBox.addItemListener(new ItemListener((GLAnimatorControl)fPSAnimator){
            final /* synthetic */ GLAnimatorControl val$animatorCtrl;
            {
                this.val$animatorCtrl = gLAnimatorControl;
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CardLayout cardLayout = (CardLayout)jPanel.getLayout();
                String string = (String)itemEvent.getItem();
                if (!string.equals(TestAWTCardLayoutAnimatorStartStopBug532.this.selected)) {
                    String string2 = TestAWTCardLayoutAnimatorStartStopBug532.this.selected;
                    if (string.equals(TestAWTCardLayoutAnimatorStartStopBug532.CANVAS)) {
                        cardLayout.show(jPanel, TestAWTCardLayoutAnimatorStartStopBug532.CANVAS);
                        switch (animatorControlBehavior) {
                            case StartStop: {
                                this.val$animatorCtrl.start();
                                break;
                            }
                            case PauseResume: {
                                this.val$animatorCtrl.resume();
                                break;
                            }
                        }
                        TestAWTCardLayoutAnimatorStartStopBug532.this.selected = TestAWTCardLayoutAnimatorStartStopBug532.CANVAS;
                    } else if (string.equals(TestAWTCardLayoutAnimatorStartStopBug532.LABEL)) {
                        switch (animatorControlBehavior) {
                            case StartStop: {
                                this.val$animatorCtrl.stop();
                                break;
                            }
                            case PauseResume: {
                                this.val$animatorCtrl.pause();
                                break;
                            }
                        }
                        cardLayout.show(jPanel, TestAWTCardLayoutAnimatorStartStopBug532.LABEL);
                        TestAWTCardLayoutAnimatorStartStopBug532.this.selected = TestAWTCardLayoutAnimatorStartStopBug532.LABEL;
                    } else {
                        throw new RuntimeException("oops .. unexpected item: " + itemEvent);
                    }
                    System.err.println("Item Change: " + string2 + " -> " + TestAWTCardLayoutAnimatorStartStopBug532.this.selected + ", " + this.val$animatorCtrl);
                } else {
                    System.err.println("Item Stays: " + TestAWTCardLayoutAnimatorStartStopBug532.this.selected + ", " + this.val$animatorCtrl);
                }
            }
        });
        jPanel2.add(jComboBox);
        jPanel.add((Component)new JLabel("A label to cover the canvas"), LABEL);
        jPanel.add((Component)gLCanvas, CANVAS);
        jFrame.add((Component)jPanel2, "First");
        jFrame.add((Component)jPanel, "Center");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
        if (manual) {
            for (long i = durationPerTest; !shouldStop && i > 0L; i -= 100L) {
                Thread.sleep(100L);
            }
        } else {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jComboBox.setSelectedItem(TestAWTCardLayoutAnimatorStartStopBug532.LABEL);
                }
            });
            Thread.sleep(durationPerTest / 4L);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jComboBox.setSelectedItem(TestAWTCardLayoutAnimatorStartStopBug532.CANVAS);
                }
            });
            Thread.sleep(durationPerTest / 4L);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jComboBox.setSelectedItem(TestAWTCardLayoutAnimatorStartStopBug532.LABEL);
                }
            });
            Thread.sleep(durationPerTest / 4L);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jComboBox.setSelectedItem(TestAWTCardLayoutAnimatorStartStopBug532.CANVAS);
                }
            });
            Thread.sleep(durationPerTest / 4L);
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(false);
                jFrame.dispose();
            }
        });
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                durationPerTest = MiscUtils.atoi(stringArray[++i], (int)durationPerTest);
                continue;
            }
            if (!stringArray[i].equals("-manual")) continue;
            manual = true;
        }
        JUnitCore.main((String[])new String[]{TestAWTCardLayoutAnimatorStartStopBug532.class.getName()});
    }

    public static enum AnimatorControlBehavior {
        StartStop,
        PauseResume,
        Continue;

    }
}

