/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.awt.AWTGLReadBufferUtil;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLOffscreenAutoDrawable;
import javax.media.opengl.GLProfile;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug461FBOSupersamplingSwingAWT
extends UITestCase
implements GLEventListener {
    static long durationPerTest = 500L;
    JFrame jframe;
    GLOffscreenAutoDrawable offScreenBuffer;
    AWTGLReadBufferUtil awtGLReadBufferUtil;

    private void render(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        Assert.assertNotNull((Object)gL2);
        gL2.glClear(16384);
        gL2.glBegin(4);
        gL2.glColor3f(1.0f, 0.0f, 0.0f);
        gL2.glVertex2d(-1.0, -1.0);
        gL2.glColor3f(0.0f, 1.0f, 0.0f);
        gL2.glVertex2d(0.0, 1.0);
        gL2.glColor3f(0.0f, 0.0f, 1.0f);
        gL2.glVertex2d(1.0, -1.0);
        gL2.glEnd();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.awtGLReadBufferUtil = new AWTGLReadBufferUtil(gLAutoDrawable.getGLProfile(), false);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.render((GLAutoDrawable)this.offScreenBuffer);
        BufferedImage bufferedImage = this.awtGLReadBufferUtil.readPixelsToBufferedImage(gLAutoDrawable.getGL(), 0, 0, 200, 200, true);
        Assert.assertNotNull((Object)bufferedImage);
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        final JLabel jLabel = new JLabel(imageIcon);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Container container = TestBug461FBOSupersamplingSwingAWT.this.jframe.getContentPane();
                    container.removeAll();
                    container.add(jLabel);
                    container.validate();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        try {
            this.awtGLReadBufferUtil.dispose(gLAutoDrawable.getGL());
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TestBug461FBOSupersamplingSwingAWT.this.jframe.setVisible(false);
                    TestBug461FBOSupersamplingSwingAWT.this.jframe.dispose();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Test
    public void testOffscreenSupersampling() throws InterruptedException, InvocationTargetException {
        this.jframe = new JFrame("Offscreen Supersampling");
        Assert.assertNotNull((Object)this.jframe);
        this.jframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        GLProfile gLProfile = GLProfile.get((String)"GL2");
        Assert.assertNotNull((Object)gLProfile);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLProfile);
        Assert.assertNotNull((Object)gLDrawableFactory);
        Assert.assertTrue((boolean)gLDrawableFactory.canCreateGLPbuffer(GLProfile.getDefaultDevice(), gLProfile));
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        Assert.assertNotNull((Object)gLCapabilities);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setStencilBits(1);
        this.offScreenBuffer = gLDrawableFactory.createOffscreenAutoDrawable(GLProfile.getDefaultDevice(), (GLCapabilitiesImmutable)gLCapabilities, null, 200, 200);
        Assert.assertNotNull((Object)this.offScreenBuffer);
        this.offScreenBuffer.addGLEventListener((GLEventListener)this);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                TestBug461FBOSupersamplingSwingAWT.this.jframe.setSize(300, 300);
                TestBug461FBOSupersamplingSwingAWT.this.jframe.setVisible(true);
            }
        });
        this.offScreenBuffer.display();
        this.offScreenBuffer.display();
        Thread.sleep(durationPerTest);
        this.offScreenBuffer.destroy();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atol(stringArray[++i], durationPerTest);
        }
        JUnitCore.main((String[])new String[]{TestBug461FBOSupersamplingSwingAWT.class.getName()});
    }
}

