/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug551AWT
extends UITestCase {
    static void checkGraphicsEnvironment() {
        int n;
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        System.err.println("number of graphics devices " + graphicsDeviceArray.length);
        for (n = 0; n < graphicsDeviceArray.length; ++n) {
            System.err.println(graphicsDeviceArray[n].toString());
        }
        for (n = 0; n < graphicsDeviceArray.length; ++n) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[n];
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
            for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
                System.err.println("graphics configuration for device " + n + " is: " + graphicsConfigurationArray[i].getBounds());
                rectangle = rectangle.union(graphicsConfigurationArray[i].getBounds());
            }
        }
    }

    protected void runTestGL() throws InterruptedException, InvocationTargetException {
        final JFrame jFrame = new JFrame(this.getSimpleTestName(" - "));
        final GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getGL2ES2());
        final GLCanvas[] gLCanvasArray = new GLCanvas[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                gLCanvasArray[0] = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
                gLCanvasArray[0].addGLEventListener((GLEventListener)new GearsES2());
                jFrame.add((Component)gLCanvasArray[0]);
                jFrame.setSize(512, 512);
                jFrame.validate();
                jFrame.setVisible(true);
                gLCanvasArray[0].display();
            }
        };
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                System.out.println("cleaning up...");
                jFrame.setVisible(false);
                try {
                    jFrame.removeAll();
                }
                catch (Throwable throwable) {
                    Assume.assumeNoException((Throwable)throwable);
                    throwable.printStackTrace();
                }
                jFrame.dispose();
            }
        };
        SwingUtilities.invokeAndWait(runnable);
        Animator animator = new Animator((GLAutoDrawable)gLCanvasArray[0]);
        animator.start();
        Thread.sleep(1000L);
        animator.stop();
        SwingUtilities.invokeAndWait(runnable2);
    }

    public void test01Plain() throws InterruptedException, InvocationTargetException {
        this.runTestGL();
    }

    @Test
    public void test02WithCheckGraphicsEnvironment() throws InterruptedException, InvocationTargetException {
        TestBug551AWT.checkGraphicsEnvironment();
        this.runTestGL();
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestBug551AWT.class.getName()});
    }
}

