/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.caps;

import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.awt.Screenshot;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLOffscreenAutoDrawable;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug605FlippedImageAWT
extends UITestCase {
    static final int green = 65280;
    static final int red = 0xFF0000;

    private void testFlipped(int n, int n2) {
        BufferedImage bufferedImage = Screenshot.readToBufferedImage((int)n, (int)n2);
        int n3 = bufferedImage.getRGB(0, n2 - 1) & 0xFFFFFF;
        System.err.println("below: 0x" + Integer.toHexString(n3));
        int n4 = bufferedImage.getRGB(0, 0) & 0xFFFFFF;
        System.err.println("above: 0x" + Integer.toHexString(n4));
        if (n4 == 65280 && n3 == 0xFF0000) {
            System.out.println("Image right side up");
        } else if (n4 == 0xFF0000 && n3 == 65280) {
            Assert.assertTrue((String)"Image is flipped", (boolean)false);
        } else {
            Assert.assertTrue((String)"Error in test", (boolean)false);
        }
    }

    private void test(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilitiesImmutable.getGLProfile());
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilitiesImmutable, null, 256, 256);
        FlippedImageTest flippedImageTest = new FlippedImageTest();
        gLOffscreenAutoDrawable.addGLEventListener((GLEventListener)flippedImageTest);
        gLOffscreenAutoDrawable.display();
        System.err.println("XXX " + gLOffscreenAutoDrawable.getChosenGLCapabilities());
        System.err.println("XXX " + gLOffscreenAutoDrawable.getContext().getGLVersion());
        gLOffscreenAutoDrawable.destroy();
    }

    @Test
    public void test01DefaultFBO() {
        GLProfile gLProfile = GLProfile.get((String)"GL2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setFBO(true);
        this.test((GLCapabilitiesImmutable)gLCapabilities);
    }

    @Test
    public void test01StencilFBO() {
        GLProfile gLProfile = GLProfile.get((String)"GL2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setStencilBits(8);
        gLCapabilities.setFBO(true);
        this.test((GLCapabilitiesImmutable)gLCapabilities);
    }

    @Test
    public void test01DefaultPBuffer() {
        GLProfile gLProfile = GLProfile.get((String)"GL2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setPBuffer(true);
        this.test((GLCapabilitiesImmutable)gLCapabilities);
    }

    @Test
    public void test01AccumStencilPBuffer() {
        GLProfile gLProfile = GLProfile.get((String)"GL2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAccumRedBits(16);
        gLCapabilities.setAccumGreenBits(16);
        gLCapabilities.setAccumBlueBits(16);
        gLCapabilities.setStencilBits(8);
        gLCapabilities.setPBuffer(true);
        this.test((GLCapabilitiesImmutable)gLCapabilities);
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestBug605FlippedImageAWT.class.getName()});
    }

    class FlippedImageTest
    implements GLEventListener {
        FlippedImageTest() {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            gL2.glClear(18176);
            gL2.glMatrixMode(5889);
            gL2.glLoadIdentity();
            gL2.glMatrixMode(5888);
            gL2.glLoadIdentity();
            gL2.glColor3f(1.0f, 0.0f, 0.0f);
            gL2.glRectf(-1.0f, -1.0f, 1.0f, 0.0f);
            gL2.glColor3f(0.0f, 1.0f, 0.0f);
            gL2.glRectf(-1.0f, 0.0f, 1.0f, 1.0f);
            gL2.glFinish();
            GLCapabilitiesImmutable gLCapabilitiesImmutable = gLAutoDrawable.getChosenGLCapabilities();
            if (gLCapabilitiesImmutable.getAccumGreenBits() > 0) {
                gL2.glAccum(256, 1.0f);
                gL2.glAccum(258, 1.0f);
            }
            gL2.glFinish();
            int n = gLAutoDrawable.getWidth();
            int n2 = gLAutoDrawable.getHeight();
            String string = TestBug605FlippedImageAWT.this.getSnapshotFilename(0, null, gLCapabilitiesImmutable, n, n2, false, "png", null);
            try {
                Screenshot.writeToFile((File)new File(string), (int)n, (int)n2, (boolean)false);
            }
            catch (GLException gLException) {
                throw gLException;
            }
            catch (IOException iOException) {
                throw new GLException((Throwable)iOException);
            }
            TestBug605FlippedImageAWT.this.testFlipped(n, n2);
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            System.err.println("GL_RENDERER: " + gL.glGetString(7937));
            System.err.println("GL_VERSION: " + gL.glGetString(7938));
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }
    }
}

