/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.awt;

import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.TraceKeyAdapter;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.FPSAnimator;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLJPanel;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsES2GLJPanelAWT
extends UITestCase {
    static Dimension wsize;
    static Dimension rwsize;
    static boolean forceES2;
    static boolean forceGL3;
    static boolean shallUsePBuffer;
    static boolean shallUseBitmap;
    static boolean useMSAA;
    static int swapInterval;
    static boolean useAnimator;
    static boolean manualTest;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (null == wsize) {
            wsize = new Dimension(640, 480);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    static void setFrameSize(final JFrame jFrame, final boolean bl, final Dimension dimension) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setSize(dimension);
                    if (bl) {
                        jFrame.validate();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    protected void runTestGL(GLCapabilities gLCapabilities) throws AWTException, InterruptedException, InvocationTargetException {
        long l;
        final JFrame jFrame = new JFrame("Swing GLJPanel");
        Assert.assertNotNull((Object)jFrame);
        final GLJPanel gLJPanel = new GLJPanel((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLJPanel);
        gLJPanel.setMinimumSize(wsize);
        gLJPanel.setPreferredSize(wsize);
        gLJPanel.setSize(wsize);
        if (gLCapabilities.isBitmap()) {
            gLJPanel.addGLEventListener((GLEventListener)new Gears(swapInterval));
        } else {
            gLJPanel.addGLEventListener((GLEventListener)new GearsES2(swapInterval));
        }
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        gLJPanel.addGLEventListener((GLEventListener)snapshotGLEventListener);
        FPSAnimator fPSAnimator = useAnimator ? new FPSAnimator((GLAutoDrawable)gLJPanel, 60) : null;
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.getContentPane().add((Component)gLJPanel, "Center");
                jFrame.getContentPane().validate();
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
        if (useAnimator) {
            fPSAnimator.setUpdateFPSFrames(60, System.err);
            fPSAnimator.start();
            Assert.assertEquals((Object)true, (Object)fPSAnimator.isAnimating());
        }
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTKeyAdapter((KeyListener)new TraceKeyAdapter((KeyListener)quitAdapter)).addTo((Component)gLJPanel);
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter((WindowListener)quitAdapter)).addTo((Component)jFrame);
        snapshotGLEventListener.setMakeSnapshot();
        if (null != rwsize) {
            Thread.sleep(500L);
            TestGearsES2GLJPanelAWT.setFrameSize(jFrame, true, rwsize);
            System.err.println("window resize pos/siz: " + gLJPanel.getX() + "/" + gLJPanel.getY() + " " + gLJPanel.getWidth() + "x" + gLJPanel.getHeight());
        }
        snapshotGLEventListener.setMakeSnapshot();
        long l2 = l = System.currentTimeMillis();
        boolean bl = false;
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
            snapshotGLEventListener.getDisplayCount();
            if (bl || snapshotGLEventListener.getDisplayCount() <= 1) continue;
            snapshotGLEventListener.setMakeSnapshot();
            bl = true;
        }
        Assert.assertNotNull((Object)jFrame);
        Assert.assertNotNull((Object)gLJPanel);
        Assert.assertNotNull((Object)fPSAnimator);
        if (useAnimator) {
            fPSAnimator.stop();
            Assert.assertEquals((Object)false, (Object)fPSAnimator.isAnimating());
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(false);
                jFrame.getContentPane().remove((Component)gLJPanel);
                jFrame.remove((Component)gLJPanel);
                gLJPanel.destroy();
                jFrame.dispose();
            }
        });
    }

    @Test
    public void test01_DefaultNorm() throws AWTException, InterruptedException, InvocationTargetException {
        GLProfile gLProfile = forceGL3 ? GLProfile.get((String)"GL3") : (forceES2 ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2());
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        if (useMSAA) {
            gLCapabilities.setNumSamples(4);
            gLCapabilities.setSampleBuffers(true);
        }
        if (shallUsePBuffer) {
            gLCapabilities.setPBuffer(true);
        }
        if (shallUseBitmap) {
            gLCapabilities.setBitmap(true);
        }
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test02_DefaultMsaa() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setSampleBuffers(true);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test03_PbufferNorm() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setPBuffer(true);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test04_PbufferMsaa() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setPBuffer(true);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test05_BitmapNorm() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setBitmap(true);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test06_BitmapMsaa() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setBitmap(true);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test20_GLES2() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        if (!GLProfile.isAvailable((String)"GLES2")) {
            System.err.println("GLES2 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get((String)"GLES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities);
    }

    @Test
    public void test30_GL3() throws AWTException, InterruptedException, InvocationTargetException {
        if (manualTest) {
            return;
        }
        if (!GLProfile.isAvailable((String)"GL3")) {
            System.err.println("GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get((String)"GL3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities);
    }

    public static void main(String[] stringArray) {
        int n = 640;
        int n2 = 480;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                continue;
            }
            if (stringArray[i].equals("-rwidth")) {
                n3 = MiscUtils.atoi(stringArray[++i], n3);
                continue;
            }
            if (stringArray[i].equals("-rheight")) {
                n4 = MiscUtils.atoi(stringArray[++i], n4);
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-msaa")) {
                useMSAA = true;
                continue;
            }
            if (stringArray[i].equals("-noanim")) {
                useAnimator = false;
                continue;
            }
            if (stringArray[i].equals("-pbuffer")) {
                shallUsePBuffer = true;
                continue;
            }
            if (stringArray[i].equals("-bitmap")) {
                shallUseBitmap = true;
                continue;
            }
            if (!stringArray[i].equals("-manual")) continue;
            manualTest = true;
        }
        wsize = new Dimension(n, n2);
        if (0 < n3 && 0 < n4) {
            rwsize = new Dimension(n3, n4);
        }
        System.err.println("size " + wsize);
        System.err.println("resize " + rwsize);
        System.err.println("swapInterval " + swapInterval);
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceGL3 " + forceGL3);
        System.err.println("useMSAA " + useMSAA);
        System.err.println("useAnimator " + useAnimator);
        System.err.println("shallUsePBuffer " + shallUsePBuffer);
        System.err.println("shallUseBitmap " + shallUseBitmap);
        System.err.println("manualTest " + manualTest);
        JUnitCore.main((String[])new String[]{TestGearsES2GLJPanelAWT.class.getName()});
    }

    static {
        rwsize = null;
        forceES2 = false;
        forceGL3 = false;
        shallUsePBuffer = false;
        shallUseBitmap = false;
        useMSAA = false;
        swapInterval = 0;
        useAnimator = true;
        manualTest = false;
        duration = 500L;
    }
}

