/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.newt;

import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.util.Dimension;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.util.PointImmutable;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsES2NEWT
extends UITestCase {
    static int screenIdx = 0;
    static PointImmutable wpos;
    static DimensionImmutable wsize;
    static DimensionImmutable rwsize;
    static long duration;
    static boolean opaque;
    static int forceAlpha;
    static boolean undecorated;
    static boolean alwaysOnTop;
    static boolean fullscreen;
    static boolean pmvUseBackingArray;
    static int swapInterval;
    static boolean waitForKey;
    static boolean mouseVisible;
    static boolean mouseConfined;
    static boolean showFPS;
    static int loops;
    static boolean loop_shutdown;
    static boolean forceES2;
    static boolean forceES3;
    static boolean forceGL3;
    static boolean forceGL2;
    static boolean mainRun;
    static boolean exclusiveContext;
    static boolean useAnimator;
    static SysExit sysExit;

    @BeforeClass
    public static void initClass() {
        if (null == wsize) {
            wsize = new Dimension(640, 480);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl) throws InterruptedException {
        long l;
        Animator animator;
        System.err.println("requested: vsync " + swapInterval + ", " + gLCapabilitiesImmutable);
        Display display = NewtFactory.createDisplay(null);
        Screen screen = NewtFactory.createScreen((Display)display, (int)screenIdx);
        final GLWindow gLWindow = GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)gLCapabilitiesImmutable);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle("Gears NEWT Test (translucent " + !gLCapabilitiesImmutable.isBackgroundOpaque() + "), swapInterval " + swapInterval + ", size " + wsize + ", pos " + wpos);
        gLWindow.setSize(wsize.getWidth(), wsize.getHeight());
        if (null != wpos) {
            gLWindow.setPosition(wpos.getX(), wpos.getY());
        }
        gLWindow.setUndecorated(bl);
        gLWindow.setAlwaysOnTop(alwaysOnTop);
        gLWindow.setFullscreen(fullscreen);
        gLWindow.setPointerVisible(mouseVisible);
        gLWindow.confinePointer(mouseConfined);
        final GearsES2 gearsES2 = new GearsES2(swapInterval);
        gearsES2.setPMVUseBackingArray(pmvUseBackingArray);
        gLWindow.addGLEventListener((GLEventListener)gearsES2);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        gLWindow.addGLEventListener((GLEventListener)snapshotGLEventListener);
        if (waitForKey) {
            gLWindow.addGLEventListener(new GLEventListener(){

                public void init(GLAutoDrawable gLAutoDrawable) {
                }

                public void dispose(GLAutoDrawable gLAutoDrawable) {
                }

                public void display(GLAutoDrawable gLAutoDrawable) {
                    GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                    if (waitForKey && gLAnimatorControl.getTotalFPSFrames() == 180) {
                        UITestCase.waitForKey("3s mark");
                        gLAnimatorControl.resetFPSCounter();
                        waitForKey = false;
                    }
                }

                public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                }
            });
        }
        Animator animator2 = animator = useAnimator ? new Animator() : null;
        if (useAnimator) {
            animator.setModeBits(false, 1);
            animator.setExclusiveContext(exclusiveContext);
        }
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                System.err.println("window resized: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight());
            }

            public void windowMoved(WindowEvent windowEvent) {
                System.err.println("window moved:   " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight());
            }
        });
        gLWindow.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(final KeyEvent keyEvent) {
                if (keyEvent.isAutoRepeat()) {
                    return;
                }
                if (keyEvent.getKeyChar() == 'f') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set fullscreen  pre]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                            if (gLWindow.isFullscreen()) {
                                gLWindow.setFullscreen(false);
                            } else if (keyEvent.isAltDown()) {
                                gLWindow.setFullscreen(null);
                            } else {
                                gLWindow.setFullscreen(true);
                            }
                            System.err.println("[set fullscreen post]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'a') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set alwaysontop pre]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                            gLWindow.setAlwaysOnTop(!gLWindow.isAlwaysOnTop());
                            System.err.println("[set alwaysontop post]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'd') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set undecorated  pre]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", d " + gLWindow.isUndecorated() + ", " + gLWindow.getInsets());
                            gLWindow.setUndecorated(!gLWindow.isUndecorated());
                            System.err.println("[set undecorated post]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", d " + gLWindow.isUndecorated() + ", " + gLWindow.getInsets());
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 's') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set position  pre]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", " + gLWindow.getInsets());
                            gLWindow.setPosition(100, 100);
                            System.err.println("[set position post]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", " + gLWindow.getInsets());
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'i') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set mouse visible pre]: " + gLWindow.isPointerVisible());
                            gLWindow.setPointerVisible(!gLWindow.isPointerVisible());
                            System.err.println("[set mouse visible post]: " + gLWindow.isPointerVisible());
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'j') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set mouse confined pre]: " + gLWindow.isPointerConfined());
                            gLWindow.confinePointer(!gLWindow.isPointerConfined());
                            System.err.println("[set mouse confined post]: " + gLWindow.isPointerConfined());
                            if (!gLWindow.isPointerConfined()) {
                                gearsES2.setConfinedFixedCenter(false);
                            }
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'J') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set mouse confined pre]: " + gLWindow.isPointerConfined());
                            gLWindow.confinePointer(!gLWindow.isPointerConfined());
                            System.err.println("[set mouse confined post]: " + gLWindow.isPointerConfined());
                            gearsES2.setConfinedFixedCenter(gLWindow.isPointerConfined());
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'w') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set mouse pos pre]");
                            gLWindow.warpPointer(gLWindow.getWidth() / 2, gLWindow.getHeight() / 2);
                            System.err.println("[set mouse pos post]");
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                }
            }
        });
        gLWindow.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getPointerCount() == 1) {
                    gLWindow.setFullscreen(!gLWindow.isFullscreen());
                    System.err.println("setFullscreen: " + gLWindow.isFullscreen());
                }
            }
        });
        if (useAnimator) {
            animator.add((GLAutoDrawable)gLWindow);
            animator.start();
            Assert.assertTrue((boolean)animator.isStarted());
            Assert.assertTrue((boolean)animator.isAnimating());
            Assert.assertEquals((Object)(exclusiveContext ? animator.getThread() : null), (Object)gLWindow.getExclusiveContextThread());
        }
        if (SysExit.displayError == sysExit || SysExit.displayExit == sysExit) {
            gLWindow.addGLEventListener(new GLEventListener(){

                public void init(GLAutoDrawable gLAutoDrawable) {
                }

                public void dispose(GLAutoDrawable gLAutoDrawable) {
                }

                public void display(GLAutoDrawable gLAutoDrawable) {
                    GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                    if (null != gLAnimatorControl && gLAnimatorControl.isAnimating()) {
                        if (gLAnimatorControl.getTotalFPSDuration() >= duration / 2L) {
                            if (SysExit.displayError == sysExit) {
                                throw new Error("test error send from GLEventListener");
                            }
                            if (SysExit.displayExit == sysExit) {
                                System.err.println("exit(0) send from GLEventListener");
                                System.exit(0);
                            }
                        }
                    } else {
                        System.exit(0);
                    }
                }

                public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                }
            });
        }
        gLWindow.setVisible(true);
        if (useAnimator) {
            animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        }
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", " + gLWindow.getInsets());
        snapshotGLEventListener.setMakeSnapshot();
        if (null != rwsize) {
            Thread.sleep(500L);
            gLWindow.setSize(rwsize.getWidth(), rwsize.getHeight());
            System.err.println("window resize pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", " + gLWindow.getInsets());
        }
        snapshotGLEventListener.setMakeSnapshot();
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
            if (l2 - l < duration / 2L || SysExit.testError != sysExit && SysExit.testExit != sysExit) continue;
            if (SysExit.testError == sysExit) {
                throw new Error("test error send from test thread");
            }
            if (SysExit.testExit != sysExit) continue;
            System.err.println("exit(0) send from test thread");
            System.exit(0);
        }
        if (useAnimator) {
            Assert.assertEquals((Object)(exclusiveContext ? animator.getThread() : null), (Object)gLWindow.getExclusiveContextThread());
            animator.stop();
            Assert.assertFalse((boolean)animator.isAnimating());
            Assert.assertFalse((boolean)animator.isStarted());
        }
        Assert.assertEquals(null, (Object)gLWindow.getExclusiveContextThread());
        gLWindow.destroy();
        if (NativeWindowFactory.isAWTAvailable()) {
            Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLWindow, false));
        }
    }

    @Test
    public void test01_GL2ES2() throws InterruptedException {
        for (int i = 1; i <= loops; ++i) {
            System.err.println("Loop " + i + "/" + loops);
            GLProfile gLProfile = forceGL3 ? GLProfile.get((String)"GL3") : (forceES3 ? GLProfile.get((String)"GLES3") : (forceES2 ? GLProfile.get((String)"GLES2") : (forceGL2 ? GLProfile.get((String)"GL2") : GLProfile.getGL2ES2())));
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setBackgroundOpaque(opaque);
            if (-1 < forceAlpha) {
                gLCapabilities.setAlphaBits(forceAlpha);
            }
            this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, undecorated);
            if (!loop_shutdown) continue;
            GLProfile.shutdown();
        }
    }

    @Test
    public void test02_GLES2() throws InterruptedException {
        if (mainRun) {
            return;
        }
        if (!GLProfile.isAvailable((String)"GLES2")) {
            System.err.println("GLES2 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get((String)"GLES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, undecorated);
    }

    @Test
    public void test03_GL3() throws InterruptedException {
        if (mainRun) {
            return;
        }
        if (!GLProfile.isAvailable((String)"GL3")) {
            System.err.println("GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get((String)"GL3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, undecorated);
    }

    public static void main(String[] stringArray) throws IOException {
        mainRun = true;
        int n = 0;
        int n2 = 0;
        int n3 = 640;
        int n4 = 480;
        int n5 = -1;
        int n6 = -1;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-translucent")) {
                opaque = false;
                continue;
            }
            if (stringArray[i].equals("-forceAlpha")) {
                forceAlpha = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (stringArray[i].equals("-undecorated")) {
                undecorated = true;
                continue;
            }
            if (stringArray[i].equals("-atop")) {
                alwaysOnTop = true;
                continue;
            }
            if (stringArray[i].equals("-fullscreen")) {
                fullscreen = true;
                continue;
            }
            if (stringArray[i].equals("-pmvDirect")) {
                pmvUseBackingArray = false;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-exclctx")) {
                exclusiveContext = true;
                continue;
            }
            if (stringArray[i].equals("-noanim")) {
                useAnimator = false;
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-es3")) {
                forceES3 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (stringArray[i].equals("-gl2")) {
                forceGL2 = true;
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                waitForKey = true;
                continue;
            }
            if (stringArray[i].equals("-mouseInvisible")) {
                mouseVisible = false;
                continue;
            }
            if (stringArray[i].equals("-mouseConfine")) {
                mouseConfined = true;
                continue;
            }
            if (stringArray[i].equals("-showFPS")) {
                showFPS = true;
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n3 = MiscUtils.atoi(stringArray[++i], n3);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n4 = MiscUtils.atoi(stringArray[++i], n4);
                continue;
            }
            if (stringArray[i].equals("-x")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-y")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-rwidth")) {
                n5 = MiscUtils.atoi(stringArray[++i], n5);
                continue;
            }
            if (stringArray[i].equals("-rheight")) {
                n6 = MiscUtils.atoi(stringArray[++i], n6);
                continue;
            }
            if (stringArray[i].equals("-screen")) {
                screenIdx = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (stringArray[i].equals("-loops")) {
                loops = MiscUtils.atoi(stringArray[++i], 1);
                continue;
            }
            if (stringArray[i].equals("-loop-shutdown")) {
                loop_shutdown = true;
                continue;
            }
            if (!stringArray[i].equals("-sysExit")) continue;
            sysExit = SysExit.valueOf(stringArray[++i]);
        }
        wsize = new Dimension(n3, n4);
        if (0 < n5 && 0 < n6) {
            rwsize = new Dimension(n5, n6);
        }
        if (bl) {
            wpos = new Point(n, n2);
        }
        System.err.println("position " + wpos);
        System.err.println("size " + wsize);
        System.err.println("resize " + rwsize);
        System.err.println("screen " + screenIdx);
        System.err.println("translucent " + !opaque);
        System.err.println("forceAlpha " + forceAlpha);
        System.err.println("undecorated " + undecorated);
        System.err.println("atop " + alwaysOnTop);
        System.err.println("fullscreen " + fullscreen);
        System.err.println("pmvDirect " + !pmvUseBackingArray);
        System.err.println("mouseVisible " + mouseVisible);
        System.err.println("mouseConfined " + mouseConfined);
        System.err.println("loops " + loops);
        System.err.println("loop shutdown " + loop_shutdown);
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceES3 " + forceES3);
        System.err.println("forceGL3 " + forceGL3);
        System.err.println("forceGL2 " + forceGL2);
        System.err.println("swapInterval " + swapInterval);
        System.err.println("exclusiveContext " + exclusiveContext);
        System.err.println("useAnimator " + useAnimator);
        System.err.println("sysExitWithin " + (Object)((Object)sysExit));
        if (waitForKey) {
            UITestCase.waitForKey("Start");
        }
        JUnitCore.main((String[])new String[]{TestGearsES2NEWT.class.getName()});
    }

    static {
        rwsize = null;
        duration = 500L;
        opaque = true;
        forceAlpha = -1;
        undecorated = false;
        alwaysOnTop = false;
        fullscreen = false;
        pmvUseBackingArray = true;
        swapInterval = 1;
        waitForKey = false;
        mouseVisible = true;
        mouseConfined = false;
        showFPS = false;
        loops = 1;
        loop_shutdown = false;
        forceES2 = false;
        forceES3 = false;
        forceGL3 = false;
        forceGL2 = false;
        mainRun = false;
        exclusiveContext = false;
        useAnimator = true;
        sysExit = SysExit.none;
    }

    static enum SysExit {
        none,
        testExit,
        testError,
        displayExit,
        displayError;

    }
}

