/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.newt;

import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es2.LandscapeES2;
import com.jogamp.opengl.test.junit.newt.parenting.NewtAWTReparentingKeyAdapter;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.swing.SwingUtilities;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestLandscapeES2NewtCanvasAWT
extends UITestCase {
    static DimensionImmutable wsize = new javax.media.nativewindow.util.Dimension(500, 290);
    static long duration = 500L;
    static int swapInterval = 1;
    static boolean shallUseOffscreenFBOLayer = false;
    static boolean forceES2 = false;
    static boolean forceGL3 = false;
    static boolean mainRun = false;
    static boolean exclusiveContext = false;
    static boolean useAnimator = true;

    protected void runTestGL(GLCapabilitiesImmutable gLCapabilitiesImmutable) throws InterruptedException, InvocationTargetException {
        long l;
        Animator animator;
        System.err.println("requested: vsync " + swapInterval + ", " + gLCapabilitiesImmutable);
        Display display = NewtFactory.createDisplay(null);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        final GLWindow gLWindow = GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)gLCapabilitiesImmutable);
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT((Window)gLWindow);
        if (shallUseOffscreenFBOLayer) {
            newtCanvasAWT.setShallUseOffscreenLayer(true);
        }
        final Frame frame = new Frame("AWT Parent Frame");
        Object object = new Dimension(wsize.getWidth(), wsize.getHeight());
        frame.setSize((Dimension)object);
        frame.add((Component)newtCanvasAWT);
        frame.setTitle("Gears NewtCanvasAWT Test (translucent " + !gLCapabilitiesImmutable.isBackgroundOpaque() + "), swapInterval " + swapInterval + ", size " + wsize);
        object = new LandscapeES2(swapInterval);
        gLWindow.addGLEventListener((GLEventListener)object);
        Animator animator2 = animator = useAnimator ? new Animator() : null;
        if (useAnimator) {
            animator.setModeBits(false, 1);
            animator.setExclusiveContext(exclusiveContext);
        }
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                System.err.println("window resized: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight());
            }

            public void windowMoved(WindowEvent windowEvent) {
                System.err.println("window moved:   " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight());
            }
        });
        gLWindow.addKeyListener((KeyListener)new NewtAWTReparentingKeyAdapter(frame, newtCanvasAWT, gLWindow, quitAdapter));
        if (useAnimator) {
            animator.add((GLAutoDrawable)gLWindow);
            animator.start();
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.validate();
                frame.setVisible(true);
            }
        });
        if (useAnimator) {
            animator.setUpdateFPSFrames(60, System.err);
        }
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", " + gLWindow.getInsets());
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        if (useAnimator) {
            animator.stop();
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
        gLWindow.destroy();
    }

    @Test
    public void test01GL2ES2() throws InterruptedException, InvocationTargetException {
        GLProfile gLProfile = forceGL3 ? GLProfile.get((String)"GL3") : (forceES2 ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2());
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities);
    }

    @Test
    public void test02GL3() throws InterruptedException, InvocationTargetException {
        if (mainRun) {
            return;
        }
        if (!GLProfile.isAvailable((String)"GL3")) {
            System.err.println("GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get((String)"GL3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities);
    }

    public static void main(String[] stringArray) throws IOException {
        mainRun = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-layeredFBO")) {
                shallUseOffscreenFBOLayer = true;
                continue;
            }
            if (stringArray[i].equals("-exclctx")) {
                exclusiveContext = true;
                continue;
            }
            if (stringArray[i].equals("-noanim")) {
                useAnimator = false;
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (!stringArray[i].equals("-gl3")) continue;
            forceGL3 = true;
        }
        System.err.println("size " + wsize);
        System.err.println("shallUseOffscreenFBOLayer     " + shallUseOffscreenFBOLayer);
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceGL3 " + forceGL3);
        System.err.println("swapInterval " + swapInterval);
        System.err.println("exclusiveContext " + exclusiveContext);
        System.err.println("useAnimator " + useAnimator);
        JUnitCore.main((String[])new String[]{TestLandscapeES2NewtCanvasAWT.class.getName()});
    }
}

