/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.gl3;

import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import com.jogamp.opengl.util.glsl.ShaderUtil;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GL3;
import javax.media.opengl.GLArrayData;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLUniformData;

public class GeomShader01TextureGL3
implements GLEventListener {
    private final int geomShader;
    private Texture texture;
    private ShaderState st;
    private PMVMatrix pmvMatrix;
    private GLUniformData pmvMatrixUniform;
    private GLArrayDataServer interleavedVBO;
    static final String shaderBasename = "texture01_xxx";
    static final String[] geomShaderBaseNames = new String[]{"passthrough01_xxx", "flipXYZ01_xxx"};
    private static final float[] s_triVertices = new float[]{-1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f};
    private static final float[] s_triColors = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] s_triTexCoords = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};

    public GeomShader01TextureGL3(int n) {
        this.geomShader = n;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        System.err.println("Init - START - useGeomShader " + this.geomShader + " -> " + geomShaderBaseNames[this.geomShader]);
        System.err.println("GL_VENDOR: " + gL.glGetString(7936));
        System.err.println("GL_RENDERER: " + gL.glGetString(7937));
        System.err.println("GL_VERSION: " + gL.glGetString(7938));
        System.err.println("GL GLSL: " + gL.hasGLSL() + ", has-compiler-func: " + gL.isFunctionAvailable("glCompileShader") + ", version " + (gL.hasGLSL() ? gL.glGetString(35724) : "none"));
        System.err.println("GL Profile: " + gL.getGLProfile());
        System.err.println("GL Renderer Quirks:" + gL.getContext().getRendererQuirks().toString());
        System.err.println("GL:" + gL + ", " + gL.getContext().getGLVersion());
        if (!gL.isGL3()) {
            throw new RuntimeException("GL object not a GL3 core compatible profile: " + gL);
        }
        if (!ShaderUtil.isGeometryShaderSupported((GL)gL)) {
            throw new RuntimeException("GL object not >= 3.2, i.e. no geometry shader support.: " + gL);
        }
        gL = gLAutoDrawable.getGL().getGL3();
        ShaderCode shaderCode = ShaderCode.create((GL2ES2)gL, (int)35633, this.getClass(), (String)"shader", (String)"shader/bin", (String)shaderBasename, (boolean)true);
        ShaderCode shaderCode2 = ShaderCode.create((GL2ES2)gL, (int)36313, this.getClass(), (String)"shader", (String)"shader/bin", (String)geomShaderBaseNames[this.geomShader], (boolean)true);
        ShaderCode shaderCode3 = ShaderCode.create((GL2ES2)gL, (int)35632, this.getClass(), (String)"shader", (String)"shader/bin", (String)shaderBasename, (boolean)true);
        shaderCode.defaultShaderCustomization((GL2ES2)gL, true, true);
        shaderCode2.defaultShaderCustomization((GL2ES2)gL, true, true);
        shaderCode3.defaultShaderCustomization((GL2ES2)gL, true, true);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add((GL2ES2)gL, shaderCode, System.err);
        shaderProgram.add((GL2ES2)gL, shaderCode2, System.err);
        shaderProgram.add((GL2ES2)gL, shaderCode3, System.err);
        if (!shaderProgram.link((GL2ES2)gL, System.err)) {
            throw new GLException("Couldn't link program: " + shaderProgram);
        }
        this.st = new ShaderState();
        this.st.attachShaderProgram((GL2ES2)gL, shaderProgram, true);
        this.pmvMatrix = new PMVMatrix();
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrixUniform = new GLUniformData("mgl_PMVMatrix", 4, 4, this.pmvMatrix.glGetPMvMatrixf());
        this.st.ownUniform(this.pmvMatrixUniform);
        this.st.uniform((GL2ES2)gL, this.pmvMatrixUniform);
        this.st.ownUniform(this.pmvMatrixUniform);
        if (!this.st.uniform((GL2ES2)gL, this.pmvMatrixUniform)) {
            throw new GLException("Error setting PMVMatrix in shader: " + this.st);
        }
        if (!this.st.uniform((GL2ES2)gL, new GLUniformData("mgl_ActiveTexture", 0))) {
            throw new GLException("Error setting mgl_ActiveTexture in shader: " + this.st);
        }
        try {
            this.texture = this.createTestTexture((GL3)gL);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (null == this.texture) {
            throw new RuntimeException("Could not load test texture");
        }
        int n = 0;
        shaderCode2 = this.texture.getImageTexCoords();
        GeomShader01TextureGL3.s_triTexCoords[n++] = shaderCode2.left();
        GeomShader01TextureGL3.s_triTexCoords[n++] = shaderCode2.top();
        GeomShader01TextureGL3.s_triTexCoords[n++] = shaderCode2.left();
        GeomShader01TextureGL3.s_triTexCoords[n++] = shaderCode2.bottom();
        GeomShader01TextureGL3.s_triTexCoords[n++] = shaderCode2.right();
        GeomShader01TextureGL3.s_triTexCoords[n++] = shaderCode2.bottom();
        GeomShader01TextureGL3.s_triTexCoords[n++] = shaderCode2.left();
        GeomShader01TextureGL3.s_triTexCoords[n++] = shaderCode2.top();
        GeomShader01TextureGL3.s_triTexCoords[n++] = shaderCode2.right();
        GeomShader01TextureGL3.s_triTexCoords[n++] = shaderCode2.top();
        GeomShader01TextureGL3.s_triTexCoords[n++] = shaderCode2.right();
        GeomShader01TextureGL3.s_triTexCoords[n++] = shaderCode2.bottom();
        this.interleavedVBO = GLArrayDataServer.createGLSLInterleaved((int)8, (int)5126, (boolean)false, (int)18, (int)35044);
        this.interleavedVBO.addGLSLSubArray("mgl_Vertex", 2, 34962);
        this.interleavedVBO.addGLSLSubArray("mgl_Color", 4, 34962);
        this.interleavedVBO.addGLSLSubArray("mgl_MultiTexCoord", 2, 34962);
        FloatBuffer floatBuffer = (FloatBuffer)this.interleavedVBO.getBuffer();
        for (int i = 0; i < 6; ++i) {
            floatBuffer.put(s_triVertices, i * 2, 2);
            floatBuffer.put(s_triColors, i * 4, 4);
            floatBuffer.put(s_triTexCoords, i * 2, 2);
        }
        this.interleavedVBO.seal(gL, true);
        this.interleavedVBO.enableBuffer(gL, false);
        this.st.ownAttribute((GLArrayData)this.interleavedVBO, true);
        gL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL.glClear(16640);
        this.st.useProgram((GL2ES2)gL, false);
    }

    private Texture createTestTexture(GL3 gL3) throws IOException {
        URLConnection uRLConnection = IOUtil.getResource(this.getClass(), (String)"../../util/texture/test-ntscN_3-01-160x90.png");
        if (null == uRLConnection) {
            return null;
        }
        InputStream inputStream = uRLConnection.getInputStream();
        if (null == inputStream) {
            return null;
        }
        TextureData textureData = TextureIO.newTextureData((GLProfile)gL3.getGLProfile(), (InputStream)inputStream, (boolean)false, (String)"png");
        Texture texture = TextureIO.newTexture((GL)gL3, (TextureData)textureData);
        textureData.destroy();
        return texture;
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL3 gL3 = gLAutoDrawable.getGL().getGL3();
        if (null != this.texture) {
            this.texture.disable((GL)gL3);
            this.texture.destroy((GL)gL3);
        }
        if (null != this.st) {
            this.pmvMatrixUniform = null;
            this.pmvMatrix.destroy();
            this.pmvMatrix = null;
            this.st.destroy((GL2ES2)gL3);
            this.st = null;
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL3 gL3 = gLAutoDrawable.getGL().getGL3();
        gL3.setSwapInterval(1);
        gL3.glClearColor(1.0f, 1.0f, 1.0f, 0.4f);
        if (null != this.st) {
            this.pmvMatrix.glMatrixMode(5889);
            this.pmvMatrix.glLoadIdentity();
            this.pmvMatrix.glOrthof(-1.0f, 1.0f, -1.0f, 1.0f, 0.0f, 10.0f);
            this.pmvMatrix.glMatrixMode(5888);
            this.pmvMatrix.glLoadIdentity();
            this.st.useProgram((GL2ES2)gL3, true);
            this.st.uniform((GL2ES2)gL3, this.pmvMatrixUniform);
            this.st.useProgram((GL2ES2)gL3, false);
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL3 gL3 = gLAutoDrawable.getGL().getGL3();
        gL3.glClear(16640);
        if (null != this.st) {
            this.st.useProgram((GL2ES2)gL3, true);
            this.interleavedVBO.enableBuffer((GL)gL3, true);
            gL3.glActiveTexture(33984);
            this.texture.enable((GL)gL3);
            this.texture.bind((GL)gL3);
            gL3.glDrawArrays(4, 0, 6);
            this.texture.disable((GL)gL3);
            this.interleavedVBO.enableBuffer((GL)gL3, false);
            this.st.useProgram((GL2ES2)gL3, false);
        }
    }
}

