/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.glsl;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.shader.RedSquareShader;
import com.jogamp.opengl.test.junit.util.GLSLSimpleProgram;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLSLSimple01NEWT
extends UITestCase {
    static long durationPerTest = 100L;

    @Test(timeout=60000L)
    public void testGLSLCompilation01() {
        GLProfile gLProfile = GLProfile.get((String)"GL2ES2");
        Assert.assertNotNull((Object)gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        Assert.assertNotNull((Object)gLCapabilities);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setSize(800, 600);
        gLWindow.setVisible(true);
        Assert.assertTrue((boolean)gLWindow.isNativeValid());
        GLContext gLContext = gLWindow.getContext();
        gLWindow.display();
        Assert.assertTrue((boolean)gLWindow.isRealized());
        Assert.assertTrue((boolean)gLWindow.getContext().isCreated());
        gLContext.makeCurrent();
        GL2ES2 gL2ES2 = gLContext.getGL().getGL2ES2();
        GLSLSimpleProgram gLSLSimpleProgram = GLSLSimpleProgram.create(gL2ES2, RedSquareShader.VERTEX_SHADER_TEXT, RedSquareShader.FRAGMENT_SHADER_TEXT, true);
        gLSLSimpleProgram.release(gL2ES2);
        gLContext.release();
        gLWindow.destroy();
    }

    @Test(timeout=60000L)
    public void testGLSLUse01() throws InterruptedException {
        GLProfile gLProfile = GLProfile.get((String)"GL2ES2");
        Assert.assertNotNull((Object)gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        Assert.assertNotNull((Object)gLCapabilities);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setSize(800, 600);
        gLWindow.setVisible(true);
        Assert.assertTrue((boolean)gLWindow.isNativeValid());
        gLWindow.addGLEventListener((GLEventListener)new RedSquareES2());
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        gLWindow.destroy();
        animator.stop();
    }

    public static void main(String[] stringArray) throws IOException {
        System.err.println("main - start");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atoi(stringArray[++i], (int)durationPerTest);
        }
        String string = TestGLSLSimple01NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
        System.err.println("main - end");
    }
}

