/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.glu;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLOffscreenAutoDrawable;
import javax.media.opengl.GLProfile;
import jogamp.opengl.glu.mipmap.Mipmap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug365TextureGenerateMipMaps
extends UITestCase {
    static GLOffscreenAutoDrawable drawable;

    @BeforeClass
    public static void setup() throws Throwable {
        System.setProperty("jogl.texture.nonpot", "true");
        TestBug365TextureGenerateMipMaps.setUpOffscreenAutoDrawable();
    }

    @AfterClass
    public static void teardown() {
        TestBug365TextureGenerateMipMaps.tearDownOffscreenAutoDrawable();
    }

    private static void setUpOffscreenAutoDrawable() throws Throwable {
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLProfile);
        drawable = gLDrawableFactory.createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, 2, 2);
        drawable.display();
        GLContext gLContext = drawable.getContext();
        try {
            Assert.assertTrue((String)"Could not make context current", (0 < gLContext.makeCurrent() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            TestBug365TextureGenerateMipMaps.tearDownOffscreenAutoDrawable();
            throw throwable;
        }
    }

    private static void tearDownOffscreenAutoDrawable() {
        if (drawable != null) {
            drawable.getContext().release();
            drawable.destroy();
            drawable = null;
        }
    }

    private static void testTextureMipMapGeneration(int n, int n2, int n3, int n4) {
        int n5 = n3;
        int n6 = 0;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n7 = Mipmap.image_size((int)n, (int)n2, (int)n3, (int)n4);
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)n7);
        TextureData textureData = new TextureData(drawable.getGLProfile(), n5, n, n2, n6, n3, n4, bl, bl2, bl3, (Buffer)byteBuffer, null);
        Texture texture = TextureIO.newTexture((GL)drawable.getGL(), (TextureData)textureData);
        texture.destroy(drawable.getGL());
        textureData.destroy();
        byteBuffer.clear();
        byteBuffer = null;
    }

    @Test
    public void test00_MipMap_ScaleInternal_RGB_UBYTE() {
        int n = 1;
        int n2 = 7;
        int n3 = 6407;
        int n4 = 5121;
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(n, n2, n3, n4);
    }

    @Test
    public void test01_MipMap_ScaleInternal_RGBA_UBYTE() {
        int n = 1;
        int n2 = 7;
        int n3 = 6408;
        int n4 = 5121;
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(n, n2, n3, n4);
    }

    @Test
    public void test02_MipMap_ScaleInternal_RGB_BYTE() {
        int n = 1;
        int n2 = 7;
        int n3 = 6407;
        int n4 = 5120;
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(n, n2, n3, n4);
    }

    @Test
    public void test03_MipMap_ScaleInternal_RGBA_BYTE() {
        int n = 1;
        int n2 = 7;
        int n3 = 6408;
        int n4 = 5120;
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(n, n2, n3, n4);
    }

    @Test
    public void test04_MipMap_ScaleInternal_RGB_USHORT() {
        int n = 1;
        int n2 = 7;
        int n3 = 6407;
        int n4 = 5123;
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(n, n2, n3, n4);
    }

    @Test
    public void test05_MipMap_ScaleInternal_RGBA_USHORT() {
        int n = 1;
        int n2 = 7;
        int n3 = 6408;
        int n4 = 5123;
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(n, n2, n3, n4);
    }

    @Test
    public void test06_MipMap_ScaleInternal_RGB_SHORT() {
        int n = 1;
        int n2 = 7;
        int n3 = 6407;
        int n4 = 5122;
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(n, n2, n3, n4);
    }

    @Test
    public void test07_MipMap_ScaleInternal_RGBA_SHORT() {
        int n = 1;
        int n2 = 7;
        int n3 = 6408;
        int n4 = 5122;
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(n, n2, n3, n4);
    }

    @Test
    public void test08_MipMap_ScaleInternal_RGB_UINT() {
        int n = 1;
        int n2 = 7;
        int n3 = 6407;
        int n4 = 5125;
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(n, n2, n3, n4);
    }

    @Test
    public void test09_MipMap_ScaleInternal_RGBA_UINT() {
        int n = 1;
        int n2 = 7;
        int n3 = 6408;
        int n4 = 5125;
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(n, n2, n3, n4);
    }

    @Test
    public void test10_MipMap_ScaleInternal_RGB_INT() {
        int n = 1;
        int n2 = 7;
        int n3 = 6407;
        int n4 = 5124;
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(n, n2, n3, n4);
    }

    @Test
    public void test11_MipMap_ScaleInternal_RGBA_INT() {
        int n = 1;
        int n2 = 7;
        int n3 = 6408;
        int n4 = 5124;
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(n, n2, n3, n4);
    }

    @Test
    public void test12_MipMap_ScaleInternal_RGB_FLOAT() {
        int n = 1;
        int n2 = 7;
        int n3 = 6407;
        int n4 = 5126;
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(n, n2, n3, n4);
    }

    @Test
    public void test13_MipMap_ScaleInternal_RGBA_FLOAT() {
        int n = 1;
        int n2 = 7;
        int n3 = 6408;
        int n4 = 5126;
        TestBug365TextureGenerateMipMaps.testTextureMipMapGeneration(n, n2, n3, n4);
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestBug365TextureGenerateMipMaps.class.getName()});
    }
}

