/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.offscreen;

import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.SurfaceUpdatedListener;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;

public class Surface2File
implements SurfaceUpdatedListener {
    final String filename;
    final boolean alpha;
    final GLReadBufferUtil readBufferUtil;
    int shotNum = 0;

    public Surface2File(String string, boolean bl) {
        this.filename = string;
        this.alpha = bl;
        this.readBufferUtil = new GLReadBufferUtil(bl, false);
    }

    public void dispose(GL gL) {
        this.readBufferUtil.dispose(gL);
    }

    public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        if (object instanceof GLDrawable) {
            GLDrawable gLDrawable = (GLDrawable)object;
            GLContext gLContext = GLContext.getCurrent();
            if (null != gLContext && gLContext.getGLDrawable() == gLDrawable) {
                GL gL = gLContext.getGL();
                gL.glFinish();
                if (this.readBufferUtil.readPixels(gL, false)) {
                    gL.glFinish();
                    try {
                        this.surface2File();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("can not write survace to file", iOException);
                    }
                }
            }
        }
    }

    public void surface2File() throws IOException {
        if (!this.readBufferUtil.isValid()) {
            return;
        }
        StringWriter stringWriter = new StringWriter();
        Object object = this.alpha ? "rgba" : "rgb_";
        new PrintWriter(stringWriter).printf("%s-I_%s-%04d.png", this.filename, object, this.shotNum);
        object = new File(stringWriter.toString());
        this.readBufferUtil.write((File)object);
        ++this.shotNum;
    }
}

