/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.tile;

import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.RandomTileRenderer;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLOffscreenAutoDrawable;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestRandomTiledRendering2GL2NEWT
extends UITestCase {
    static long duration = 500L;

    @Test
    public void test01_aa0() throws IOException, InterruptedException, InvocationTargetException {
        this.doTest(0);
    }

    @Test
    public void test02_aa8() throws IOException, InterruptedException, InvocationTargetException {
        this.doTest(8);
    }

    void doTest(int n) throws IOException, InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        gLCapabilities.setDoubleBuffered(true);
        if (n > 0) {
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(n);
        }
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilities.getGLProfile());
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = gLDrawableFactory.createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, 64, 64);
        final Gears gears = new Gears();
        gLOffscreenAutoDrawable.addGLEventListener((GLEventListener)gears);
        String string = this.getSnapshotFilename(0, "-tile", gLOffscreenAutoDrawable.getChosenGLCapabilities(), 1536, 1024, false, "png", null);
        File file = new File(string);
        final RandomTileRenderer randomTileRenderer = new RandomTileRenderer();
        randomTileRenderer.attachAutoDrawable((GLAutoDrawable)gLOffscreenAutoDrawable);
        randomTileRenderer.setImageSize(1536, 1024);
        final GLPixelBuffer.GLPixelBufferProvider gLPixelBufferProvider = GLPixelBuffer.defaultProviderWithRowStride;
        final boolean[] blArray = new boolean[]{false};
        GLEventListener gLEventListener = new GLEventListener(){

            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                GLPixelBuffer.GLPixelAttributes gLPixelAttributes = gLPixelBufferProvider.getAttributes(gL, 3);
                GLPixelBuffer gLPixelBuffer = gLPixelBufferProvider.allocate(gL, gLPixelAttributes, 1536, 1024, 1, true, 0);
                randomTileRenderer.setImageBuffer(gLPixelBuffer);
                blArray[0] = !gLAutoDrawable.isGLOriented();
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        };
        randomTileRenderer.setGLEventListener(gLEventListener, null);
        int n2 = 0;
        int n3 = 0;
        while (n2 + 64 <= 1536 && n3 + 64 <= 1024) {
            randomTileRenderer.display(n2, n3, 64, 64);
            if ((n2 += 96) + 64 <= 1536) continue;
            n2 = 0;
            n3 += 96;
        }
        randomTileRenderer.detachAutoDrawable();
        gLOffscreenAutoDrawable.invoke(true, new GLRunnable(){

            public boolean run(GLAutoDrawable gLAutoDrawable) {
                gLAutoDrawable.getGL().glViewport(0, 0, gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight());
                gears.reshape(gLAutoDrawable, 0, 0, gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight());
                return false;
            }
        });
        gLOffscreenAutoDrawable.destroy();
        GLPixelBuffer gLPixelBuffer = randomTileRenderer.getImageBuffer();
        gLPixelBuffer.clear();
        System.err.println("XXX2: " + gLPixelBuffer);
        TextureData textureData = new TextureData(gLCapabilities.getGLProfile(), 0, 1536, 1024, 0, gLPixelBuffer.pixelAttributes, false, false, blArray[0], gLPixelBuffer.buffer, null);
        System.err.println("XXX3: " + textureData.getPixelFormat() + ", " + textureData.getPixelAttributes());
        TextureIO.write((TextureData)textureData, (File)file);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestRandomTiledRendering2GL2NEWT.class.getName()});
    }
}

