/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.jawt.JAWTUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLReadBufferUtilTextureIOWrite01AWT
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;

    @BeforeClass
    public static void initClass() {
        glp = GLProfile.getDefault();
        Assert.assertNotNull((Object)glp);
        caps = new GLCapabilities(glp);
        Assert.assertNotNull((Object)caps);
        caps.setAlphaBits(1);
        width = 256;
        height = 256;
    }

    protected void testWritePNG_Impl(boolean bl) throws InterruptedException {
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(false, false);
        final GLReadBufferUtil gLReadBufferUtil2 = new GLReadBufferUtil(true, false);
        if (!bl && JAWTUtil.isOffscreenLayerRequired()) {
            System.err.println("onscreen layer n/a");
            return;
        }
        if (bl && !JAWTUtil.isOffscreenLayerSupported()) {
            System.err.println("offscreen layer n/a");
            return;
        }
        final GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)caps);
        gLCanvas.setShallUseOffscreenLayer(bl);
        Dimension dimension = new Dimension(width, height);
        gLCanvas.setMinimumSize(dimension);
        gLCanvas.setPreferredSize(dimension);
        final Frame frame = new Frame(this.getSimpleTestName("."));
        Assert.assertNotNull((Object)frame);
        frame.add((Component)gLCanvas);
        gLCanvas.setSize(width, height);
        gLCanvas.addGLEventListener((GLEventListener)new GearsES2(1));
        gLCanvas.addGLEventListener(new GLEventListener(){
            int f = 0;

            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                TestGLReadBufferUtilTextureIOWrite01AWT.this.snapshot(this.f, null, gLAutoDrawable.getGL(), gLReadBufferUtil2, "png", null);
                TestGLReadBufferUtilTextureIOWrite01AWT.this.snapshot(this.f, null, gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                ++this.f;
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        animator.setUpdateFPSFrames(60, null);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLCanvas, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(gLCanvas, true));
        Assert.assertEquals((Object)(JAWTUtil.isOffscreenLayerSupported() && bl ? 1 : 0), (Object)gLCanvas.isOffscreenLayerSurfaceEnabled());
        animator.start();
        while (animator.getTotalFPSFrames() < 2) {
            Thread.sleep(60L);
        }
        animator.stop();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(false);
                    frame.remove((Component)gLCanvas);
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    @Test
    public void testOnscreenWritePNG() throws InterruptedException {
        this.testWritePNG_Impl(false);
    }

    @Test
    public void testOffscreenWritePNG() throws InterruptedException {
        this.testWritePNG_Impl(true);
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestGLReadBufferUtilTextureIOWrite01AWT.class.getName()});
    }
}

