/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLWindows01NEWT
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static long durationPerTest;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glp = GLProfile.getDefault();
    }

    static GLWindow createWindow(Screen screen, GLCapabilities gLCapabilities, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws InterruptedException {
        GLWindow gLWindow;
        Assert.assertNotNull((Object)gLCapabilities);
        gLCapabilities.setOnscreen(bl);
        if (null != screen) {
            gLWindow = GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)gLCapabilities);
            Assert.assertNotNull((Object)gLWindow);
        } else {
            gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
            Assert.assertNotNull((Object)gLWindow);
        }
        gLWindow.setUndecorated(bl && bl2);
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        GearsES2 gearsES2 = new GearsES2();
        TestGLWindows01NEWT.setDemoFields(gearsES2, gLWindow);
        if (!bl3) {
            gLWindow.addGLEventListener((GLEventListener)gearsES2);
        }
        gLWindow.addWindowListener((WindowListener)new TraceWindowAdapter());
        gLWindow.setSize(n, n2);
        Assert.assertEquals((long)0L, (long)gLWindow.getTotalFPSFrames());
        gLWindow.setVisible(true);
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        System.out.println("Frames for initial setVisible(true): " + gLWindow.getTotalFPSFrames());
        Assert.assertTrue((0 < gLWindow.getTotalFPSFrames() ? 1 : 0) != 0);
        GLCapabilitiesImmutable gLCapabilitiesImmutable = gLWindow.getChosenGLCapabilities();
        Assert.assertNotNull((Object)gLCapabilitiesImmutable);
        Assert.assertTrue((gLCapabilitiesImmutable.getGreenBits() >= 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable.getBlueBits() >= 5 ? 1 : 0) != 0);
        Assert.assertTrue((gLCapabilitiesImmutable.getRedBits() >= 5 ? 1 : 0) != 0);
        Assert.assertEquals((Object)gLCapabilitiesImmutable.isOnscreen(), (Object)bl);
        if (bl3) {
            gLWindow.addGLEventListener((GLEventListener)gearsES2);
            gLWindow.display();
        }
        return gLWindow;
    }

    static void destroyWindow(GLWindow gLWindow) {
        if (null != gLWindow) {
            gLWindow.destroy();
            Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        }
    }

    @Test
    public void testWindowNativeRecreate01aSimple() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        GLWindow gLWindow = TestGLWindows01NEWT.createWindow(null, gLCapabilities, width, height, true, false, false);
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        gLWindow.destroy();
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        gLWindow.display();
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        gLWindow.setVisible(true);
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        gLWindow.setVisible(false);
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        TestGLWindows01NEWT.destroyWindow(gLWindow);
    }

    @Test
    public void testWindowNativeRecreate01bSimple() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        GLWindow gLWindow = TestGLWindows01NEWT.createWindow(null, gLCapabilities, width, height, true, false, true);
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        gLWindow.destroy();
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        gLWindow.display();
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        gLWindow.setVisible(true);
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        gLWindow.setVisible(false);
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        TestGLWindows01NEWT.destroyWindow(gLWindow);
    }

    @Test
    public void testWindowDecor01aSimple() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        GLWindow gLWindow = TestGLWindows01NEWT.createWindow(null, gLCapabilities, width, height, true, false, false);
        System.out.println("Created: " + gLWindow);
        int n = 0;
        while ((long)(n * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n;
        }
        System.out.println("duration: " + gLWindow.getTotalFPSDuration());
        TestGLWindows01NEWT.destroyWindow(gLWindow);
    }

    @Test
    public void testWindowDecor01bSimple() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        GLWindow gLWindow = TestGLWindows01NEWT.createWindow(null, gLCapabilities, width, height, true, false, true);
        System.out.println("Created: " + gLWindow);
        int n = 0;
        while ((long)(n * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n;
        }
        System.out.println("duration: " + gLWindow.getTotalFPSDuration());
        TestGLWindows01NEWT.destroyWindow(gLWindow);
    }

    @Test
    public void testWindowDecor02DestroyWinTwiceA() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        GLWindow gLWindow = TestGLWindows01NEWT.createWindow(null, gLCapabilities, width, height, true, false, false);
        int n = 0;
        while ((long)(n * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n;
        }
        System.out.println("duration: " + gLWindow.getTotalFPSDuration());
        TestGLWindows01NEWT.destroyWindow(gLWindow);
    }

    @Test
    public void testWindowDecor03TwoWinOneDisplay() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        GLWindow gLWindow = TestGLWindows01NEWT.createWindow(screen, gLCapabilities, width, height, true, false, false);
        Assert.assertNotNull((Object)gLWindow);
        GLWindow gLWindow2 = TestGLWindows01NEWT.createWindow(screen, gLCapabilities, width, height, true, false, false);
        Assert.assertNotNull((Object)gLWindow2);
        Assert.assertEquals((long)1L, (long)Display.getActiveDisplayNumber());
        Assert.assertEquals((long)1L, (long)display.getReferenceCount());
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertNotNull((Object)display.getEDTUtil());
        Assert.assertEquals((Object)true, (Object)display.getEDTUtil().isRunning());
        Assert.assertEquals((long)2L, (long)screen.getReferenceCount());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
        int n = 0;
        while ((long)(n * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n;
        }
        System.out.println("duration1: " + gLWindow.getTotalFPSDuration());
        System.out.println("duration2: " + gLWindow2.getTotalFPSDuration());
        TestGLWindows01NEWT.destroyWindow(gLWindow);
        TestGLWindows01NEWT.destroyWindow(gLWindow2);
        Assert.assertEquals((long)0L, (long)Display.getActiveDisplayNumber());
        Assert.assertEquals((long)0L, (long)display.getReferenceCount());
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        Assert.assertNotNull((Object)display.getEDTUtil());
        Assert.assertEquals((Object)false, (Object)display.getEDTUtil().isRunning());
        Assert.assertEquals((long)0L, (long)screen.getReferenceCount());
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
    }

    @Test
    public void testWindowDecor03TwoWinTwoDisplays() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        Display display = NewtFactory.createDisplay(null, (boolean)false);
        Assert.assertNotNull((Object)display);
        Display display2 = NewtFactory.createDisplay(null, (boolean)false);
        Assert.assertNotNull((Object)display2);
        Assert.assertNotSame((Object)display, (Object)display2);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        GLWindow gLWindow = TestGLWindows01NEWT.createWindow(screen, gLCapabilities, width, height, true, false, false);
        Assert.assertNotNull((Object)gLWindow);
        Screen screen2 = NewtFactory.createScreen((Display)display2, (int)0);
        Assert.assertNotNull((Object)screen2);
        GLWindow gLWindow2 = TestGLWindows01NEWT.createWindow(screen2, gLCapabilities, width, height, true, false, false);
        Assert.assertNotNull((Object)gLWindow2);
        Assert.assertEquals((long)2L, (long)Display.getActiveDisplayNumber());
        Assert.assertEquals((long)1L, (long)display.getReferenceCount());
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertNotNull((Object)display.getEDTUtil());
        Assert.assertEquals((Object)true, (Object)display.getEDTUtil().isRunning());
        Assert.assertEquals((long)1L, (long)screen.getReferenceCount());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
        Assert.assertEquals((long)1L, (long)display2.getReferenceCount());
        Assert.assertEquals((Object)true, (Object)display2.isNativeValid());
        Assert.assertNotNull((Object)display2.getEDTUtil());
        Assert.assertEquals((Object)true, (Object)display2.getEDTUtil().isRunning());
        Assert.assertEquals((long)1L, (long)screen2.getReferenceCount());
        Assert.assertEquals((Object)true, (Object)screen2.isNativeValid());
        int n = 0;
        while ((long)(n * 100) < durationPerTest) {
            Thread.sleep(100L);
            ++n;
        }
        System.out.println("duration1: " + gLWindow.getTotalFPSDuration());
        System.out.println("duration2: " + gLWindow2.getTotalFPSDuration());
        TestGLWindows01NEWT.destroyWindow(gLWindow);
        TestGLWindows01NEWT.destroyWindow(gLWindow2);
        Assert.assertEquals((long)0L, (long)Display.getActiveDisplayNumber());
        Assert.assertEquals((long)0L, (long)display.getReferenceCount());
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        Assert.assertNotNull((Object)display.getEDTUtil());
        Assert.assertEquals((Object)false, (Object)display.getEDTUtil().isRunning());
        Assert.assertEquals((long)0L, (long)screen.getReferenceCount());
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
        Assert.assertEquals((long)0L, (long)display2.getReferenceCount());
        Assert.assertEquals((Object)false, (Object)display2.isNativeValid());
        Assert.assertNotNull((Object)display2.getEDTUtil());
        Assert.assertEquals((Object)false, (Object)display2.getEDTUtil().isRunning());
        Assert.assertEquals((long)0L, (long)screen2.getReferenceCount());
        Assert.assertEquals((Object)false, (Object)screen2.isNativeValid());
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow) {
        Assert.assertNotNull((Object)gLEventListener);
        Assert.assertNotNull((Object)gLWindow);
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", gLWindow)) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestGLWindows01NEWT.atoi(stringArray[++i]);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        String string = TestGLWindows01NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        durationPerTest = 100L;
    }
}

