/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.mm;

import com.jogamp.common.os.Platform;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.util.MonitorModeUtil;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import java.util.List;
import javax.media.nativewindow.util.Dimension;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestScreenMode02bNEWT
extends UITestCase {
    static GLProfile glp;
    static int waitTimeShort;
    static int waitTimeLong;

    @BeforeClass
    public static void initClass() {
        TestScreenMode02bNEWT.setResetXRandRIfX11AfterClass();
        glp = GLProfile.getDefault();
    }

    @AfterClass
    public static void releaseClass() throws InterruptedException {
        Thread.sleep(waitTimeShort);
    }

    static GLWindow createWindow(Screen screen, GLCapabilities gLCapabilities, String string, int n, int n2, int n3, int n4) {
        Assert.assertNotNull((Object)gLCapabilities);
        GLWindow gLWindow = GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setTitle(string);
        gLWindow.setPosition(n, n2);
        gLWindow.setSize(n3, n4);
        gLWindow.addGLEventListener((GLEventListener)new GearsES2(1));
        Assert.assertNotNull((Object)gLWindow);
        return gLWindow;
    }

    static void destroyWindow(Window window) throws InterruptedException {
        if (null != window) {
            window.destroy();
            Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(window, false));
        }
    }

    @Test
    public void testScreenModeChange01_PreFull() throws InterruptedException {
        this.testScreenModeChangeImpl(true);
    }

    @Test
    public void testScreenModeChange02_PostFull() throws InterruptedException {
        this.testScreenModeChangeImpl(false);
    }

    void testScreenModeChangeImpl(boolean bl) throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        screen.createNative();
        int n = screen.getWidth();
        int n2 = screen.getHeight();
        GLWindow gLWindow = TestScreenMode02bNEWT.createWindow(screen, gLCapabilities, "win0", 0, 0, 640, 480);
        if (bl) {
            gLWindow.setVisible(true);
            gLWindow.setFullscreen(true);
        }
        gLWindow.setUndecorated(true);
        Assert.assertNotNull((Object)gLWindow);
        List list = screen.getMonitorModes();
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        if (list.size() == 1) {
            System.err.println("Your platform has no MonitorMode change support (all), sorry");
            TestScreenMode02bNEWT.destroyWindow((Window)gLWindow);
            return;
        }
        MonitorDevice monitorDevice = gLWindow.getMainMonitor();
        List list2 = monitorDevice.getSupportedModes();
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        if (list2.size() == 1) {
            System.err.println("Your platform has no MonitorMode change support (monitor), sorry");
            TestScreenMode02bNEWT.destroyWindow((Window)gLWindow);
            return;
        }
        Assert.assertTrue((boolean)list.containsAll(list2));
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.start();
        MonitorMode monitorMode = monitorDevice.queryCurrentMode();
        Assert.assertNotNull((Object)monitorMode);
        MonitorMode monitorMode2 = monitorDevice.getOriginalMode();
        Assert.assertNotNull((Object)monitorMode2);
        System.err.println("[0] orig   : " + monitorMode2);
        System.err.println("[0] current: " + monitorMode);
        Assert.assertEquals((Object)monitorMode, (Object)monitorMode2);
        list2 = MonitorModeUtil.filterByFlags((List)list2, (int)0);
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        list2 = MonitorModeUtil.filterByRotation((List)list2, (int)90);
        if (null == list2 || Platform.getOSType() == Platform.OSType.MACOS) {
            System.err.println("Your platform has no rotation support, sorry");
            animator.stop();
            TestScreenMode02bNEWT.destroyWindow((Window)gLWindow);
            return;
        }
        list2 = MonitorModeUtil.filterByResolution((List)list2, (DimensionImmutable)new Dimension(n, n2));
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        list2 = MonitorModeUtil.filterByRate((List)list2, (float)monitorMode2.getRefreshRate());
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        list2 = MonitorModeUtil.getHighestAvailableBpp((List)list2);
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        MonitorMode monitorMode3 = (MonitorMode)list2.get(0);
        System.err.println("[0] set current: " + monitorMode3);
        boolean bl2 = monitorDevice.setCurrentMode(monitorMode3);
        monitorMode = monitorDevice.getCurrentMode();
        System.err.println("[0] has current: " + monitorMode + ", changeOK " + bl2);
        if (!bl2) {
            System.err.println("ERROR: Full MonitorMode w/ rotation failure - Expected on some platforms (NV driver) - Tolerated for now.");
            animator.stop();
            TestScreenMode02bNEWT.destroyWindow((Window)gLWindow);
            return;
        }
        Assert.assertTrue((boolean)monitorDevice.isModeChangedByUs());
        Assert.assertEquals((Object)monitorMode3, (Object)monitorMode);
        Assert.assertNotSame((Object)monitorMode2, (Object)monitorMode);
        Assert.assertEquals((Object)monitorMode, (Object)monitorDevice.queryCurrentMode());
        Assert.assertTrue((boolean)bl2);
        if (!bl) {
            gLWindow.setFullscreen(true);
            gLWindow.setVisible(true);
        }
        Thread.sleep(waitTimeLong);
        if (!bl) {
            gLWindow.setFullscreen(false);
        }
        System.err.println("[1] set orig: " + monitorMode2);
        boolean bl3 = monitorDevice.setCurrentMode(monitorMode2);
        monitorMode = monitorDevice.getCurrentMode();
        System.err.println("[1] has orig?: " + monitorMode + ", changeOK " + bl3);
        Assert.assertFalse((boolean)monitorDevice.isModeChangedByUs());
        Assert.assertEquals((Object)monitorMode2, (Object)monitorMode);
        Assert.assertTrue((boolean)bl3);
        Thread.sleep(waitTimeShort);
        if (bl) {
            gLWindow.setFullscreen(false);
        }
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        animator.stop();
        TestScreenMode02bNEWT.destroyWindow((Window)gLWindow);
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(screen, false));
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestScreenMode02bNEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        waitTimeShort = 2000;
        waitTimeLong = 8000;
    }
}

