/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.common.os.Platform;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.curve.opengl.TextRenderer;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.graph.geom.opengl.SVertex;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.graph.demos.GPUTextRendererListenerBase01;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.io.IOException;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTextRendererNEWT01
extends UITestCase {
    static final boolean DEBUG = false;
    static final boolean TRACE = false;
    static long duration = 100L;

    static int atoi(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = TestTextRendererNEWT01.atoi(stringArray[++i]);
        }
        String string = TestTextRendererNEWT01.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static void sleep() {
        try {
            System.err.println("** new frame ** (sleep: " + duration + "ms)");
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void destroyWindow(GLWindow gLWindow) {
        if (null != gLWindow) {
            gLWindow.destroy();
        }
    }

    static GLWindow createWindow(String string, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, int n2) {
        Assert.assertNotNull((Object)gLCapabilitiesImmutable);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilitiesImmutable);
        gLWindow.setSize(n, n2);
        gLWindow.setPosition(10, 10);
        gLWindow.setTitle(string);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setVisible(true);
        return gLWindow;
    }

    @Test
    public void testTextRendererR2T01() throws InterruptedException {
        if (Platform.CPUFamily.X86 != Platform.CPU_ARCH.family) {
            System.err.println("disabled on non desktop (x86) arch for now ..");
            return;
        }
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        System.err.println("Requested: " + gLCapabilities);
        GLWindow gLWindow = TestTextRendererNEWT01.createWindow("text-vbaa1-msaa0", (GLCapabilitiesImmutable)gLCapabilities, 800, 400);
        gLWindow.display();
        System.err.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        RenderState renderState = RenderState.createRenderState((ShaderState)new ShaderState(), (Vertex.Factory)SVertex.factory());
        TextGLListener textGLListener = new TextGLListener(renderState, 1, false, false);
        textGLListener.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener((GLEventListener)textGLListener);
        if (textGLListener.setFontSet(0, 0, 0)) {
            textGLListener.setTech(-400.0f, -30.0f, 0.0f, -1000, gLWindow.getWidth() * 2);
            gLWindow.display();
            TestTextRendererNEWT01.sleep();
            textGLListener.setTech(-400.0f, -30.0f, 0.0f, -380, gLWindow.getWidth() * 3);
            gLWindow.display();
            TestTextRendererNEWT01.sleep();
            textGLListener.setTech(-400.0f, -20.0f, 0.0f, -80, gLWindow.getWidth() * 4);
            gLWindow.display();
            TestTextRendererNEWT01.sleep();
        }
        if (textGLListener.setFontSet(1, 0, 0)) {
            textGLListener.setTech(-400.0f, -30.0f, 0.0f, -1000, gLWindow.getWidth() * 2);
            gLWindow.display();
            TestTextRendererNEWT01.sleep();
            textGLListener.setTech(-400.0f, -30.0f, 0.0f, -380, gLWindow.getWidth() * 3);
            gLWindow.display();
            TestTextRendererNEWT01.sleep();
            textGLListener.setTech(-400.0f, -20.0f, 0.0f, -80, gLWindow.getWidth() * 4);
            gLWindow.display();
            TestTextRendererNEWT01.sleep();
        }
        TestTextRendererNEWT01.destroyWindow(gLWindow);
    }

    @Test
    public void testTextRendererMSAA01() throws InterruptedException {
        GLProfile gLProfile = GLProfile.get((String)"GL2ES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        System.err.println("Requested: " + gLCapabilities);
        GLWindow gLWindow = TestTextRendererNEWT01.createWindow("text-vbaa0-msaa1", (GLCapabilitiesImmutable)gLCapabilities, 800, 400);
        gLWindow.display();
        System.err.println("Chosen: " + gLWindow.getChosenGLCapabilities());
        RenderState renderState = RenderState.createRenderState((ShaderState)new ShaderState(), (Vertex.Factory)SVertex.factory());
        TextGLListener textGLListener = new TextGLListener(renderState, 0, false, false);
        textGLListener.attachInputListenerTo(gLWindow);
        gLWindow.addGLEventListener((GLEventListener)textGLListener);
        if (textGLListener.setFontSet(0, 0, 0)) {
            textGLListener.setTech(-400.0f, -30.0f, 0.0f, -1000, 0);
            gLWindow.display();
            TestTextRendererNEWT01.sleep();
            textGLListener.setTech(-400.0f, -30.0f, 0.0f, -380, 0);
            gLWindow.display();
            TestTextRendererNEWT01.sleep();
            textGLListener.setTech(-400.0f, -20.0f, 0.0f, -80, 0);
            gLWindow.display();
            TestTextRendererNEWT01.sleep();
        }
        if (textGLListener.setFontSet(1, 0, 0)) {
            textGLListener.setTech(-400.0f, -30.0f, 0.0f, -1000, 0);
            gLWindow.display();
            TestTextRendererNEWT01.sleep();
            textGLListener.setTech(-400.0f, -30.0f, 0.0f, -380, 0);
            gLWindow.display();
            TestTextRendererNEWT01.sleep();
            textGLListener.setTech(-400.0f, -20.0f, 0.0f, -80, 0);
            gLWindow.display();
            TestTextRendererNEWT01.sleep();
        }
        TestTextRendererNEWT01.destroyWindow(gLWindow);
    }

    private class TextGLListener
    extends GPUTextRendererListenerBase01 {
        String winTitle;

        public TextGLListener(RenderState renderState, int n, boolean bl, boolean bl2) {
            super(renderState, n, bl, bl2);
        }

        @Override
        public void attachInputListenerTo(GLWindow gLWindow) {
            super.attachInputListenerTo(gLWindow);
            this.winTitle = gLWindow.getTitle();
        }

        public void setTech(float f, float f2, float f3, int n, int n2) {
            this.setMatrix(f, f2, f3, n, n2);
        }

        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            super.init(gLAutoDrawable);
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            gL2ES2.setSwapInterval(1);
            gL2ES2.glEnable(2929);
            TextRenderer textRenderer = (TextRenderer)this.getRenderer();
            textRenderer.setAlpha(gL2ES2, 1.0f);
            textRenderer.setColorStatic(gL2ES2, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            super.display(gLAutoDrawable);
            try {
                this.printScreen(gLAutoDrawable, "./", this.winTitle, false);
            }
            catch (GLException gLException) {
                gLException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

