/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos.ui;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.test.junit.graph.demos.ui.Label;
import com.jogamp.opengl.test.junit.graph.demos.ui.UIShape;
import com.jogamp.opengl.test.junit.graph.demos.ui.opengl.UIRegion;
import javax.media.opengl.GL2ES2;

public abstract class RIButton
extends UIShape {
    private float width;
    private float height;
    private Label label;
    private float spacing = 4.0f;
    private float corner = 1.0f;
    private float labelZOffset = -0.05f;
    private float[] buttonColor = new float[]{0.6f, 0.6f, 0.6f};
    private float[] buttonSelectedColor = new float[]{0.8f, 0.8f, 0.8f};
    private float[] labelColor = new float[]{1.0f, 1.0f, 1.0f};
    private float[] labelSelectedColor = new float[]{0.1f, 0.1f, 0.1f};
    private UIRegion buttonRegion = null;
    private UIRegion labelRegion = null;
    private boolean toggle = false;
    private boolean toggleable = false;

    public RIButton(Vertex.Factory<? extends Vertex> factory, Font font, String string, float f, float f2) {
        super(factory);
        this.label = new Label(factory, font, 10, string){

            @Override
            public void onClick() {
            }

            @Override
            public void onPressed() {
            }

            @Override
            public void onRelease() {
            }
        };
        this.width = f;
        this.height = f2;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public float getCorner() {
        return this.corner;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setDimension(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.dirty |= 1;
    }

    @Override
    protected void clearImpl() {
        this.label.clear();
    }

    @Override
    protected void createShape() {
        this.label.updateShape();
        AABBox aABBox = this.label.getBounds();
        if (this.corner == 0.0f) {
            this.createSharpOutline(aABBox);
        } else {
            this.createCurvedOutline(aABBox);
        }
        float f = this.getWidth() / (2.0f * this.spacing + aABBox.getWidth());
        float f2 = this.getHeight() / (2.0f * this.spacing + aABBox.getHeight());
        this.setScale(f, f2, 1.0f);
    }

    private void createSharpOutline(AABBox aABBox) {
        float f = 2.0f * this.spacing + aABBox.getHeight();
        float f2 = 2.0f * this.spacing + aABBox.getWidth();
        float f3 = aABBox.getMinX() - this.spacing;
        float f4 = aABBox.getMinY() - this.spacing;
        float f5 = this.labelZOffset;
        this.shape.addVertex(f3, f4, f5, true);
        this.shape.addVertex(f3 + f2, f4, f5, true);
        this.shape.addVertex(f3 + f2, f4 + f, f5, true);
        this.shape.addVertex(f3, f4 + f, f5, true);
        this.shape.closeLastOutline();
    }

    private void createCurvedOutline(AABBox aABBox) {
        float f = 2.0f * this.spacing + aABBox.getHeight();
        float f2 = 2.0f * this.spacing + aABBox.getWidth();
        float f3 = 0.5f * this.corner * Math.min(f2, f);
        float f4 = 0.5f * this.corner * Math.min(f2, f);
        float f5 = aABBox.getMinX() - this.spacing;
        float f6 = aABBox.getMinY() - this.spacing;
        float f7 = this.labelZOffset;
        this.shape.addVertex(f5, f6 + f4, f7, true);
        this.shape.addVertex(f5, f6, f7, false);
        this.shape.addVertex(f5 + f3, f6, f7, true);
        this.shape.addVertex(f5 + f2 - f3, f6, f7, true);
        this.shape.addVertex(f5 + f2, f6, f7, false);
        this.shape.addVertex(f5 + f2, f6 + f4, f7, true);
        this.shape.addVertex(f5 + f2, f6 + f - f4, f7, true);
        this.shape.addVertex(f5 + f2, f6 + f, f7, false);
        this.shape.addVertex(f5 + f2 - f3, f6 + f, f7, true);
        this.shape.addVertex(f5 + f3, f6 + f, f7, true);
        this.shape.addVertex(f5, f6 + f, f7, false);
        this.shape.addVertex(f5, f6 + f - f4, f7, true);
        this.shape.closeLastOutline();
    }

    public void setCorner(float f) {
        this.corner = f > 1.0f ? 1.0f : (f < 0.01f ? 0.0f : f);
        this.dirty |= 1;
    }

    public float getLabelZOffset() {
        return this.labelZOffset;
    }

    public void setLabelZOffset(float f) {
        this.labelZOffset = -f;
        this.dirty |= 1;
    }

    public float getSpacing() {
        return this.spacing;
    }

    public void setSpacing(float f) {
        this.spacing = f < 0.0f ? 0.0f : f;
        this.dirty |= 1;
    }

    public float[] getButtonColor() {
        return this.buttonColor;
    }

    public void setButtonColor(float f, float f2, float f3) {
        this.buttonColor = new float[3];
        this.buttonColor[0] = f;
        this.buttonColor[1] = f2;
        this.buttonColor[2] = f3;
    }

    public float[] getLabelColor() {
        return this.labelColor;
    }

    @Override
    public void render(GL2ES2 gL2ES2, RenderState renderState, RegionRenderer regionRenderer, int n, int[] nArray, boolean bl) {
        if (null == this.buttonRegion) {
            this.buttonRegion = new UIRegion(this);
            this.labelRegion = new UIRegion(this.getLabel());
        }
        gL2ES2.glEnable(32823);
        gL2ES2.glPolygonOffset(0.0f, 1.0f);
        float[] fArray = this.buttonColor;
        if (this.isPressed() || this.toggle) {
            fArray = this.buttonSelectedColor;
        }
        if (!bl) {
            regionRenderer.setColorStatic(gL2ES2, fArray[0], fArray[1], fArray[2]);
        }
        regionRenderer.draw(gL2ES2, (Region)this.buttonRegion.getRegion(gL2ES2, renderState, n), this.getPosition(), nArray);
        gL2ES2.glDisable(32823);
        float[] fArray2 = this.labelColor;
        if (this.isPressed() || this.toggle) {
            fArray2 = this.labelSelectedColor;
        }
        if (!bl) {
            regionRenderer.setColorStatic(gL2ES2, fArray2[0], fArray2[1], fArray2[2]);
        }
        regionRenderer.draw(gL2ES2, (Region)this.labelRegion.getRegion(gL2ES2, renderState, n), this.getPosition(), nArray);
    }

    @Override
    public void setPressed(boolean bl) {
        super.setPressed(bl);
        if (this.isToggleable() && bl) {
            this.toggle = !this.toggle;
        }
    }

    public void setLabelColor(float f, float f2, float f3) {
        this.labelColor = new float[3];
        this.labelColor[0] = f;
        this.labelColor[1] = f2;
        this.labelColor[2] = f3;
    }

    public void setButtonSelectedColor(float f, float f2, float f3) {
        this.buttonSelectedColor = new float[3];
        this.buttonSelectedColor[0] = f;
        this.buttonSelectedColor[1] = f2;
        this.buttonSelectedColor[2] = f3;
    }

    public void setLabelSelectedColor(float f, float f2, float f3) {
        this.labelSelectedColor = new float[3];
        this.labelSelectedColor[0] = f;
        this.labelSelectedColor[1] = f2;
        this.labelSelectedColor[2] = f3;
    }

    public boolean isToggleable() {
        return this.toggleable;
    }

    public void setToggleable(boolean bl) {
        this.toggleable = bl;
    }

    public String toString() {
        return "RIButton [" + this.getWidth() + "x" + this.getHeight() + ", " + this.getLabel() + ", " + "spacing: " + this.spacing + ", " + "corner: " + this.corner + ", " + "shapeOffset: " + this.labelZOffset + " ]";
    }
}

