/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.opengl.GLAutoDrawableDelegate;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLAutoDrawableDelegateNEWT
extends UITestCase {
    static long duration = 500L;

    void doTest(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLEventListener gLEventListener) throws InterruptedException {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilitiesImmutable.getGLProfile());
        final Window window = NewtFactory.createWindow((CapabilitiesImmutable)gLCapabilitiesImmutable);
        Assert.assertNotNull((Object)window);
        window.setSize(640, 400);
        window.setVisible(true);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(window, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(window, true));
        System.out.println("Window: " + window.getClass().getName());
        GLDrawable gLDrawable = gLDrawableFactory.createGLDrawable((NativeSurface)window);
        Assert.assertNotNull((Object)gLDrawable);
        gLDrawable.setRealized(true);
        final GLAutoDrawableDelegate gLAutoDrawableDelegate = new GLAutoDrawableDelegate(gLDrawable, null, window, false, null){

            protected void destroyImplInLock() {
                super.destroyImplInLock();
                window.destroy();
            }
        };
        window.setWindowDestroyNotifyAction(new Runnable(){

            @Override
            public void run() {
                gLAutoDrawableDelegate.windowDestroyNotifyOp();
            }
        });
        window.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
                gLAutoDrawableDelegate.windowRepaintOp();
            }

            public void windowResized(WindowEvent windowEvent) {
                gLAutoDrawableDelegate.windowResizedOp(window.getWidth(), window.getHeight());
            }
        });
        gLAutoDrawableDelegate.addGLEventListener(gLEventListener);
        QuitAdapter quitAdapter = new QuitAdapter();
        window.addKeyListener((KeyListener)quitAdapter);
        window.addWindowListener((WindowListener)quitAdapter);
        Animator animator = new Animator();
        animator.setUpdateFPSFrames(60, System.err);
        animator.setModeBits(false, 1);
        animator.add((GLAutoDrawable)gLAutoDrawableDelegate);
        animator.start();
        Assert.assertTrue((boolean)animator.isStarted());
        Assert.assertTrue((boolean)animator.isAnimating());
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        System.out.println("Fin start ...");
        animator.stop();
        Assert.assertFalse((boolean)animator.isAnimating());
        Assert.assertFalse((boolean)animator.isStarted());
        gLAutoDrawableDelegate.destroy();
        System.out.println("Fin Drawable: " + gLDrawable);
        System.out.println("Fin Window: " + window);
    }

    @Test
    public void testOnScreenDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getGL2ES2());
        this.doTest((GLCapabilitiesImmutable)gLCapabilities, new GearsES2(1));
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main((String[])new String[]{TestGLAutoDrawableDelegateNEWT.class.getName()});
    }
}

